/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.filter;

import com.bes.mq.command.BESMQDestination;
import com.bes.mq.filter.DestinationMapEntry;
import com.bes.mq.filter.DestinationMapNode;
import com.bes.mq.filter.DestinationNode;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DestinationMap {
    protected static final String ANY_DESCENDENT = ">";
    protected static final String ANY_CHILD = "*";
    private DestinationMapNode queueRootNode = new DestinationMapNode(null);
    private DestinationMapNode tempQueueRootNode = new DestinationMapNode(null);
    private DestinationMapNode topicRootNode = new DestinationMapNode(null);
    private DestinationMapNode tempTopicRootNode = new DestinationMapNode(null);

    public synchronized Set get(BESMQDestination key) {
        if (key.isComposite()) {
            BESMQDestination[] destinations = key.getCompositeDestinations();
            HashSet<Set> answer = new HashSet<Set>(destinations.length);
            for (int i = 0; i < destinations.length; ++i) {
                BESMQDestination childDestination = destinations[i];
                Set value = this.get(childDestination);
                if (value instanceof Set) {
                    answer.addAll(value);
                    continue;
                }
                if (value == null) continue;
                answer.add(value);
            }
            return answer;
        }
        return this.findWildcardMatches(key);
    }

    public synchronized void put(BESMQDestination key, Object value) {
        if (key.isComposite()) {
            BESMQDestination[] destinations = key.getCompositeDestinations();
            for (int i = 0; i < destinations.length; ++i) {
                BESMQDestination childDestination = destinations[i];
                this.put(childDestination, value);
            }
            return;
        }
        String[] paths = key.getDestinationPaths();
        this.getRootNode(key).add(paths, 0, value);
    }

    public synchronized void remove(BESMQDestination key, Object value) {
        if (key.isComposite()) {
            BESMQDestination[] destinations = key.getCompositeDestinations();
            for (int i = 0; i < destinations.length; ++i) {
                BESMQDestination childDestination = destinations[i];
                this.remove(childDestination, value);
            }
            return;
        }
        String[] paths = key.getDestinationPaths();
        this.getRootNode(key).remove(paths, 0, value);
    }

    public int getTopicRootChildCount() {
        return this.topicRootNode.getChildCount();
    }

    public int getQueueRootChildCount() {
        return this.queueRootNode.getChildCount();
    }

    public DestinationMapNode getQueueRootNode() {
        return this.queueRootNode;
    }

    public DestinationMapNode getTopicRootNode() {
        return this.topicRootNode;
    }

    public DestinationMapNode getTempQueueRootNode() {
        return this.tempQueueRootNode;
    }

    public DestinationMapNode getTempTopicRootNode() {
        return this.tempTopicRootNode;
    }

    protected void setEntries(List<DestinationMapEntry> entries) {
        for (DestinationMapEntry element : entries) {
            Class<? extends DestinationMapEntry> type = this.getEntryClass();
            if (type.isInstance(element)) {
                DestinationMapEntry entry = element;
                this.put(entry.getDestination(), entry.getValue());
                continue;
            }
            throw new IllegalArgumentException("Each entry must be an instance of type: " + type.getName() + " but was: " + element);
        }
    }

    protected Class<? extends DestinationMapEntry> getEntryClass() {
        return DestinationMapEntry.class;
    }

    protected Set findWildcardMatches(BESMQDestination key) {
        String[] paths = key.getDestinationPaths();
        HashSet<DestinationNode> answer = new HashSet<DestinationNode>();
        this.getRootNode(key).appendMatchingValues(answer, paths, 0);
        return answer;
    }

    public Set removeAll(BESMQDestination key) {
        HashSet<DestinationNode> rc = new HashSet<DestinationNode>();
        if (key.isComposite()) {
            BESMQDestination[] destinations = key.getCompositeDestinations();
            for (int i = 0; i < destinations.length; ++i) {
                rc.add((DestinationNode)((Object)this.removeAll(destinations[i])));
            }
            return rc;
        }
        String[] paths = key.getDestinationPaths();
        this.getRootNode(key).removeAll(rc, paths, 0);
        return rc;
    }

    public Object chooseValue(BESMQDestination destination) {
        Set set = this.get(destination);
        if (set == null || set.isEmpty()) {
            return null;
        }
        TreeSet sortedSet = new TreeSet(set);
        return sortedSet.last();
    }

    protected DestinationMapNode getRootNode(BESMQDestination key) {
        if (key.isTemporary()) {
            if (key.isQueue()) {
                return this.tempQueueRootNode;
            }
            return this.tempTopicRootNode;
        }
        if (key.isQueue()) {
            return this.queueRootNode;
        }
        return this.topicRootNode;
    }

    public void reset() {
        this.queueRootNode = new DestinationMapNode(null);
        this.tempQueueRootNode = new DestinationMapNode(null);
        this.topicRootNode = new DestinationMapNode(null);
        this.tempTopicRootNode = new DestinationMapNode(null);
    }

    public static Set union(Set existing, Set candidates) {
        if (candidates != null) {
            if (existing != null) {
                Iterator iterator = existing.iterator();
                while (iterator.hasNext()) {
                    Object toMatch = iterator.next();
                    if (candidates.contains(toMatch)) continue;
                    iterator.remove();
                }
            } else {
                existing = candidates;
            }
        } else if (existing != null) {
            existing.clear();
        }
        return existing;
    }
}

