/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.filter;

import com.bes.mq.filter.BinaryExpression;
import com.bes.mq.filter.BooleanExpression;
import com.bes.mq.filter.MessageEvaluationContext;
import javax.jms.JMSException;

public abstract class LogicExpression
extends BinaryExpression
implements BooleanExpression {
    public LogicExpression(BooleanExpression left, BooleanExpression right) {
        super(left, right);
    }

    public static BooleanExpression createOR(BooleanExpression lvalue, BooleanExpression rvalue) {
        return new LogicExpression(lvalue, rvalue){

            public Object evaluate(MessageEvaluationContext message) throws JMSException {
                Boolean lv = (Boolean)this.left.evaluate(message);
                if (lv != null && lv.booleanValue()) {
                    return Boolean.TRUE;
                }
                Boolean rv = (Boolean)this.right.evaluate(message);
                return rv == null ? null : rv;
            }

            public String getExpressionSymbol() {
                return "OR";
            }
        };
    }

    public static BooleanExpression createAND(BooleanExpression lvalue, BooleanExpression rvalue) {
        return new LogicExpression(lvalue, rvalue){

            public Object evaluate(MessageEvaluationContext message) throws JMSException {
                Boolean lv = (Boolean)this.left.evaluate(message);
                if (lv == null) {
                    return null;
                }
                if (!lv.booleanValue()) {
                    return Boolean.FALSE;
                }
                Boolean rv = (Boolean)this.right.evaluate(message);
                return rv == null ? null : rv;
            }

            public String getExpressionSymbol() {
                return "AND";
            }
        };
    }

    public abstract Object evaluate(MessageEvaluationContext var1) throws JMSException;

    public boolean matches(MessageEvaluationContext message) throws JMSException {
        Object object = this.evaluate(message);
        return object != null && object == Boolean.TRUE;
    }
}

