/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.filter;

import com.bes.mq.command.BESMQDestination;
import com.bes.mq.command.Message;
import com.bes.mq.command.TransactionId;
import com.bes.mq.filter.Expression;
import com.bes.mq.filter.MessageEvaluationContext;
import com.bes.mq.util.JMSExceptionSupport;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.jms.JMSException;

public class PropertyExpression
implements Expression {
    private static final Map<String, SubExpression> JMS_PROPERTY_EXPRESSIONS = new HashMap<String, SubExpression>();
    private final String name;
    private final SubExpression jmsPropertyExpression;

    public PropertyExpression(String name) {
        this.name = name;
        this.jmsPropertyExpression = JMS_PROPERTY_EXPRESSIONS.get(name);
    }

    /*
     * Loose catch block
     */
    public Object evaluate(MessageEvaluationContext message) throws JMSException {
        block6: {
            if (message.isDropped()) {
                return null;
            }
            if (this.jmsPropertyExpression == null) break block6;
            return this.jmsPropertyExpression.evaluate(message.getMessage());
            {
                catch (IOException e) {
                    throw JMSExceptionSupport.create(e);
                }
            }
        }
        try {
            return message.getMessage().getProperty(this.name);
        }
        catch (IOException ioe) {
            throw JMSExceptionSupport.create("Could not get property: " + this.name + " reason: " + ioe.getMessage(), ioe);
        }
    }

    public Object evaluate(Message message) throws JMSException {
        if (this.jmsPropertyExpression != null) {
            return this.jmsPropertyExpression.evaluate(message);
        }
        try {
            return message.getProperty(this.name);
        }
        catch (IOException ioe) {
            throw JMSExceptionSupport.create(ioe);
        }
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object o) {
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        return this.name.equals(((PropertyExpression)o).name);
    }

    static {
        JMS_PROPERTY_EXPRESSIONS.put("JMSDestination", new SubExpression(){

            public Object evaluate(Message message) {
                BESMQDestination dest = message.getOriginalDestination();
                if (dest == null) {
                    dest = message.getDestination();
                }
                if (dest == null) {
                    return null;
                }
                return dest.toString();
            }
        });
        JMS_PROPERTY_EXPRESSIONS.put("JMSReplyTo", new SubExpression(){

            public Object evaluate(Message message) {
                if (message.getReplyTo() == null) {
                    return null;
                }
                return message.getReplyTo().toString();
            }
        });
        JMS_PROPERTY_EXPRESSIONS.put("JMSType", new SubExpression(){

            public Object evaluate(Message message) {
                return message.getType();
            }
        });
        JMS_PROPERTY_EXPRESSIONS.put("JMSDeliveryMode", new SubExpression(){

            public Object evaluate(Message message) {
                return message.isPersistent() ? 2 : 1;
            }
        });
        JMS_PROPERTY_EXPRESSIONS.put("JMSPriority", new SubExpression(){

            public Object evaluate(Message message) {
                return (int)message.getPriority();
            }
        });
        JMS_PROPERTY_EXPRESSIONS.put("JMSMessageID", new SubExpression(){

            public Object evaluate(Message message) {
                if (message.getMessageId() == null) {
                    return null;
                }
                return message.getMessageId().toString();
            }
        });
        JMS_PROPERTY_EXPRESSIONS.put("JMSTimestamp", new SubExpression(){

            public Object evaluate(Message message) {
                return message.getTimestamp();
            }
        });
        JMS_PROPERTY_EXPRESSIONS.put("JMSCorrelationID", new SubExpression(){

            public Object evaluate(Message message) {
                return message.getCorrelationId();
            }
        });
        JMS_PROPERTY_EXPRESSIONS.put("JMSExpiration", new SubExpression(){

            public Object evaluate(Message message) {
                return message.getExpiration();
            }
        });
        JMS_PROPERTY_EXPRESSIONS.put("JMSRedelivered", new SubExpression(){

            public Object evaluate(Message message) {
                return message.isRedelivered();
            }
        });
        JMS_PROPERTY_EXPRESSIONS.put("JMSXDeliveryCount", new SubExpression(){

            public Object evaluate(Message message) {
                return message.getRedeliveryCounter() + 1;
            }
        });
        JMS_PROPERTY_EXPRESSIONS.put("JMSXGroupID", new SubExpression(){

            public Object evaluate(Message message) {
                return message.getGroupID();
            }
        });
        JMS_PROPERTY_EXPRESSIONS.put("JMSXGroupSeq", new SubExpression(){

            public Object evaluate(Message message) {
                return new Integer(message.getGroupSequence());
            }
        });
        JMS_PROPERTY_EXPRESSIONS.put("JMSXProducerTXID", new SubExpression(){

            public Object evaluate(Message message) {
                TransactionId txId = message.getOriginalTransactionId();
                if (txId == null) {
                    txId = message.getTransactionId();
                }
                if (txId == null) {
                    return null;
                }
                return new Integer(txId.toString());
            }
        });
        JMS_PROPERTY_EXPRESSIONS.put("JMSBESMQBrokerInTime", new SubExpression(){

            public Object evaluate(Message message) {
                return message.getBrokerInTime();
            }
        });
        JMS_PROPERTY_EXPRESSIONS.put("JMSBESMQBrokerOutTime", new SubExpression(){

            public Object evaluate(Message message) {
                return message.getBrokerOutTime();
            }
        });
    }

    static interface SubExpression {
        public Object evaluate(Message var1);
    }
}

