/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.filter;

import com.bes.mq.command.Message;
import com.bes.mq.filter.XPathExpression;
import com.bes.mq.util.ByteArrayInputStream;
import java.io.InputStream;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.TextMessage;
import org.apache.xmlbeans.XmlObject;

public class XMLBeansXPathEvaluator
implements XPathExpression.XPathEvaluator {
    private final String xpath;

    public XMLBeansXPathEvaluator(String xpath) {
        this.xpath = xpath;
    }

    @Override
    public boolean evaluate(Message message) throws JMSException {
        if (message instanceof TextMessage) {
            String text = ((TextMessage)((Object)message)).getText();
            try {
                XmlObject object = XmlObject.Factory.parse((String)text);
                XmlObject[] objects = object.selectPath(this.xpath);
                return object != null && objects.length > 0;
            }
            catch (Throwable e) {
                return false;
            }
        }
        if (message instanceof BytesMessage) {
            BytesMessage bm = (BytesMessage)((Object)message);
            byte[] data = new byte[(int)bm.getBodyLength()];
            bm.readBytes(data);
            try {
                XmlObject object = XmlObject.Factory.parse((InputStream)new ByteArrayInputStream(data));
                XmlObject[] objects = object.selectPath(this.xpath);
                return object != null && objects.length > 0;
            }
            catch (Throwable e) {
                return false;
            }
        }
        return false;
    }
}

