/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.jndi;

import com.bes.mq.jndi.JNDIUtil;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class JNDIBindingRegistry {
    private Context context;

    public Object getContext() {
        return this.context;
    }

    public void setContext(Object context) {
        this.context = (Context)context;
    }

    public JNDIBindingRegistry(Context context) {
        this.context = context;
    }

    public JNDIBindingRegistry() throws Exception {
        this.context = new InitialContext();
    }

    public Object lookup(String name) {
        try {
            if (this.context == null) {
                return null;
            }
            return this.context.lookup(name);
        }
        catch (NamingException e) {
            return null;
        }
    }

    public boolean bind(String name, Object obj) {
        try {
            return this.bindToJndi(name, obj);
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
    }

    public void unbind(String name) {
        try {
            if (this.context != null) {
                this.context.unbind(name);
            }
        }
        catch (NamingException namingException) {
            // empty catch block
        }
    }

    public void close() {
        try {
            if (this.context != null) {
                this.context.close();
            }
        }
        catch (NamingException namingException) {
            // empty catch block
        }
    }

    private boolean bindToJndi(String jndiName, Object objectToBind) throws NamingException {
        if (this.context != null) {
            int sepIndex = jndiName.lastIndexOf(47);
            String parentContext = sepIndex == -1 ? "" : jndiName.substring(0, sepIndex);
            String jndiNameInContext = jndiName.substring(sepIndex + 1);
            try {
                this.context.lookup(jndiName);
                return false;
            }
            catch (Throwable e) {
                Context c = JNDIUtil.createContext(this.context, parentContext);
                c.rebind(jndiNameInContext, objectToBind);
            }
        }
        return true;
    }
}

