/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.jndi.interfaces;

import com.bes.mq.jndi.interfaces.Naming;
import com.bes.mq.jndi.interfaces.NamingContext;
import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;
import java.lang.ref.WeakReference;
import java.util.Hashtable;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;

public class LocalOnlyContextFactory
implements InitialContextFactory {
    private static final Logger log = LoggerFactory.getLogger(LocalOnlyContextFactory.class);
    private static ConcurrentHashMap<String, WeakReference<Naming>> localServers = new ConcurrentHashMap();
    private Naming naming;

    public Naming getNaming() {
        return this.naming;
    }

    public void setNaming(Naming naming) {
        this.naming = naming;
    }

    @Override
    public Context getInitialContext(Hashtable<?, ?> env) throws NamingException {
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace("getInitialContext, env: " + env);
        }
        String name = null;
        Naming localServer = null;
        if (env != null) {
            localServer = (Naming)env.get("mnp.namingInstance");
            if (trace && localServer != null) {
                log.trace("Set naming from mnp.namingInstance");
            }
            name = (String)env.get("mnp.namingInstanceName");
        }
        if (localServer == null) {
            localServer = this.naming;
            if (trace && localServer != null) {
                log.trace("Set naming from injected value");
            }
        }
        if (localServer == null && name != null) {
            WeakReference<Naming> lswr = localServers.get(name);
            if (lswr != null) {
                localServer = (Naming)lswr.get();
            }
            if (trace && localServer != null) {
                log.trace("Set naming from mnp.namingInstanceName=" + name);
            }
        }
        if (localServer == null) {
            localServer = NamingContext.getLocal();
            if (trace && localServer != null) {
                log.trace("Set naming from NamingContext.getLocal");
            }
        }
        if (localServer == null) {
            throw new NamingException("Failed to determine local server from: " + env);
        }
        if (name != null && !localServers.containsKey(name)) {
            localServers.put(name, new WeakReference<Naming>(localServer));
            if (trace) {
                log.trace("Set localServers:" + name);
            }
        }
        if (env == null) {
            env = new Hashtable();
        }
        return new NamingContext(env, null, localServer);
    }
}

