/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.jndi.interfaces;

import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Hashtable;
import javax.net.SocketFactory;

public class TimedSocketFactory
extends SocketFactory {
    private static Logger log = LoggerFactory.getLogger(TimedSocketFactory.class);
    public static final String MNP_TIMEOUT = "mnp.timeout";
    public static final String MNP_SO_TIMEOUT = "mnp.sotimeout";
    protected int timeout = 0;
    protected int soTimeout = 0;

    public TimedSocketFactory() {
    }

    public TimedSocketFactory(Hashtable<String, ?> env) {
        String value = (String)env.get(MNP_TIMEOUT);
        if (value != null) {
            this.timeout = Integer.parseInt(value);
        }
        if ((value = (String)env.get(MNP_SO_TIMEOUT)) != null) {
            this.soTimeout = Integer.parseInt(value);
        }
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        InetAddress hostAddr = InetAddress.getByName(host);
        return this.createSocket(hostAddr, port, null, 0);
    }

    @Override
    public Socket createSocket(InetAddress hostAddr, int port) throws IOException {
        return this.createSocket(hostAddr, port, null, 0);
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localAddr, int localPort) throws IOException, UnknownHostException {
        InetAddress hostAddr = InetAddress.getByName(host);
        return this.createSocket(hostAddr, port, localAddr, localPort);
    }

    @Override
    public Socket createSocket(InetAddress hostAddr, int port, InetAddress localAddr, int localPort) throws IOException {
        log.debug("createSocket, hostAddr: " + hostAddr + ", port: " + port + ", localAddr: " + localAddr + ", localPort: " + localPort + ", timeout: " + this.timeout);
        Socket socket = new Socket();
        InetSocketAddress connectAddr = new InetSocketAddress(hostAddr, port);
        if (localAddr != null) {
            InetSocketAddress bindAddr = new InetSocketAddress(localAddr, localPort);
            socket.bind(bindAddr);
        }
        socket.setSoTimeout(this.soTimeout);
        socket.connect(connectAddr, this.timeout);
        return socket;
    }
}

