/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.jndi.server;

import com.bes.mq.common.universal.net.NetUtils;
import com.bes.mq.jndi.interfaces.MarshalledValuePair;
import com.bes.mq.jndi.interfaces.Naming;
import com.bes.mq.jndi.net.sockets.DefaultSocketFactory;
import com.bes.mq.jndi.server.MainMBean;
import com.bes.mq.jndi.server.NamingBean;
import com.bes.mq.jndi.server.ThreadPoolToExecutor;
import com.bes.mq.jndi.util.threadpool.ThreadPool;
import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.rmi.MarshalledObject;
import java.rmi.Remote;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.UnicastRemoteObject;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ServerSocketFactory;

public class Main
implements MainMBean {
    protected NamingBean theServer;
    protected MarshalledObject serverStub;
    protected boolean isStubExported;
    protected ServerSocket serverSocket;
    protected RMIClientSocketFactory clientSocketFactory;
    protected RMIServerSocketFactory serverSocketFactory;
    protected ServerSocketFactory mnpServerSocketFactory;
    protected String clientSocketFactoryName;
    protected String serverSocketFactoryName;
    protected String mnpServerSocketFactoryName;
    protected InetAddress bindAddress;
    protected InetAddress rmiBindAddress;
    private boolean enableRmiServerHostname;
    protected int backlog = 50;
    protected int port = 3300;
    protected int rmiPort = 0;
    protected boolean InstallGlobalService = true;
    protected boolean UseGlobalService = true;
    protected Logger log;
    private Executor lookupExector;
    private Exception lookupListenerException;

    public static void main(String[] args) throws Exception {
        new Main().start();
    }

    public Main() {
        this("com.bes.mq.jndi.naming.Naming");
    }

    public Main(String categoryName) {
        try {
            ClassLoader loader = this.getClass().getClassLoader();
            InputStream is = loader.getResourceAsStream("mnp.properties");
            System.getProperties().load(is);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setPort(Integer.getInteger("mnp.port", this.getPort()));
        this.setRmiPort(Integer.getInteger("mnp.rmiPort", this.getRmiPort()));
        this.log = LoggerFactory.getLogger(categoryName);
        this.log.debug("Is log trace enabled: " + this.log.isTraceEnabled());
    }

    @Override
    public NamingBean getNamingInfo() {
        return this.theServer;
    }

    @Override
    public void setNamingInfo(NamingBean info) {
        this.theServer = info;
    }

    @Deprecated
    public void setLookupPool(ThreadPool lookupPool) {
        this.lookupExector = new ThreadPoolToExecutor(lookupPool);
    }

    public Executor getLookupExector() {
        return this.lookupExector;
    }

    public void setLookupExector(Executor lookupExector) {
        this.lookupExector = lookupExector;
    }

    @Override
    public Exception getLookupListenerException() {
        return this.lookupListenerException;
    }

    @Override
    public boolean getCallByValue() {
        return !MarshalledValuePair.getEnableCallByReference();
    }

    @Override
    public void setCallByValue(boolean flag) {
        boolean callByValue = !flag;
        MarshalledValuePair.setEnableCallByReference(callByValue);
    }

    @Override
    public Object getNamingProxy() throws Exception {
        return this.serverStub.get();
    }

    @Override
    public void setNamingProxy(Object proxy) throws IOException {
        this.serverStub = new MarshalledObject<Object>(proxy);
    }

    @Override
    public void setRmiPort(int p) {
        this.rmiPort = p;
    }

    @Override
    public int getRmiPort() {
        return this.rmiPort;
    }

    @Override
    public void setPort(int p) {
        this.port = p;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public String getBindAddress() {
        String address = null;
        if (this.bindAddress != null) {
            address = this.bindAddress.getHostAddress();
        }
        return address;
    }

    @Override
    public void setBindAddress(String host) throws UnknownHostException {
        this.bindAddress = host == null || host.length() == 0 ? null : InetAddress.getByName(host);
    }

    @Override
    public String getRmiBindAddress() {
        String address = null;
        if (this.rmiBindAddress != null) {
            address = this.rmiBindAddress.getHostAddress();
        }
        return address;
    }

    @Override
    public void setRmiBindAddress(String host) {
        if (host != null && host.length() > 0) {
            if (!NetUtils.isLocalAddress(host)) {
                return;
            }
            try {
                this.rmiBindAddress = InetAddress.getByName(host);
            }
            catch (UnknownHostException e) {
                this.rmiBindAddress = null;
            }
        }
    }

    @Override
    public String getBootstrapURL() {
        if (this.serverSocket == null || this.serverSocket.getInetAddress() == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder("bmq://");
        InetAddress addr = this.serverSocket.getInetAddress();
        if (addr instanceof Inet6Address) {
            sb.append('[');
            sb.append(addr.getHostAddress());
            sb.append(']');
        } else {
            sb.append(addr.getHostAddress());
        }
        sb.append(':');
        sb.append(this.port);
        return sb.toString();
    }

    public boolean isEnableRmiServerHostname() {
        return this.enableRmiServerHostname;
    }

    public void setEnableRmiServerHostname(boolean enableRmiServerHostname) {
        this.enableRmiServerHostname = enableRmiServerHostname;
    }

    @Override
    public int getBacklog() {
        return this.backlog;
    }

    @Override
    public void setBacklog(int backlog) {
        if (backlog <= 0) {
            backlog = 50;
        }
        this.backlog = backlog;
    }

    @Override
    public boolean getInstallGlobalService() {
        return this.InstallGlobalService;
    }

    @Override
    public void setInstallGlobalService(boolean flag) {
        this.InstallGlobalService = flag;
    }

    @Override
    public boolean getUseGlobalService() {
        return this.UseGlobalService;
    }

    @Override
    public void setUseGlobalService(boolean flag) {
        this.UseGlobalService = flag;
    }

    @Override
    public String getClientSocketFactory() {
        return this.clientSocketFactoryName;
    }

    @Override
    public void setClientSocketFactory(String factoryClassName) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        this.clientSocketFactoryName = factoryClassName;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Class<?> clazz = loader.loadClass(this.clientSocketFactoryName);
        this.clientSocketFactory = (RMIClientSocketFactory)clazz.newInstance();
    }

    @Override
    public RMIClientSocketFactory getClientSocketFactoryBean() {
        return this.clientSocketFactory;
    }

    @Override
    public void setClientSocketFactoryBean(RMIClientSocketFactory factory) {
        this.clientSocketFactory = factory;
    }

    @Override
    public String getServerSocketFactory() {
        return this.serverSocketFactoryName;
    }

    @Override
    public void setServerSocketFactory(String factoryClassName) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        this.serverSocketFactoryName = factoryClassName;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Class<?> clazz = loader.loadClass(this.serverSocketFactoryName);
        this.serverSocketFactory = (RMIServerSocketFactory)clazz.newInstance();
    }

    @Override
    public RMIServerSocketFactory getServerSocketFactoryBean() {
        return this.serverSocketFactory;
    }

    @Override
    public void setServerSocketFactoryBean(RMIServerSocketFactory factory) {
        this.serverSocketFactory = factory;
    }

    @Override
    public String getMNPServerSocketFactory() {
        return this.mnpServerSocketFactoryName;
    }

    @Override
    public void setMNPServerSocketFactory(String factoryClassName) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        this.mnpServerSocketFactoryName = factoryClassName;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Class<?> clazz = loader.loadClass(this.mnpServerSocketFactoryName);
        this.mnpServerSocketFactory = (ServerSocketFactory)clazz.newInstance();
    }

    @Override
    public ServerSocketFactory getMNPServerSocketFactoryBean() {
        return this.mnpServerSocketFactory;
    }

    @Override
    public void setMNPServerSocketFactoryBean(ServerSocketFactory factory) {
        this.mnpServerSocketFactory = factory;
    }

    @Override
    public Naming getNamingInstance() {
        return this.theServer.getNamingInstance();
    }

    @Override
    public void start() throws Exception {
        this.log.debug("Begin start");
        if (this.rmiBindAddress != null && System.getProperty("java.rmi.server.hostname") == null) {
            System.setProperty("java.rmi.server.hostname", this.rmiBindAddress.getHostAddress());
        }
        this.initCustomSocketFactories();
        if (this.serverStub == null && this.port >= 0) {
            this.initMNPInvoker();
        }
        if (this.serverStub != null) {
            this.initBootstrapListener();
        }
        this.log.debug("End start");
    }

    @Override
    public void stop() {
        try {
            if (this.serverSocket != null) {
                ServerSocket s = this.serverSocket;
                this.serverSocket = null;
                s.close();
            }
            if (this.isStubExported) {
                UnicastRemoteObject.unexportObject(this.theServer.getNamingInstance(), false);
            }
        }
        catch (Exception e) {
            this.log.error("Exception during shutdown", e);
        }
    }

    protected void initMNPInvoker() throws IOException {
        this.log.debug("Creating NamingServer stub, theServer=" + this.theServer + ",rmiPort=" + this.rmiPort + ",clientSocketFactory=" + this.clientSocketFactory + ",serverSocketFactory=" + this.serverSocketFactory);
        Naming instance = this.getNamingInstance();
        Remote stub = UnicastRemoteObject.exportObject(instance, this.rmiPort, this.clientSocketFactory, this.serverSocketFactory);
        this.log.debug("NamingServer stub: " + stub);
        this.serverStub = new MarshalledObject<Remote>(stub);
        this.isStubExported = true;
    }

    protected void initBootstrapListener() throws IOException {
        try {
            if (this.mnpServerSocketFactory == null) {
                this.mnpServerSocketFactory = ServerSocketFactory.getDefault();
            }
            this.serverSocket = this.mnpServerSocketFactory.createServerSocket(this.port, this.backlog, this.bindAddress);
            if (this.port == 0) {
                this.port = this.serverSocket.getLocalPort();
            }
            String msg = "JNDI bootstrap MNP=" + this.bindAddress + ":" + this.port + ", RMI=" + this.bindAddress + ":" + this.rmiPort + ", backlog=" + this.backlog;
            msg = this.clientSocketFactory == null ? msg + ", no client SocketFactory" : msg + ", Client SocketFactory=" + this.clientSocketFactory.toString();
            msg = this.serverSocketFactory == null ? msg + ", no server SocketFactory" : msg + ", Server SocketFactory=" + this.serverSocketFactory.toString();
            this.log.debug(msg);
        }
        catch (IOException e) {
            this.lookupListenerException = e;
            throw new IOException("Could not start on port " + this.port, e);
        }
        if (this.lookupExector == null) {
            this.log.debug("Using default newFixedThreadPool(2)");
            this.lookupExector = Executors.newFixedThreadPool(2, BootstrapThreadFactory.getInstance());
        }
        AcceptHandler handler = new AcceptHandler();
        this.lookupExector.execute(handler);
    }

    protected void initCustomSocketFactories() {
        Object[] args;
        Method m;
        Class[] parameterTypes;
        InetAddress addr;
        InetAddress inetAddress = addr = this.rmiBindAddress != null ? this.rmiBindAddress : this.bindAddress;
        if (this.clientSocketFactory != null && addr != null) {
            try {
                Class<?> csfClass = this.clientSocketFactory.getClass();
                parameterTypes = new Class[]{String.class};
                m = csfClass.getMethod("setBindAddress", parameterTypes);
                args = new Object[]{addr.getHostAddress()};
                m.invoke((Object)this.clientSocketFactory, args);
            }
            catch (NoSuchMethodException e) {
                this.log.warn("Socket factory does not support setBindAddress(String)");
            }
            catch (Exception e) {
                this.log.warn("Failed to setBindAddress=" + addr + " on socket factory", e);
            }
        }
        try {
            if (this.serverSocketFactory == null) {
                this.serverSocketFactory = new DefaultSocketFactory(addr);
            } else if (addr != null) {
                try {
                    Class<?> ssfClass = this.serverSocketFactory.getClass();
                    parameterTypes = new Class[]{String.class};
                    m = ssfClass.getMethod("setBindAddress", parameterTypes);
                    args = new Object[]{addr.getHostAddress()};
                    m.invoke((Object)this.serverSocketFactory, args);
                }
                catch (NoSuchMethodException e) {
                    this.log.warn("Socket factory does not support setBindAddress(String)");
                }
                catch (Exception e) {
                    this.log.warn("Failed to setBindAddress=" + addr + " on socket factory", e);
                }
            }
        }
        catch (Exception e) {
            this.log.error("Failed", e);
            this.serverSocketFactory = null;
        }
    }

    private static class BootstrapThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger tnumber = new AtomicInteger(1);
        static BootstrapThreadFactory instance;

        private BootstrapThreadFactory() {
        }

        static synchronized ThreadFactory getInstance() {
            if (instance == null) {
                instance = new BootstrapThreadFactory();
            }
            return instance;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, "Naming Bootstrap#" + tnumber.getAndIncrement());
            return t;
        }
    }

    private class BootstrapRequestHandler
    implements Runnable {
        private Socket socket;

        BootstrapRequestHandler(Socket socket) {
            this.socket = socket;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                if (Main.this.log.isTraceEnabled()) {
                    Main.this.log.trace("BootstrapRequestHandler.run start");
                }
                OutputStream os = this.socket.getOutputStream();
                ObjectOutputStream out = new ObjectOutputStream(os);
                out.writeObject(Main.this.serverStub);
                out.close();
                if (Main.this.log.isTraceEnabled()) {
                    Main.this.log.trace("BootstrapRequestHandler.run end");
                }
            }
            catch (IOException ex) {
                Main.this.log.debug("Error writing response to " + this.socket.getInetAddress(), ex);
            }
            finally {
                try {
                    this.socket.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private class AcceptHandler
    implements Runnable {
        private AcceptHandler() {
        }

        @Override
        public void run() {
            boolean trace = Main.this.log.isTraceEnabled();
            while (Main.this.serverSocket != null) {
                Socket socket = null;
                try {
                    if (trace) {
                        Main.this.log.trace("Enter accept on: " + Main.this.serverSocket);
                    }
                    socket = Main.this.serverSocket.accept();
                    if (trace) {
                        Main.this.log.trace("Accepted bootstrap client: " + socket);
                    }
                    BootstrapRequestHandler handler = new BootstrapRequestHandler(socket);
                    Main.this.lookupExector.execute(handler);
                }
                catch (IOException e) {
                    if (Main.this.serverSocket == null) {
                        return;
                    }
                    Main.this.log.error("Naming accept handler stopping", e);
                }
                catch (Throwable e) {
                    Main.this.log.error("Unexpected exception during accept", e);
                }
            }
        }
    }
}

