/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.jndi.server;

import com.bes.mq.jndi.interfaces.Naming;
import com.bes.mq.jndi.interfaces.NamingContext;
import com.bes.mq.jndi.naming.ENCFactory;
import com.bes.mq.jndi.server.EventMgr;
import com.bes.mq.jndi.server.Main;
import com.bes.mq.jndi.server.NamingBean;
import com.bes.mq.jndi.server.NamingServer;
import com.bes.mq.jndi.server.NamingServerWrapper;
import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Reference;
import javax.naming.StringRefAddr;

public class NamingBeanImpl
implements NamingBean {
    private static Logger log = LoggerFactory.getLogger(NamingBeanImpl.class);
    protected Naming theServer;
    protected boolean InstallGlobalService = true;
    protected boolean UseGlobalService = true;
    private EventMgr eventMgr;
    private SecurityManager securityMgr;
    private boolean installJavaComp = true;

    public static void main(String[] args) throws Exception {
        new Main().start();
    }

    @Override
    public Naming getNamingInstance() {
        return this.theServer;
    }

    public boolean getInstallGlobalService() {
        return this.InstallGlobalService;
    }

    public void setInstallGlobalService(boolean flag) {
        this.InstallGlobalService = flag;
    }

    public boolean getUseGlobalService() {
        return this.UseGlobalService;
    }

    public void setUseGlobalService(boolean flag) {
        this.UseGlobalService = flag;
    }

    public EventMgr getEventMgr() {
        return this.eventMgr;
    }

    public void setEventMgr(EventMgr eventMgr) {
        this.eventMgr = eventMgr;
    }

    public SecurityManager getSecurityMgr() {
        return this.securityMgr;
    }

    public void setSecurityMgr(SecurityManager securityMgr) {
        this.securityMgr = securityMgr;
    }

    protected Naming createServer() throws Exception {
        return new NamingServer(null, null, this.eventMgr, this.securityMgr);
    }

    public boolean getInstallJavaComp() {
        return this.installJavaComp;
    }

    public void setInstallJavaComp(boolean b) {
        this.installJavaComp = b;
    }

    public void start() throws Exception {
        if (this.theServer == null) {
            if (this.UseGlobalService) {
                this.theServer = NamingContext.getLocal();
            }
            if (this.theServer == null) {
                this.theServer = this.createServer();
            } else {
                NamingServerWrapper wrapper = new NamingServerWrapper(this.theServer);
                this.theServer = wrapper;
            }
            log.debug("Using NamingServer: " + this.theServer);
            if (this.InstallGlobalService) {
                NamingContext.setLocal(this.theServer);
                log.debug("Installed global NamingServer: " + this.theServer);
            }
        }
        InitialContext iniCtx = new InitialContext();
        Hashtable<?, ?> env = iniCtx.getEnvironment();
        log.debug("InitialContext Environment: ");
        Object providerURL = null;
        for (Object key : env.keySet()) {
            Object value = env.get(key);
            String type = value == null ? "" : value.getClass().getName();
            log.debug("key=" + key + ", value(" + type + ")=" + value);
            if (!key.equals("java.naming.provider.url")) continue;
            providerURL = value;
        }
        if (providerURL != null) {
            log.warn("Context.PROVIDER_URL in server jndi.properties, url=" + providerURL);
        }
        if (this.installJavaComp) {
            ClassLoader topLoader = Thread.currentThread().getContextClassLoader();
            ENCFactory.setTopClassLoader(topLoader);
            StringRefAddr refAddr = new StringRefAddr("nns", "ENC");
            Reference envRef = new Reference("javax.namingMain.Context", refAddr, ENCFactory.class.getName(), null);
            Context ctx = (Context)iniCtx.lookup("java:");
            ctx.rebind("comp", (Object)envRef);
            ctx.close();
        }
        iniCtx.close();
    }

    public void stop() {
        if (NamingContext.getLocal() == this.theServer) {
            NamingContext.setLocal(null);
        }
    }
}

