/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.jndi.util.collection;

import com.bes.mq.jndi.util.collection.ValueRef;
import java.lang.ref.ReferenceQueue;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;

public abstract class ReferenceValueMap<K, V>
extends AbstractMap<K, V> {
    private Map<K, ValueRef<K, V>> map;
    private ReferenceQueue<V> queue = new ReferenceQueue();

    protected ReferenceValueMap() {
        this.map = this.createMap();
    }

    protected ReferenceValueMap(int initialCapacity) {
        this.map = this.createMap(initialCapacity);
    }

    protected ReferenceValueMap(int initialCapacity, float loadFactor) {
        this.map = this.createMap(initialCapacity, loadFactor);
    }

    protected ReferenceValueMap(Map<K, V> t) {
        this(Math.max(2 * t.size(), 11), 0.75f);
        this.putAll(t);
    }

    protected ReferenceValueMap(Comparator<K> comparator) {
        this.map = this.createMap(comparator);
    }

    protected ReferenceValueMap(SortedMap<K, ValueRef<K, V>> sorted) {
        this.map = this.createMap(sorted);
    }

    protected abstract Map<K, ValueRef<K, V>> createMap();

    protected abstract Map<K, ValueRef<K, V>> createMap(int var1);

    protected abstract Map<K, ValueRef<K, V>> createMap(int var1, float var2);

    protected abstract Map<K, ValueRef<K, V>> createMap(Comparator<K> var1);

    protected abstract Map<K, ValueRef<K, V>> createMap(SortedMap<K, ValueRef<K, V>> var1);

    @Override
    public int size() {
        this.processQueue();
        return this.map.size();
    }

    @Override
    public boolean containsKey(Object key) {
        this.processQueue();
        return this.map.containsKey(key);
    }

    @Override
    public V get(Object key) {
        this.processQueue();
        ValueRef<K, V> ref = this.map.get(key);
        if (ref != null) {
            return ref.get();
        }
        return null;
    }

    @Override
    public V put(K key, V value) {
        this.processQueue();
        ValueRef<K, V> ref = this.create(key, value, this.queue);
        ValueRef<K, V> result = this.map.put(key, ref);
        if (result != null) {
            return result.get();
        }
        return null;
    }

    @Override
    public V remove(Object key) {
        this.processQueue();
        ValueRef<K, V> result = this.map.remove(key);
        if (result != null) {
            return result.get();
        }
        return null;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        this.processQueue();
        return new EntrySet();
    }

    @Override
    public void clear() {
        this.processQueue();
        this.map.clear();
    }

    private void processQueue() {
        ValueRef ref = (ValueRef)((Object)this.queue.poll());
        while (ref != null) {
            if (ref == this.map.get(ref.getKey())) {
                this.map.remove(ref.getKey());
            }
            ref = (ValueRef)((Object)this.queue.poll());
        }
    }

    protected abstract ValueRef<K, V> create(K var1, V var2, ReferenceQueue<V> var3);

    @Override
    public String toString() {
        return this.map.toString();
    }

    private class EntrySetIterator
    implements Iterator<Map.Entry<K, V>> {
        private Iterator<Map.Entry<K, ValueRef<K, V>>> delegate;

        public EntrySetIterator(Iterator<Map.Entry<K, ValueRef<K, V>>> delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public Map.Entry<K, V> next() {
            Map.Entry next = this.delegate.next();
            return next.getValue();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntrySetIterator(ReferenceValueMap.this.map.entrySet().iterator());
        }

        @Override
        public int size() {
            return ReferenceValueMap.this.size();
        }
    }
}

