/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.management;

import com.bes.mq.BESMQConnection;
import com.bes.mq.management.JMSConnectionStatsImpl;
import com.bes.mq.management.StatsImpl;
import com.bes.mq.util.IndentPrinter;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class JMSStatsImpl
extends StatsImpl {
    private List<BESMQConnection> connections = new CopyOnWriteArrayList<BESMQConnection>();

    public JMSConnectionStatsImpl[] getConnections() {
        Object[] connectionArray = this.connections.toArray();
        int size = connectionArray.length;
        JMSConnectionStatsImpl[] answer = new JMSConnectionStatsImpl[size];
        for (int i = 0; i < size; ++i) {
            BESMQConnection connection = (BESMQConnection)connectionArray[i];
            answer[i] = connection.getConnectionStats();
        }
        return answer;
    }

    public void addConnection(BESMQConnection connection) {
        this.connections.add(connection);
    }

    public void removeConnection(BESMQConnection connection) {
        this.connections.remove(connection);
    }

    public void dump(IndentPrinter out) {
        out.printIndent();
        out.println("factory {");
        out.incrementIndent();
        JMSConnectionStatsImpl[] array = this.getConnections();
        for (int i = 0; i < array.length; ++i) {
            JMSConnectionStatsImpl connectionStat = array[i];
            connectionStat.dump(out);
        }
        out.decrementIndent();
        out.printIndent();
        out.println("}");
        out.flush();
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        JMSConnectionStatsImpl[] stats = this.getConnections();
        int size = stats.length;
        for (int i = 0; i < size; ++i) {
            stats[i].setEnabled(enabled);
        }
    }
}

