/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.memory.list;

import com.bes.mq.broker.region.MessageReference;
import com.bes.mq.broker.region.Subscription;
import com.bes.mq.command.BESMQDestination;
import com.bes.mq.command.BESMQMessage;
import com.bes.mq.command.Message;
import com.bes.mq.filter.DestinationMap;
import com.bes.mq.memory.buffer.MessageBuffer;
import com.bes.mq.memory.buffer.MessageQueue;
import com.bes.mq.memory.buffer.OrderBasedMessageBuffer;
import com.bes.mq.memory.list.MessageList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DestinationBasedMessageList
implements MessageList {
    private MessageBuffer messageBuffer;
    private Map<BESMQDestination, MessageQueue> queueIndex = new HashMap<BESMQDestination, MessageQueue>();
    private DestinationMap subscriptionIndex = new DestinationMap();
    private Object lock = new Object();

    public DestinationBasedMessageList(int maximumSize) {
        this(new OrderBasedMessageBuffer(maximumSize));
    }

    public DestinationBasedMessageList(MessageBuffer buffer) {
        this.messageBuffer = buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(MessageReference node) {
        BESMQMessage message = (BESMQMessage)node.getMessageHardRef();
        BESMQDestination destination = message.getDestination();
        MessageQueue queue = null;
        Object object = this.lock;
        synchronized (object) {
            queue = this.queueIndex.get(destination);
            if (queue == null) {
                queue = this.messageBuffer.createMessageQueue();
                this.queueIndex.put(destination, queue);
                this.subscriptionIndex.put(destination, queue);
            }
        }
        queue.add(node);
    }

    public List<MessageReference> getMessages(Subscription sub) {
        return this.getMessages(sub.getConsumerInfo().getDestination());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<MessageReference> getMessages(BESMQDestination destination) {
        Set set = null;
        Object object = this.lock;
        synchronized (object) {
            set = this.subscriptionIndex.get(destination);
        }
        ArrayList<MessageReference> answer = new ArrayList<MessageReference>();
        for (MessageQueue queue : set) {
            queue.appendMessages(answer);
        }
        return answer;
    }

    @Override
    public Message[] browse(BESMQDestination destination) {
        List<MessageReference> result = this.getMessages(destination);
        return result.toArray(new Message[result.size()]);
    }

    @Override
    public void clear() {
        this.messageBuffer.clear();
    }
}

