/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.memory.list;

import com.bes.mq.broker.region.MessageReference;
import com.bes.mq.command.BESMQDestination;
import com.bes.mq.command.Message;
import com.bes.mq.filter.DestinationFilter;
import com.bes.mq.memory.list.MessageList;
import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleMessageList
implements MessageList {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleMessageList.class);
    private final LinkedList<MessageReference> list = new LinkedList();
    private int maximumSize = 0x640000;
    private int size;
    private final Object lock = new Object();

    public SimpleMessageList() {
    }

    public SimpleMessageList(int maximumSize) {
        this.maximumSize = maximumSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(MessageReference node) {
        int delta = node.getMessageHardRef().getSize();
        Object object = this.lock;
        synchronized (object) {
            this.list.add(node);
            this.size += delta;
            while (this.size > this.maximumSize) {
                MessageReference evicted = this.list.removeFirst();
                this.size -= evicted.getMessageHardRef().getSize();
            }
        }
    }

    @Override
    public List<MessageReference> getMessages(BESMQDestination destination) {
        return this.getList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Message[] browse(BESMQDestination destination) {
        ArrayList<Message> result = new ArrayList<Message>();
        DestinationFilter filter = DestinationFilter.parseFilter(destination);
        Object object = this.lock;
        synchronized (object) {
            for (MessageReference ref : this.list) {
                Message msg = ref.getMessage();
                if (!filter.matches(msg.getDestination())) continue;
                result.add(msg);
            }
        }
        return result.toArray(new Message[result.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MessageReference> getList() {
        Object object = this.lock;
        synchronized (object) {
            return new ArrayList<MessageReference>(this.list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSize() {
        Object object = this.lock;
        synchronized (object) {
            return this.size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            this.list.clear();
            this.size = 0;
        }
    }
}

