/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.network;

import com.bes.mq.broker.region.Destination;
import com.bes.mq.broker.region.Subscription;
import com.bes.mq.command.BrokerId;
import com.bes.mq.command.ConsumerInfo;
import com.bes.mq.command.Message;
import com.bes.mq.command.NetworkBridgeFilter;
import com.bes.mq.filter.MessageEvaluationContext;
import com.bes.mq.network.NetworkBridgeFilterFactory;
import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public class ConditionalNetworkBridgeFilterFactory
implements NetworkBridgeFilterFactory {
    boolean replayWhenNoConsumers = false;
    int replayDelay = 0;
    int rateLimit = 0;
    int rateDuration = 1000;
    boolean replayWhenNoConsumersMatched = false;

    public NetworkBridgeFilter create(ConsumerInfo info, BrokerId[] remoteBrokerPath, int networkTimeToLive) {
        ConditionalNetworkBridgeFilter filter = new ConditionalNetworkBridgeFilter();
        filter.setNetworkBrokerId(remoteBrokerPath[0]);
        filter.setNetworkTTL(networkTimeToLive);
        filter.setAllowReplayWhenNoConsumers(this.isReplayWhenNoConsumers());
        filter.setRateLimit(this.getRateLimit());
        filter.setRateDuration(this.getRateDuration());
        filter.setReplayDelay(this.getReplayDelay());
        filter.setReplayWhenNoConsumersMatched(this.isReplayWhenNoConsumersMatched());
        return filter;
    }

    public void setReplayWhenNoConsumers(boolean replayWhenNoConsumers) {
        this.replayWhenNoConsumers = replayWhenNoConsumers;
    }

    public boolean isReplayWhenNoConsumers() {
        return this.replayWhenNoConsumers;
    }

    public void setRateLimit(int rateLimit) {
        this.rateLimit = rateLimit;
    }

    public int getRateLimit() {
        return this.rateLimit;
    }

    public int getRateDuration() {
        return this.rateDuration;
    }

    public void setRateDuration(int rateDuration) {
        this.rateDuration = rateDuration;
    }

    public int getReplayDelay() {
        return this.replayDelay;
    }

    public void setReplayDelay(int replayDelay) {
        this.replayDelay = replayDelay;
    }

    public boolean isReplayWhenNoConsumersMatched() {
        return this.replayWhenNoConsumersMatched;
    }

    public void setReplayWhenNoConsumersMatched(boolean replayWhenNoConsumersMatched) {
        this.replayWhenNoConsumersMatched = replayWhenNoConsumersMatched;
    }

    private static class ConditionalNetworkBridgeFilter
    extends NetworkBridgeFilter {
        static final Logger LOG = LoggerFactory.getLogger(ConditionalNetworkBridgeFilter.class);
        private int rateLimit;
        private int rateDuration = 1000;
        private boolean allowReplayWhenNoConsumers = false;
        private int replayDelay = 1000;
        private boolean replayWhenNoConsumersMatched = false;
        private int matchCount;
        private long rateDurationEnd;

        private ConditionalNetworkBridgeFilter() {
        }

        protected boolean matchesForwardingFilter(Message message, MessageEvaluationContext mec) {
            boolean match = true;
            if (mec.getDestination().isQueue() && ConditionalNetworkBridgeFilter.contains(message.getBrokerPath(), this.networkBrokerId)) {
                boolean bl = match = this.allowReplayWhenNoConsumers && this.hasNoLocalConsumers(message, mec) && this.hasNotJustArrived(message);
                if (match) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Replaying  [" + message.getMessageId() + "] for [" + message.getDestination() + "] back to origin in the absence of a local consumer");
                    }
                } else if (LOG.isTraceEnabled()) {
                    LOG.trace("Suppressing replay of [" + message.getMessageId() + "] for [ " + message.getDestination() + "] back to origin " + Arrays.asList(message.getBrokerPath()));
                }
            } else {
                match = super.matchesForwardingFilter(message, mec);
            }
            if (match && this.rateLimitExceeded()) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Throttled network consumer rejecting [" + message.getMessageId() + "] for [" + message.getDestination() + " " + this.matchCount + ">" + this.rateLimit + "/" + this.rateDuration);
                }
                match = false;
            }
            return match;
        }

        private boolean hasNotJustArrived(Message message) {
            return this.replayDelay == 0 || message.getBrokerInTime() + (long)this.replayDelay < System.currentTimeMillis();
        }

        private boolean hasNoLocalConsumers(Message message, MessageEvaluationContext mec) {
            Destination regionDestination = mec.getMessageReference().getRegionDestination();
            List<Subscription> consumers = regionDestination.getConsumers();
            for (Subscription sub : consumers) {
                if (sub.getConsumerInfo().isNetworkSubscription() || sub.getConsumerInfo().isBrowser()) continue;
                boolean replay = true;
                if (this.replayWhenNoConsumersMatched) {
                    try {
                        if (sub.matches(message, mec)) {
                            replay = false;
                        }
                    }
                    catch (IOException e) {
                        LOG.warn("Failed to do match operation, caused by: " + e.getMessage());
                    }
                } else {
                    replay = false;
                }
                if (replay) continue;
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Not replaying [" + message.getMessageId() + "] for [" + message.getDestination() + "] to origin due to existing local consumer: " + sub.getConsumerInfo());
                }
                return false;
            }
            return true;
        }

        private boolean rateLimitExceeded() {
            if (this.rateLimit == 0) {
                return false;
            }
            if (this.rateDurationEnd < System.currentTimeMillis()) {
                this.rateDurationEnd = System.currentTimeMillis() + (long)this.rateDuration;
                this.matchCount = 0;
            }
            return ++this.matchCount > this.rateLimit;
        }

        public void setReplayDelay(int replayDelay) {
            this.replayDelay = replayDelay;
        }

        public void setRateLimit(int rateLimit) {
            this.rateLimit = rateLimit;
        }

        public void setRateDuration(int rateDuration) {
            this.rateDuration = rateDuration;
        }

        public void setAllowReplayWhenNoConsumers(boolean allowReplayWhenNoConsumers) {
            this.allowReplayWhenNoConsumers = allowReplayWhenNoConsumers;
        }

        public void setReplayWhenNoConsumersMatched(boolean replayWhenNoConsumersMatched) {
            this.replayWhenNoConsumersMatched = replayWhenNoConsumersMatched;
        }
    }
}

