/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.network;

import com.bes.mq.command.BrokerId;
import com.bes.mq.command.ConsumerId;
import com.bes.mq.command.ConsumerInfo;
import com.bes.mq.filter.DestinationFilter;
import com.bes.mq.network.DemandForwardingBridge;
import com.bes.mq.network.DemandSubscription;
import com.bes.mq.network.NetworkBridgeConfiguration;
import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;
import com.bes.mq.transport.Transport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;

public class ConduitBridge
extends DemandForwardingBridge {
    private static final Logger LOG = LoggerFactory.getLogger(ConduitBridge.class);

    public ConduitBridge(NetworkBridgeConfiguration configuration, Transport localBroker, Transport remoteBroker) {
        super(configuration, localBroker, remoteBroker);
    }

    protected DemandSubscription createDemandSubscription(ConsumerInfo info) throws IOException {
        if (this.addToAlreadyInterestedConsumers(info)) {
            return null;
        }
        info.addNetworkConsumerId(info.getConsumerId());
        info.setSelector(null);
        return this.doCreateDemandSubscription(info);
    }

    protected boolean checkPaths(BrokerId[] first, BrokerId[] second) {
        if (first == null || second == null) {
            return true;
        }
        if (Arrays.equals(first, second)) {
            return true;
        }
        return !first[0].equals(second[0]) || !first[first.length - 1].equals(second[second.length - 1]);
    }

    protected boolean addToAlreadyInterestedConsumers(ConsumerInfo info) {
        boolean matched = false;
        for (DemandSubscription ds : this.subscriptionMapByLocalId.values()) {
            DestinationFilter filter = DestinationFilter.parseFilter(ds.getLocalInfo().getDestination());
            if (!filter.matches(info.getDestination())) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug(this.configuration.getBrokerName() + " matched (add interest) to exsting sub for: " + ds.getRemoteInfo() + " with sub: " + info.getConsumerId());
            }
            if (this.checkPaths(info.getBrokerPath(), ds.getRemoteInfo().getBrokerPath())) {
                ds.add(info.getConsumerId());
            }
            matched = true;
        }
        return matched;
    }

    protected void removeDemandSubscription(ConsumerId id) throws IOException {
        ArrayList<DemandSubscription> tmpList = new ArrayList<DemandSubscription>();
        for (DemandSubscription ds : this.subscriptionMapByLocalId.values()) {
            if (ds.remove(id) && LOG.isDebugEnabled()) {
                LOG.debug(this.configuration.getBrokerName() + " removing interest in sub on " + this.localBroker + " from " + this.remoteBrokerId + " : sub: " + id + " existing matched sub: " + ds.getRemoteInfo());
            }
            if (!ds.isEmpty()) continue;
            tmpList.add(ds);
        }
        for (DemandSubscription ds : tmpList) {
            this.removeSubscription(ds);
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug(this.configuration.getBrokerName() + " removing sub on " + this.localBroker + " from " + this.remoteBrokerId + " :  " + ds.getRemoteInfo());
        }
    }
}

