/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.network;

import com.bes.mq.Service;
import com.bes.mq.broker.BrokerService;
import com.bes.mq.broker.BrokerServiceAware;
import com.bes.mq.broker.TransportConnection;
import com.bes.mq.broker.region.AbstractRegion;
import com.bes.mq.broker.region.DurableTopicSubscription;
import com.bes.mq.broker.region.Region;
import com.bes.mq.broker.region.RegionBroker;
import com.bes.mq.broker.region.Subscription;
import com.bes.mq.broker.region.policy.PolicyEntry;
import com.bes.mq.command.BESMQDestination;
import com.bes.mq.command.BESMQFileMessage;
import com.bes.mq.command.BESMQMessage;
import com.bes.mq.command.BESMQTempDestination;
import com.bes.mq.command.BESMQTopic;
import com.bes.mq.command.BrokerId;
import com.bes.mq.command.BrokerInfo;
import com.bes.mq.command.Command;
import com.bes.mq.command.ConnectionError;
import com.bes.mq.command.ConnectionId;
import com.bes.mq.command.ConnectionInfo;
import com.bes.mq.command.ConsumerId;
import com.bes.mq.command.ConsumerInfo;
import com.bes.mq.command.DataStructure;
import com.bes.mq.command.DestinationInfo;
import com.bes.mq.command.ExceptionResponse;
import com.bes.mq.command.Message;
import com.bes.mq.command.MessageAck;
import com.bes.mq.command.MessageDispatch;
import com.bes.mq.command.NetworkBridgeFilter;
import com.bes.mq.command.ProducerInfo;
import com.bes.mq.command.RemoveInfo;
import com.bes.mq.command.Response;
import com.bes.mq.command.SessionInfo;
import com.bes.mq.command.ShutdownInfo;
import com.bes.mq.filter.DestinationFilter;
import com.bes.mq.filter.MessageEvaluationContext;
import com.bes.mq.network.DefaultNetworkBridgeFilterFactory;
import com.bes.mq.network.DemandSubscription;
import com.bes.mq.network.NetworkBridge;
import com.bes.mq.network.NetworkBridgeConfiguration;
import com.bes.mq.network.NetworkBridgeFilterFactory;
import com.bes.mq.network.NetworkBridgeListener;
import com.bes.mq.network.NetworkConnector;
import com.bes.mq.notification.NotificationSupport;
import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;
import com.bes.mq.transport.DefaultTransportListener;
import com.bes.mq.transport.FutureResponse;
import com.bes.mq.transport.ResponseCallback;
import com.bes.mq.transport.Transport;
import com.bes.mq.transport.TransportDisposedIOException;
import com.bes.mq.transport.TransportFilter;
import com.bes.mq.transport.tcp.SslTransport;
import com.bes.mq.util.IdGenerator;
import com.bes.mq.util.IntrospectionSupport;
import com.bes.mq.util.LongSequenceGenerator;
import com.bes.mq.util.MarshallingSupport;
import com.bes.mq.util.ServiceStopper;
import com.bes.mq.util.ServiceSupport;
import java.io.IOException;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DemandForwardingBridgeSupport
implements NetworkBridge,
BrokerServiceAware {
    private static final Logger LOG = LoggerFactory.getLogger(DemandForwardingBridgeSupport.class);
    protected static final String DURABLE_SUB_PREFIX = "NC-DS_";
    protected final Transport localBroker;
    protected final Transport remoteBroker;
    protected final IdGenerator idGenerator = new IdGenerator();
    protected final LongSequenceGenerator consumerIdGenerator = new LongSequenceGenerator();
    protected ConnectionInfo localConnectionInfo;
    protected ConnectionInfo remoteConnectionInfo;
    protected SessionInfo localSessionInfo;
    protected ProducerInfo producerInfo;
    protected String remoteBrokerName = "Unknown";
    protected String localClientId;
    protected ConsumerInfo demandConsumerInfo;
    protected int demandConsumerDispatched;
    protected final AtomicBoolean localBridgeStarted = new AtomicBoolean(false);
    protected final AtomicBoolean remoteBridgeStarted = new AtomicBoolean(false);
    protected AtomicBoolean disposed = new AtomicBoolean();
    protected BrokerId localBrokerId;
    protected BESMQDestination[] excludedDestinations;
    protected BESMQDestination[] dynamicallyIncludedDestinations;
    protected BESMQDestination[] staticallyIncludedDestinations;
    protected BESMQDestination[] durableDestinations;
    protected final ConcurrentHashMap<ConsumerId, DemandSubscription> subscriptionMapByLocalId = new ConcurrentHashMap();
    protected final ConcurrentHashMap<ConsumerId, DemandSubscription> subscriptionMapByRemoteId = new ConcurrentHashMap();
    protected final BrokerId[] localBrokerPath = new BrokerId[]{null};
    protected final CountDownLatch startedLatch = new CountDownLatch(2);
    protected final CountDownLatch localStartedLatch = new CountDownLatch(1);
    protected final AtomicBoolean lastConnectSucceeded = new AtomicBoolean(false);
    protected NetworkBridgeConfiguration configuration;
    protected final NetworkBridgeFilterFactory defaultFilterFactory = new DefaultNetworkBridgeFilterFactory();
    protected final BrokerId[] remoteBrokerPath = new BrokerId[]{null};
    protected Object brokerInfoMutex = new Object();
    protected BrokerId remoteBrokerId;
    final AtomicLong enqueueCounter = new AtomicLong();
    final AtomicLong dequeueCounter = new AtomicLong();
    private NetworkBridgeListener networkBridgeListener;
    private boolean createdByDuplex;
    private BrokerInfo localBrokerInfo;
    private BrokerInfo remoteBrokerInfo;
    private final AtomicBoolean started = new AtomicBoolean();
    private TransportConnection duplexInitiatingConnection;
    private BrokerService brokerService = null;
    private ObjectName mbeanObjectName;

    public DemandForwardingBridgeSupport(NetworkBridgeConfiguration configuration, Transport localBroker, Transport remoteBroker) {
        this.configuration = configuration;
        this.localBroker = localBroker;
        this.remoteBroker = remoteBroker;
    }

    public void duplexStart(TransportConnection connection, BrokerInfo localBrokerInfo, BrokerInfo remoteBrokerInfo) throws Exception {
        this.localBrokerInfo = localBrokerInfo;
        this.remoteBrokerInfo = remoteBrokerInfo;
        this.duplexInitiatingConnection = connection;
        this.start();
        this.serviceRemoteCommand(remoteBrokerInfo);
    }

    @Override
    public void start() throws Exception {
        if (this.started.compareAndSet(false, true)) {
            if (this.brokerService == null) {
                throw new IllegalArgumentException("BrokerService is null on " + this);
            }
            this.localBroker.setTransportListener(new DefaultTransportListener(){

                public void onCommand(Object o) {
                    Command command = (Command)o;
                    DemandForwardingBridgeSupport.this.serviceLocalCommand(command);
                }

                public void onException(IOException error) {
                    DemandForwardingBridgeSupport.this.serviceLocalException(error);
                }
            });
            this.remoteBroker.setTransportListener(new DefaultTransportListener(){

                public void onCommand(Object o) {
                    Command command = (Command)o;
                    DemandForwardingBridgeSupport.this.serviceRemoteCommand(command);
                }

                public void onException(IOException error) {
                    DemandForwardingBridgeSupport.this.serviceRemoteException(error);
                }
            });
            this.localBroker.start();
            this.remoteBroker.start();
            if (!this.disposed.get()) {
                try {
                    this.triggerRemoteStartBridge();
                }
                catch (IOException e) {
                    LOG.warn("Caught exception from remote start", e);
                }
            } else {
                LOG.warn("Bridge was disposed before the start() method was fully executed.");
                throw new TransportDisposedIOException();
            }
        }
    }

    protected void triggerLocalStartBridge() throws IOException {
        this.brokerService.getTaskRunnerFactory().execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                String originalName = Thread.currentThread().getName();
                Thread.currentThread().setName("StartLocalBridge: localBroker=" + DemandForwardingBridgeSupport.this.localBroker);
                try {
                    try {
                        DemandForwardingBridgeSupport.this.startLocalBridge();
                    }
                    catch (Throwable e) {
                        DemandForwardingBridgeSupport.this.serviceLocalException(e);
                        Object var4_3 = null;
                        Thread.currentThread().setName(originalName);
                    }
                    Object var4_2 = null;
                    Thread.currentThread().setName(originalName);
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    Thread.currentThread().setName(originalName);
                    throw throwable;
                }
            }
        });
    }

    protected void triggerRemoteStartBridge() throws IOException {
        this.brokerService.getTaskRunnerFactory().execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                String originalName = Thread.currentThread().getName();
                Thread.currentThread().setName("StartRemoteBridge: remoteBroker=" + DemandForwardingBridgeSupport.this.remoteBroker);
                try {
                    try {
                        DemandForwardingBridgeSupport.this.startRemoteBridge();
                    }
                    catch (Exception e) {
                        DemandForwardingBridgeSupport.this.serviceRemoteException(e);
                        Object var4_3 = null;
                        Thread.currentThread().setName(originalName);
                    }
                    Object var4_2 = null;
                    Thread.currentThread().setName(originalName);
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    Thread.currentThread().setName(originalName);
                    throw throwable;
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startLocalBridge() throws Throwable {
        if (this.localBridgeStarted.compareAndSet(false, true)) {
            DemandForwardingBridgeSupport demandForwardingBridgeSupport = this;
            synchronized (demandForwardingBridgeSupport) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace(this.localBrokerId + " starting local Bridge, localBroker=" + this.localBroker);
                }
                if (!this.disposed.get()) {
                    Object resp;
                    this.localConnectionInfo = new ConnectionInfo();
                    this.localConnectionInfo.setConnectionId(new ConnectionId(this.idGenerator.generateId()));
                    this.localClientId = this.configuration.getName() + "_" + this.remoteBrokerId + "_inbound_" + this.localBrokerId;
                    this.localConnectionInfo.setClientId(this.localClientId);
                    this.localConnectionInfo.setUserName(this.configuration.getUserName());
                    this.localConnectionInfo.setPassword(this.configuration.getPassword());
                    Transport originalTransport = this.remoteBroker;
                    while (originalTransport instanceof TransportFilter) {
                        originalTransport = ((TransportFilter)originalTransport).getNext();
                    }
                    if (originalTransport instanceof SslTransport) {
                        X509Certificate[] peerCerts = ((SslTransport)originalTransport).getPeerCertificates();
                        this.localConnectionInfo.setTransportContext(peerCerts);
                    }
                    if ((resp = this.localBroker.request(this.localConnectionInfo)) instanceof ExceptionResponse) {
                        throw ((ExceptionResponse)resp).getException();
                    }
                    this.localSessionInfo = new SessionInfo(this.localConnectionInfo, 1L);
                    this.localBroker.oneway(this.localSessionInfo);
                    this.brokerService.getBroker().networkBridgeStarted(this.remoteBrokerInfo, this.createdByDuplex, this.remoteBroker.toString());
                    NetworkBridgeListener l = this.networkBridgeListener;
                    if (l != null) {
                        l.onStart(this);
                    }
                    LOG.info("Network connection between " + this.localBroker + " and " + this.remoteBroker + "(" + this.remoteBrokerId + ") has been established.");
                } else {
                    LOG.warn("Bridge was disposed before the startLocalBridge() method was fully executed.");
                }
                this.startedLatch.countDown();
                this.localStartedLatch.countDown();
            }
            this.safeWaitUntilStarted();
            if (!this.disposed.get()) {
                this.setupStaticDestinations();
            } else {
                LOG.warn("Network connection between " + this.localBroker + " and " + this.remoteBroker + "(" + this.remoteBrokerId + ") was interrupted during establishment.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startRemoteBridge() throws Exception {
        if (this.remoteBridgeStarted.compareAndSet(false, true)) {
            if (LOG.isTraceEnabled()) {
                LOG.trace(this.localBrokerId + " starting remote Bridge, remoteBroker=" + this.remoteBroker);
            }
            this.localStartedLatch.await();
            DemandForwardingBridgeSupport demandForwardingBridgeSupport = this;
            synchronized (demandForwardingBridgeSupport) {
                if (!this.isCreatedByDuplex()) {
                    BrokerInfo brokerInfo = new BrokerInfo();
                    brokerInfo.setBrokerName(this.configuration.getBrokerName());
                    brokerInfo.setBrokerURL(this.configuration.getBrokerURL());
                    brokerInfo.setNetworkConnection(true);
                    brokerInfo.setDuplexConnection(this.configuration.isDuplex());
                    Properties props = new Properties();
                    IntrospectionSupport.getProperties(this.configuration, props, null);
                    String str = MarshallingSupport.propertiesToString(props);
                    brokerInfo.setNetworkProperties(str);
                    brokerInfo.setBrokerId(this.localBrokerId);
                    this.remoteBroker.oneway(brokerInfo);
                }
                if (this.remoteConnectionInfo != null) {
                    this.remoteBroker.oneway(this.remoteConnectionInfo.createRemoveCommand());
                }
                this.remoteConnectionInfo = new ConnectionInfo();
                this.remoteConnectionInfo.setConnectionId(new ConnectionId(this.idGenerator.generateId()));
                this.remoteConnectionInfo.setClientId(this.configuration.getName() + "_" + this.localBrokerId + "_outbound");
                this.remoteConnectionInfo.setUserName(this.configuration.getUserName());
                this.remoteConnectionInfo.setPassword(this.configuration.getPassword());
                this.remoteBroker.oneway(this.remoteConnectionInfo);
                SessionInfo remoteSessionInfo = new SessionInfo(this.remoteConnectionInfo, 1L);
                this.remoteBroker.oneway(remoteSessionInfo);
                this.producerInfo = new ProducerInfo(remoteSessionInfo, 1L);
                this.producerInfo.setResponseRequired(false);
                this.remoteBroker.oneway(this.producerInfo);
                if (!this.configuration.isStaticBridge()) {
                    this.demandConsumerInfo = new ConsumerInfo(remoteSessionInfo, 1L);
                    this.demandConsumerInfo.setDispatchAsync(true);
                    String notificationTopic = this.configuration.getDestinationFilter();
                    if (this.configuration.isBridgeTempDestinations()) {
                        notificationTopic = notificationTopic + "," + NotificationSupport.TEMP_DESTINATION_COMPOSITE_NOTIFICATION_TOPIC;
                    }
                    this.demandConsumerInfo.setDestination(new BESMQTopic(notificationTopic));
                    this.demandConsumerInfo.setPrefetchSize(this.configuration.getPrefetchSize());
                    this.remoteBroker.oneway(this.demandConsumerInfo);
                }
                this.startedLatch.countDown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws Exception {
        if (this.started.compareAndSet(true, false)) {
            if (this.disposed.compareAndSet(false, true)) {
                ServiceStopper ss2;
                LOG.debug(" Stopping " + this.localBrokerId + " bridge to " + this.remoteBrokerId);
                NetworkBridgeListener l = this.networkBridgeListener;
                if (l != null) {
                    l.onStop(this);
                }
                try {
                    this.remoteBridgeStarted.set(false);
                    final CountDownLatch sendShutdown = new CountDownLatch(1);
                    this.brokerService.getTaskRunnerFactory().execute(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            try {
                                try {
                                    DemandForwardingBridgeSupport.this.localBroker.oneway(new ShutdownInfo());
                                    sendShutdown.countDown();
                                    DemandForwardingBridgeSupport.this.remoteBroker.oneway(new ShutdownInfo());
                                }
                                catch (Throwable e) {
                                    LOG.debug("Caught exception sending shutdown", e);
                                    Object var3_2 = null;
                                    sendShutdown.countDown();
                                }
                                Object var3_1 = null;
                                sendShutdown.countDown();
                            }
                            catch (Throwable throwable) {
                                Object var3_3 = null;
                                sendShutdown.countDown();
                                throw throwable;
                            }
                        }
                    }, "BESMQ ForwardingBridge StopTask");
                    if (!sendShutdown.await(10L, TimeUnit.SECONDS)) {
                        // empty if block
                    }
                    Object var4_3 = null;
                    ss2 = new ServiceStopper();
                    ss2.stop(this.remoteBroker);
                    ss2.stop(this.localBroker);
                    this.startedLatch.countDown();
                    this.startedLatch.countDown();
                    this.localStartedLatch.countDown();
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    ServiceStopper ss2 = new ServiceStopper();
                    ss2.stop(this.remoteBroker);
                    ss2.stop(this.localBroker);
                    this.startedLatch.countDown();
                    this.startedLatch.countDown();
                    this.localStartedLatch.countDown();
                    ss2.throwFirstException();
                    throw throwable;
                }
                ss2.throwFirstException();
                {
                }
            }
            if (this.remoteBrokerInfo != null) {
                this.brokerService.getBroker().removeBroker(null, this.remoteBrokerInfo);
                this.brokerService.getBroker().networkBridgeStopped(this.remoteBrokerInfo);
                LOG.info(this.localBrokerId + " bridge to " + this.remoteBrokerId + " stopped");
            }
        }
    }

    @Override
    public void serviceRemoteException(Throwable error) {
        if (!this.disposed.get()) {
            if (error instanceof SecurityException || error instanceof GeneralSecurityException) {
                LOG.error("Network connection between " + this.localBroker + " and " + this.remoteBroker + " shutdown due to a remote error: " + error);
            } else {
                LOG.warn("Network connection between " + this.localBroker + " and " + this.remoteBroker + " shutdown due to a remote error: " + error);
            }
            LOG.debug("The remote Exception was: " + error, error);
            this.brokerService.getTaskRunnerFactory().execute(new Runnable(){

                public void run() {
                    ServiceSupport.dispose(DemandForwardingBridgeSupport.this.getControllingService());
                }
            });
            this.fireBridgeFailed();
        }
    }

    protected void serviceRemoteCommand(Command command) {
        block35: {
            if (!this.disposed.get()) {
                try {
                    if (command.isMessageDispatch()) {
                        this.safeWaitUntilStarted();
                        MessageDispatch md = (MessageDispatch)command;
                        this.serviceRemoteConsumerNotification(md.getMessage().getDataStructure());
                        this.ackNotification(md.getMessage());
                        break block35;
                    }
                    if (command.isBrokerInfo()) {
                        this.lastConnectSucceeded.set(true);
                        this.remoteBrokerInfo = (BrokerInfo)command;
                        Properties props = MarshallingSupport.stringToProperties(this.remoteBrokerInfo.getNetworkProperties());
                        try {
                            IntrospectionSupport.getProperties(this.configuration, props, null);
                            if (this.configuration.getExcludedDestinations() != null) {
                                this.excludedDestinations = this.configuration.getExcludedDestinations().toArray(new BESMQDestination[this.configuration.getExcludedDestinations().size()]);
                            }
                            if (this.configuration.getStaticallyIncludedDestinations() != null) {
                                this.staticallyIncludedDestinations = this.configuration.getStaticallyIncludedDestinations().toArray(new BESMQDestination[this.configuration.getStaticallyIncludedDestinations().size()]);
                            }
                            if (this.configuration.getDynamicallyIncludedDestinations() != null) {
                                this.dynamicallyIncludedDestinations = this.configuration.getDynamicallyIncludedDestinations().toArray(new BESMQDestination[this.configuration.getDynamicallyIncludedDestinations().size()]);
                            }
                        }
                        catch (Throwable t) {
                            LOG.error("Error mapping remote destinations", t);
                        }
                        this.serviceRemoteBrokerInfo(command);
                        this.localBroker.oneway(command);
                        this.brokerService.getBroker().addBroker(null, this.remoteBrokerInfo);
                        break block35;
                    }
                    if (command.getClass() == ConnectionError.class) {
                        ConnectionError ce = (ConnectionError)command;
                        this.serviceRemoteException(ce.getException());
                        break block35;
                    }
                    if (this.isDuplex()) {
                        if (command.isMessage()) {
                            BESMQMessage message = (BESMQMessage)command;
                            if (NotificationSupport.isConsumerNotificationTopic(message.getDestination()) || NotificationSupport.isDestinationNotificationTopic(message.getDestination())) {
                                this.serviceRemoteConsumerNotification(message.getDataStructure());
                                this.ackNotification(message);
                            } else {
                                if (!this.isPermissableDestination(message.getDestination(), true)) {
                                    return;
                                }
                                if (message.isResponseRequired()) {
                                    Response reply = new Response();
                                    reply.setCorrelationId(message.getCommandId());
                                    this.localBroker.oneway(message);
                                    this.remoteBroker.oneway(reply);
                                } else {
                                    this.localBroker.oneway(message);
                                }
                            }
                            break block35;
                        }
                        switch (command.getDataStructureType()) {
                            case 2: 
                            case 3: 
                            case 5: {
                                this.localBroker.oneway(command);
                                break;
                            }
                            case 33: {
                                MessageAck ack = (MessageAck)command;
                                DemandSubscription localSub = this.subscriptionMapByRemoteId.get(ack.getConsumerId());
                                if (localSub != null) {
                                    ack.setConsumerId(localSub.getLocalInfo().getConsumerId());
                                    this.localBroker.oneway(ack);
                                    break;
                                }
                                LOG.warn("Matching local subscription not found for ack: " + ack);
                                break;
                            }
                            case 4: {
                                this.localStartedLatch.await();
                                if (this.started.get()) {
                                    if (!this.addConsumerInfo((ConsumerInfo)command)) {
                                        if (LOG.isDebugEnabled()) {
                                            LOG.debug("Ignoring ConsumerInfo: " + command);
                                            break;
                                        }
                                    } else if (LOG.isTraceEnabled()) {
                                        LOG.trace("Adding ConsumerInfo: " + command);
                                        break;
                                    }
                                    break block35;
                                }
                                LOG.warn("Stopping - ignoring ConsumerInfo: " + command);
                                break;
                            }
                            case 17: {
                                LOG.info("Stopping network bridge on shutdown of remote broker");
                                this.serviceRemoteException(new IOException(command.toString()));
                                break;
                            }
                            default: {
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug("Ignoring remote command: " + command);
                                    break;
                                }
                                break block35;
                            }
                        }
                        break block35;
                    }
                    switch (command.getDataStructureType()) {
                        case 1: 
                        case 14: 
                        case 17: {
                            break;
                        }
                        default: {
                            LOG.warn("Unexpected remote command: " + command);
                        }
                    }
                }
                catch (Throwable e) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Exception processing remote command: " + command, e);
                    }
                    this.serviceRemoteException(e);
                }
            }
        }
    }

    private void ackNotification(Message message) throws IOException {
        ++this.demandConsumerDispatched;
        if ((double)this.demandConsumerDispatched > (double)this.demandConsumerInfo.getPrefetchSize() * 0.75) {
            MessageAck ack = new MessageAck(message, 2, this.demandConsumerDispatched);
            ack.setConsumerId(this.demandConsumerInfo.getConsumerId());
            this.remoteBroker.oneway(ack);
            this.demandConsumerDispatched = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serviceRemoteConsumerNotification(DataStructure data) throws IOException {
        int networkTTL = this.configuration.getNetworkTTL();
        if (data.getClass() == ConsumerInfo.class) {
            ConsumerInfo info = (ConsumerInfo)data;
            BrokerId[] path = info.getBrokerPath();
            if (info.isBrowser()) {
                if (LOG.isDebugEnabled()) {
                    LOG.info(this.localBrokerId + " Ignoring sub from " + this.remoteBrokerId + ", browsers explicitly suppressed");
                }
                return;
            }
            if (networkTTL == 0 || path != null && path.length >= networkTTL) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(this.localBrokerId + " Ignoring sub from " + this.remoteBrokerId + ", restricted to " + networkTTL + " network hops only : " + info);
                }
                return;
            }
            if (DemandForwardingBridgeSupport.contains(path, this.localBrokerPath[0])) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(this.localBrokerId + " Ignoring sub from " + this.remoteBrokerId + ", already routed through this broker once : " + info);
                }
                return;
            }
            if (!this.isPermissableDestination(info.getDestination())) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(this.localBrokerId + " Ignoring sub from " + this.remoteBrokerId + ", destination " + info.getDestination() + " is not permiited :" + info);
                }
                return;
            }
            URI uRI = this.brokerService.getVmConnectorURI();
            synchronized (uRI) {
                if (this.addConsumerInfo(info)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(this.localBrokerId + " bridged sub on " + this.localBroker + " from " + this.remoteBrokerId + " : " + info);
                    }
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug(this.localBrokerId + " Ignoring sub from " + this.remoteBrokerId + " as already subscribed to matching destination : " + info);
                }
            }
        } else if (data.getClass() == DestinationInfo.class) {
            DestinationInfo destInfo = (DestinationInfo)data;
            BrokerId[] path = destInfo.getBrokerPath();
            if (path != null && path.length >= networkTTL) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(this.localBrokerId + " Ignoring destination " + destInfo + " restricted to " + networkTTL + " network hops only");
                }
                return;
            }
            if (DemandForwardingBridgeSupport.contains(destInfo.getBrokerPath(), this.localBrokerPath[0])) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(this.localBrokerId + " Ignoring destination " + destInfo + " already routed through this broker once");
                }
                return;
            }
            destInfo.setConnectionId(this.localConnectionInfo.getConnectionId());
            if (destInfo.getDestination() instanceof BESMQTempDestination) {
                BESMQTempDestination tempDest = (BESMQTempDestination)destInfo.getDestination();
                tempDest.setConnectionId(this.localSessionInfo.getSessionId().getConnectionId());
            }
            destInfo.setBrokerPath(this.appendToBrokerPath(destInfo.getBrokerPath(), this.getRemoteBrokerPath()));
            if (LOG.isTraceEnabled()) {
                LOG.trace(this.localBrokerId + " bridging " + (destInfo.isAddOperation() ? "add" : "remove") + " destination on " + this.localBroker + " from " + this.remoteBrokerId + ", destination: " + destInfo);
            }
            this.localBroker.oneway(destInfo);
        } else if (data.getClass() == RemoveInfo.class) {
            ConsumerId id = (ConsumerId)((RemoveInfo)data).getObjectId();
            this.removeDemandSubscription(id);
        }
    }

    @Override
    public void serviceLocalException(Throwable error) {
        if (!this.disposed.get()) {
            LOG.info("Network connection between " + this.localBroker + " and " + this.remoteBroker + " shutdown due to a local error: " + error);
            LOG.debug("The local Exception was:" + error, error);
            this.brokerService.getTaskRunnerFactory().execute(new Runnable(){

                public void run() {
                    ServiceSupport.dispose(DemandForwardingBridgeSupport.this.getControllingService());
                }
            });
            this.fireBridgeFailed();
        }
    }

    protected Service getControllingService() {
        return this.duplexInitiatingConnection != null ? this.duplexInitiatingConnection : this;
    }

    protected void addSubscription(DemandSubscription sub) throws IOException {
        if (sub != null) {
            this.localBroker.oneway(sub.getLocalInfo());
        }
    }

    protected void removeSubscription(final DemandSubscription sub) throws IOException {
        if (sub != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(this.localBrokerId + " remove local subscription for remote " + sub.getRemoteInfo().getConsumerId());
            }
            this.subscriptionMapByLocalId.remove(sub.getLocalInfo().getConsumerId());
            this.subscriptionMapByRemoteId.remove(sub.getRemoteInfo().getConsumerId());
            this.brokerService.getTaskRunnerFactory().execute(new Runnable(){

                public void run() {
                    sub.waitForCompletion();
                    try {
                        DemandForwardingBridgeSupport.this.localBroker.oneway(sub.getLocalInfo().createRemoveCommand());
                    }
                    catch (IOException e) {
                        LOG.warn("Failed to deliver remove command for local subscription, for remote " + sub.getRemoteInfo().getConsumerId(), e);
                    }
                }
            });
        }
    }

    protected Message configureMessage(MessageDispatch md) throws IOException {
        Message message = md.getMessage().copy();
        message.setBrokerPath(this.appendToBrokerPath(message.getBrokerPath(), this.localBrokerPath));
        message.setProducerId(this.producerInfo.getProducerId());
        message.setDestination(md.getDestination());
        if (message.getOriginalTransactionId() == null) {
            message.setOriginalTransactionId(message.getTransactionId());
        }
        message.setTransactionId(null);
        if (this.configuration.isUseCompression()) {
            message.compress();
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void serviceLocalCommand(Command command) {
        block24: {
            if (!this.disposed.get()) {
                try {
                    if (command.isMessageDispatch()) {
                        this.safeWaitUntilStarted();
                        this.enqueueCounter.incrementAndGet();
                        final MessageDispatch md = (MessageDispatch)command;
                        final DemandSubscription sub = this.subscriptionMapByLocalId.get(md.getConsumerId());
                        if (sub != null && md.getMessage() != null && sub.incrementOutstandingResponses()) {
                            boolean syncSend;
                            if (this.suppressMessageDispatch(md, sub)) {
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug(this.localBrokerId + " message not forwarded to " + this.remoteBrokerId + " because message came from there or fails networkTTL, brokerPath: " + Arrays.toString(md.getMessage().getBrokerPath()) + ", message: " + md.getMessage());
                                }
                                try {
                                    this.localBroker.oneway(new MessageAck(md, 4, 1));
                                    Object var5_6 = null;
                                    sub.decrementOutstandingResponses();
                                }
                                catch (Throwable throwable) {
                                    Object var5_7 = null;
                                    sub.decrementOutstandingResponses();
                                    throw throwable;
                                }
                                return;
                            }
                            if (md.getMessage() instanceof BESMQFileMessage) {
                                this.brokerService.getFileTransferManager().forwardNetworkFileMessage((BESMQFileMessage)md.getMessage(), this.remoteBroker);
                            }
                            Message message = this.configureMessage(md);
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("Bridging (" + this.localBrokerId + " -> " + this.remoteBrokerId + ") " + (LOG.isTraceEnabled() ? message : message.getMessageId()) + ", consumer: " + md.getConsumerId() + ", destination " + message.getDestination() + ", brokerPath: " + Arrays.toString(message.getBrokerPath()) + ", message: " + message);
                            }
                            boolean bl = syncSend = message.isPersistent() ? this.configuration.isSyncSendPersistentMessage() : this.configuration.isSyncSendNonPersistentMessage();
                            if (!syncSend) {
                                try {
                                    this.remoteBroker.oneway(message);
                                    this.localBroker.oneway(new MessageAck(md, 4, 1));
                                    this.dequeueCounter.incrementAndGet();
                                    Object var7_11 = null;
                                    sub.decrementOutstandingResponses();
                                    break block24;
                                }
                                catch (Throwable throwable) {
                                    Object var7_12 = null;
                                    sub.decrementOutstandingResponses();
                                    throw throwable;
                                }
                            }
                            ResponseCallback callback = new ResponseCallback(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                public void onCompletion(FutureResponse future) {
                                    try {
                                        block5: {
                                            try {
                                                Response response = future.getResult();
                                                if (response.isException()) {
                                                    ExceptionResponse er = (ExceptionResponse)response;
                                                    DemandForwardingBridgeSupport.this.serviceLocalException(er.getException());
                                                    break block5;
                                                }
                                                DemandForwardingBridgeSupport.this.localBroker.oneway(new MessageAck(md, 4, 1));
                                                DemandForwardingBridgeSupport.this.dequeueCounter.incrementAndGet();
                                            }
                                            catch (IOException e) {
                                                DemandForwardingBridgeSupport.this.serviceLocalException(e);
                                                Object var5_6 = null;
                                                sub.decrementOutstandingResponses();
                                            }
                                        }
                                        Object var5_5 = null;
                                        sub.decrementOutstandingResponses();
                                    }
                                    catch (Throwable throwable) {
                                        Object var5_7 = null;
                                        sub.decrementOutstandingResponses();
                                        throw throwable;
                                    }
                                }
                            };
                            this.remoteBroker.asyncRequest(message, callback);
                            break block24;
                        }
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("No subscription registered with this network bridge for consumerId " + md.getConsumerId() + " for message: " + md.getMessage());
                        }
                        break block24;
                    }
                    if (command.isBrokerInfo()) {
                        this.localBrokerInfo = (BrokerInfo)command;
                        this.serviceLocalBrokerInfo(command);
                    } else if (command.isShutdownInfo()) {
                        LOG.info("Stopping " + this.localBrokerId + " bridge to " + this.remoteBrokerId);
                        this.stop();
                    } else if (command.getClass() == ConnectionError.class) {
                        ConnectionError ce = (ConnectionError)command;
                        this.serviceLocalException(ce.getException());
                    } else {
                        switch (command.getDataStructureType()) {
                            case 1: {
                                break;
                            }
                            default: {
                                LOG.warn("Unexpected local command: " + command);
                            }
                        }
                    }
                }
                catch (Throwable e) {
                    LOG.warn("Caught an exception processing local command", e);
                    this.serviceLocalException(e);
                }
            }
        }
    }

    private boolean suppressMessageDispatch(MessageDispatch md, DemandSubscription sub) throws Exception {
        boolean suppress = false;
        if (sub.getLocalInfo().isDurable()) {
            MessageEvaluationContext messageEvalContext = new MessageEvaluationContext();
            messageEvalContext.setMessageReference(md.getMessage());
            messageEvalContext.setDestination(md.getDestination());
            suppress = !sub.getNetworkBridgeFilter().matches(messageEvalContext);
        }
        return suppress;
    }

    public BESMQDestination[] getDynamicallyIncludedDestinations() {
        return this.dynamicallyIncludedDestinations;
    }

    public void setDynamicallyIncludedDestinations(BESMQDestination[] dynamicallyIncludedDestinations) {
        this.dynamicallyIncludedDestinations = dynamicallyIncludedDestinations;
    }

    public BESMQDestination[] getExcludedDestinations() {
        return this.excludedDestinations;
    }

    public void setExcludedDestinations(BESMQDestination[] excludedDestinations) {
        this.excludedDestinations = excludedDestinations;
    }

    public BESMQDestination[] getStaticallyIncludedDestinations() {
        return this.staticallyIncludedDestinations;
    }

    public void setStaticallyIncludedDestinations(BESMQDestination[] staticallyIncludedDestinations) {
        this.staticallyIncludedDestinations = staticallyIncludedDestinations;
    }

    public BESMQDestination[] getDurableDestinations() {
        return this.durableDestinations;
    }

    public void setDurableDestinations(BESMQDestination[] durableDestinations) {
        this.durableDestinations = durableDestinations;
    }

    public Transport getLocalBroker() {
        return this.localBroker;
    }

    public Transport getRemoteBroker() {
        return this.remoteBroker;
    }

    public boolean isCreatedByDuplex() {
        return this.createdByDuplex;
    }

    public void setCreatedByDuplex(boolean createdByDuplex) {
        this.createdByDuplex = createdByDuplex;
    }

    public static boolean contains(BrokerId[] brokerPath, BrokerId brokerId) {
        if (brokerPath != null) {
            for (int i = 0; i < brokerPath.length; ++i) {
                if (!brokerId.equals(brokerPath[i])) continue;
                return true;
            }
        }
        return false;
    }

    protected BrokerId[] appendToBrokerPath(BrokerId[] brokerPath, BrokerId[] pathsToAppend) {
        if (brokerPath == null || brokerPath.length == 0) {
            return pathsToAppend;
        }
        BrokerId[] rc = new BrokerId[brokerPath.length + pathsToAppend.length];
        System.arraycopy(brokerPath, 0, rc, 0, brokerPath.length);
        System.arraycopy(pathsToAppend, 0, rc, brokerPath.length, pathsToAppend.length);
        return rc;
    }

    protected BrokerId[] appendToBrokerPath(BrokerId[] brokerPath, BrokerId idToAppend) {
        if (brokerPath == null || brokerPath.length == 0) {
            return new BrokerId[]{idToAppend};
        }
        BrokerId[] rc = new BrokerId[brokerPath.length + 1];
        System.arraycopy(brokerPath, 0, rc, 0, brokerPath.length);
        rc[brokerPath.length] = idToAppend;
        return rc;
    }

    protected boolean isPermissableDestination(BESMQDestination destination) {
        return this.isPermissableDestination(destination, false);
    }

    protected boolean isPermissableDestination(BESMQDestination destination, boolean allowTemporary) {
        DestinationFilter inclusionFilter;
        BESMQDestination match;
        int i;
        if (destination.isTemporary()) {
            if (allowTemporary) {
                return true;
            }
            return this.configuration.isBridgeTempDestinations();
        }
        BESMQDestination[] dests = this.staticallyIncludedDestinations;
        if (dests != null && dests.length > 0) {
            for (i = 0; i < dests.length; ++i) {
                match = dests[i];
                inclusionFilter = DestinationFilter.parseFilter(match);
                if (match == null || !inclusionFilter.matches(destination) || dests[i].getDestinationType() != destination.getDestinationType()) continue;
                return true;
            }
        }
        if ((dests = this.excludedDestinations) != null && dests.length > 0) {
            for (i = 0; i < dests.length; ++i) {
                match = dests[i];
                DestinationFilter exclusionFilter = DestinationFilter.parseFilter(match);
                if (match == null || !exclusionFilter.matches(destination) || dests[i].getDestinationType() != destination.getDestinationType()) continue;
                return false;
            }
        }
        if ((dests = this.dynamicallyIncludedDestinations) != null && dests.length > 0) {
            for (i = 0; i < dests.length; ++i) {
                match = dests[i];
                inclusionFilter = DestinationFilter.parseFilter(match);
                if (match == null || !inclusionFilter.matches(destination) || dests[i].getDestinationType() != destination.getDestinationType()) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    protected void setupStaticDestinations() {
        BESMQDestination[] dests = this.staticallyIncludedDestinations;
        if (dests != null) {
            for (int i = 0; i < dests.length; ++i) {
                BESMQDestination dest = dests[i];
                DemandSubscription sub = this.createDemandSubscription(dest);
                try {
                    this.addSubscription(sub);
                }
                catch (IOException e) {
                    LOG.error("Failed to add static destination " + dest, e);
                }
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace("Bridging messages for static destination: " + dest);
            }
        }
    }

    protected boolean addConsumerInfo(ConsumerInfo consumerInfo) throws IOException {
        boolean consumerAdded = false;
        ConsumerInfo info = consumerInfo.copy();
        this.addRemoteBrokerToBrokerPath(info);
        DemandSubscription sub = this.createDemandSubscription(info);
        if (sub != null) {
            if (this.sameRouteSuppressionIsRequired(sub)) {
                LOG.warn("The network consumer " + info.getConsumerId() + " has suppressed due to same route, broker path: " + Arrays.asList(info.getBrokerPath()) + " network consumer ids: " + info.getNetworkConsumerIds());
                this.undoMapRegistration(sub);
            } else if (this.duplicateSuppressionIsRequired(sub)) {
                this.undoMapRegistration(sub);
            } else {
                this.addSubscription(sub);
                consumerAdded = true;
            }
        }
        return consumerAdded;
    }

    private void undoMapRegistration(DemandSubscription sub) {
        this.subscriptionMapByLocalId.remove(sub.getLocalInfo().getConsumerId());
        this.subscriptionMapByRemoteId.remove(sub.getRemoteInfo().getConsumerId());
    }

    private boolean duplicateSuppressionIsRequired(DemandSubscription candidate) {
        ConsumerInfo consumerInfo = candidate.getRemoteInfo();
        boolean suppress = false;
        if (consumerInfo.getDestination().isQueue() && !this.configuration.isSuppressDuplicateQueueSubscriptions() || consumerInfo.getDestination().isTopic() && !this.configuration.isSuppressDuplicateTopicSubscriptions()) {
            return suppress;
        }
        List<ConsumerId> candidateConsumers = consumerInfo.getNetworkConsumerIds();
        Collection<Subscription> currentSubs = this.getRegionSubscriptions(consumerInfo.getDestination());
        for (Subscription sub : currentSubs) {
            List<ConsumerId> networkConsumers = sub.getConsumerInfo().getNetworkConsumerIds();
            if (networkConsumers.isEmpty() || !this.matchFound(candidateConsumers, networkConsumers)) continue;
            if (this.isInActiveDurableSub(sub)) {
                suppress = false;
                break;
            }
            suppress = this.hasLowerPriority(sub, candidate.getLocalInfo());
            break;
        }
        return suppress;
    }

    private boolean isInActiveDurableSub(Subscription sub) {
        return sub.getConsumerInfo().isDurable() && sub instanceof DurableTopicSubscription && !((DurableTopicSubscription)sub).isActive();
    }

    private boolean hasLowerPriority(Subscription existingSub, ConsumerInfo candidateInfo) {
        boolean suppress = false;
        if (existingSub.getConsumerInfo().getPriority() >= candidateInfo.getPriority()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(this.localBrokerId + " Ignoring duplicate subscription from " + this.remoteBrokerId + ", sub: " + candidateInfo + " is duplicated by network subscription with equal or higher network priority: " + existingSub + ", networkConsumerIds: " + existingSub.getConsumerInfo().getNetworkConsumerIds());
            }
            suppress = true;
        } else {
            try {
                this.removeDuplicateSubscription(existingSub);
                if (LOG.isDebugEnabled()) {
                    LOG.debug(this.localBrokerId + " Replacing duplicate subscription " + existingSub.getConsumerInfo() + " with sub from " + this.remoteBrokerId + ", which has a higher priority, new sub: " + candidateInfo + ", networkComsumerIds: " + candidateInfo.getNetworkConsumerIds());
                }
            }
            catch (IOException e) {
                LOG.error("Failed to remove duplicated sub as a result of sub with higher priority, sub: " + existingSub, e);
            }
        }
        return suppress;
    }

    private void removeDuplicateSubscription(Subscription existingSub) throws IOException {
        for (NetworkConnector connector : this.brokerService.getNetworkConnectors()) {
            if (connector.removeDemandSubscription(existingSub.getConsumerInfo().getConsumerId())) break;
        }
    }

    private boolean matchFound(List<ConsumerId> candidateConsumers, List<ConsumerId> networkConsumers) {
        boolean found = false;
        for (ConsumerId aliasConsumer : networkConsumers) {
            if (!candidateConsumers.contains(aliasConsumer)) continue;
            found = true;
            break;
        }
        return found;
    }

    private final Collection<Subscription> getRegionSubscriptions(BESMQDestination dest) {
        RegionBroker region_broker = (RegionBroker)this.brokerService.getRegionBroker();
        Region region = null;
        switch (dest.getDestinationType()) {
            case 1: {
                region = region_broker.getQueueRegion();
                break;
            }
            case 2: {
                region = region_broker.getTopicRegion();
                break;
            }
            case 5: {
                region = region_broker.getTempQueueRegion();
                break;
            }
            case 6: {
                region = region_broker.getTempTopicRegion();
            }
        }
        Collection<Subscription> subs = region instanceof AbstractRegion ? ((AbstractRegion)region).getSubscriptions().values() : null;
        return subs;
    }

    protected DemandSubscription createDemandSubscription(ConsumerInfo info) throws IOException {
        info.addNetworkConsumerId(info.getConsumerId());
        return this.doCreateDemandSubscription(info);
    }

    protected DemandSubscription doCreateDemandSubscription(ConsumerInfo info) throws IOException {
        DemandSubscription result = new DemandSubscription(info);
        result.getLocalInfo().setConsumerId(new ConsumerId(this.localSessionInfo.getSessionId(), this.consumerIdGenerator.getNextSequenceId()));
        if (info.getDestination().isTemporary()) {
            BESMQTempDestination dest = (BESMQTempDestination)result.getLocalInfo().getDestination();
            dest.setConnectionId(this.localConnectionInfo.getConnectionId().toString());
        }
        if (this.configuration.isDecreaseNetworkConsumerPriority()) {
            byte priority = (byte)this.configuration.getConsumerPriorityBase();
            if (info.getBrokerPath() != null && info.getBrokerPath().length > 1) {
                priority = (byte)(priority - info.getBrokerPath().length + 1);
            }
            result.getLocalInfo().setPriority(priority);
            if (LOG.isDebugEnabled()) {
                LOG.debug(this.localBrokerId + " using priority :" + priority + " for subscription: " + info);
            }
        }
        this.configureDemandSubscription(info, result);
        return result;
    }

    protected final DemandSubscription createDemandSubscription(BESMQDestination destination) {
        ConsumerInfo info = new ConsumerInfo();
        info.setDestination(destination);
        info.setConsumerId(new ConsumerId(this.localSessionInfo.getSessionId(), this.consumerIdGenerator.getNextSequenceId()));
        DemandSubscription result = null;
        try {
            result = this.createDemandSubscription(info);
        }
        catch (IOException e) {
            LOG.error("Failed to create DemandSubscription ", e);
        }
        return result;
    }

    protected void configureDemandSubscription(ConsumerInfo info, DemandSubscription sub) throws IOException {
        sub.getLocalInfo().setDispatchAsync(this.configuration.isDispatchAsync());
        sub.getLocalInfo().setPrefetchSize(this.configuration.getPrefetchSize());
        this.subscriptionMapByLocalId.put(sub.getLocalInfo().getConsumerId(), sub);
        this.subscriptionMapByRemoteId.put(sub.getRemoteInfo().getConsumerId(), sub);
        sub.setNetworkBridgeFilter(this.createNetworkBridgeFilter(info));
        if (!info.isDurable()) {
            sub.getLocalInfo().setAdditionalPredicate(sub.getNetworkBridgeFilter());
        }
    }

    protected void removeDemandSubscription(ConsumerId id) throws IOException {
        DemandSubscription sub = this.subscriptionMapByRemoteId.remove(id);
        if (LOG.isDebugEnabled()) {
            LOG.debug(this.localBrokerId + " remove request on " + this.localBroker + " from " + this.remoteBrokerId + " , consumer id: " + id + ", matching sub: " + sub);
        }
        if (sub != null) {
            this.removeSubscription(sub);
            if (LOG.isDebugEnabled()) {
                LOG.debug(this.localBrokerId + " removed sub on " + this.localBroker + " from " + this.remoteBrokerId + " :  " + sub.getRemoteInfo());
            }
        }
    }

    protected boolean removeDemandSubscriptionByLocalId(ConsumerId consumerId) {
        boolean removeDone = false;
        DemandSubscription sub = this.subscriptionMapByLocalId.get(consumerId);
        if (sub != null) {
            try {
                this.removeDemandSubscription(sub.getRemoteInfo().getConsumerId());
                removeDone = true;
            }
            catch (IOException e) {
                LOG.debug("removeDemandSubscriptionByLocalId failed for localId: " + consumerId, e);
            }
        }
        return removeDone;
    }

    protected void safeWaitUntilStarted() throws InterruptedException {
        while (!this.disposed.get()) {
            if (!this.startedLatch.await(1L, TimeUnit.SECONDS)) continue;
            return;
        }
    }

    protected NetworkBridgeFilter createNetworkBridgeFilter(ConsumerInfo info) throws IOException {
        PolicyEntry entry;
        NetworkBridgeFilterFactory filterFactory = this.defaultFilterFactory;
        if (this.brokerService != null && this.brokerService.getDestinationPolicy() != null && (entry = this.brokerService.getDestinationPolicy().getEntryFor(info.getDestination())) != null && entry.getNetworkBridgeFilterFactory() != null) {
            filterFactory = entry.getNetworkBridgeFilterFactory();
        }
        return filterFactory.create(info, this.getRemoteBrokerPath(), this.configuration.getNetworkTTL());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void serviceLocalBrokerInfo(Command command) throws InterruptedException {
        Object object = this.brokerInfoMutex;
        synchronized (object) {
            if (this.remoteBrokerId != null && this.remoteBrokerId.equals(this.localBrokerId)) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace(this.localBrokerId + " disconnecting local loop back connection for: " + this.remoteBrokerId + ", with id:" + this.remoteBrokerId);
                }
                this.safeWaitUntilStarted();
                ServiceSupport.dispose(this);
            }
        }
    }

    protected void addRemoteBrokerToBrokerPath(ConsumerInfo info) throws IOException {
        info.setBrokerPath(this.appendToBrokerPath(info.getBrokerPath(), this.getRemoteBrokerPath()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void serviceRemoteBrokerInfo(Command command) throws IOException {
        Object object = this.brokerInfoMutex;
        synchronized (object) {
            BrokerInfo remoteBrokerInfo = (BrokerInfo)command;
            this.remoteBrokerPath[0] = this.remoteBrokerId = remoteBrokerInfo.getBrokerId();
            this.remoteBrokerName = remoteBrokerInfo.getBrokerName();
            if (this.localBrokerId != null && this.localBrokerId.equals(this.remoteBrokerId)) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace(this.localBrokerId + " disconnecting remote loop back connection for: " + this.remoteBrokerId + ", with id:" + this.remoteBrokerId);
                }
                ServiceSupport.dispose(this);
            }
            if (!this.disposed.get()) {
                this.triggerLocalStartBridge();
            }
        }
    }

    private boolean sameRouteSuppressionIsRequired(DemandSubscription candidate) {
        ConsumerInfo candidateConsumerInfo = candidate.getRemoteInfo();
        boolean suppress = false;
        if (!this.configuration.isSuppressSameRouteSubscriptions()) {
            return suppress;
        }
        Collection<Subscription> currentSubs = this.getRegionSubscriptions(candidateConsumerInfo.getDestination());
        for (Subscription sub : currentSubs) {
            boolean selectorSame;
            ConsumerInfo existConsumerInfo = sub.getConsumerInfo();
            if (!existConsumerInfo.isNetworkSubscription() || !Arrays.equals(existConsumerInfo.getBrokerPath(), candidateConsumerInfo.getBrokerPath()) || !Arrays.equals(existConsumerInfo.getNetworkConsumerIds().toArray(), candidateConsumerInfo.getNetworkConsumerIds().toArray()) || !(selectorSame = existConsumerInfo.getSelector() == null && candidateConsumerInfo.getSelector() == null || existConsumerInfo.getSelector() != null && existConsumerInfo.getSelector().equals(candidateConsumerInfo.getSelector())) || this.isInActiveDurableSub(sub)) continue;
            suppress = true;
            break;
        }
        return suppress;
    }

    protected BrokerId[] getRemoteBrokerPath() {
        return this.remoteBrokerPath;
    }

    @Override
    public void setNetworkBridgeListener(NetworkBridgeListener listener) {
        this.networkBridgeListener = listener;
    }

    private void fireBridgeFailed() {
        NetworkBridgeListener l = this.networkBridgeListener;
        if (l != null) {
            l.bridgeFailed();
        }
    }

    @Override
    public String getRemoteAddress() {
        return this.remoteBroker.getRemoteAddress();
    }

    @Override
    public String getLocalAddress() {
        return this.localBroker.getRemoteAddress();
    }

    @Override
    public String getRemoteBrokerName() {
        return this.remoteBrokerInfo == null ? null : this.remoteBrokerInfo.getBrokerName();
    }

    @Override
    public String getLocalBrokerName() {
        return this.localBrokerInfo == null ? null : this.localBrokerInfo.getBrokerName();
    }

    @Override
    public long getDequeueCounter() {
        return this.dequeueCounter.get();
    }

    @Override
    public long getEnqueueCounter() {
        return this.enqueueCounter.get();
    }

    protected boolean isDuplex() {
        return this.configuration.isDuplex() || this.createdByDuplex;
    }

    public ConcurrentHashMap<ConsumerId, DemandSubscription> getLocalSubscriptionMap() {
        return this.subscriptionMapByRemoteId;
    }

    @Override
    public void setBrokerService(BrokerService brokerService) {
        this.brokerService = brokerService;
        this.localBrokerPath[0] = this.localBrokerId = brokerService.getRegionBroker().getBrokerId();
    }

    @Override
    public void setMbeanObjectName(ObjectName objectName) {
        this.mbeanObjectName = objectName;
    }

    @Override
    public ObjectName getMbeanObjectName() {
        return this.mbeanObjectName;
    }
}

