/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.network;

import com.bes.mq.command.ConsumerId;
import com.bes.mq.command.ConsumerInfo;
import com.bes.mq.command.NetworkBridgeFilter;
import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class DemandSubscription {
    private static final Logger LOG = LoggerFactory.getLogger(DemandSubscription.class);
    private final ConsumerInfo remoteInfo;
    private final ConsumerInfo localInfo;
    private final Set<ConsumerId> remoteSubsIds = new CopyOnWriteArraySet<ConsumerId>();
    private final AtomicInteger dispatched = new AtomicInteger(0);
    private final AtomicBoolean activeWaiter = new AtomicBoolean();
    private NetworkBridgeFilter networkBridgeFilter;

    DemandSubscription(ConsumerInfo info) {
        this.remoteInfo = info;
        this.localInfo = info.copy();
        this.localInfo.setNetworkSubscription(true);
        this.remoteSubsIds.add(info.getConsumerId());
    }

    public boolean add(ConsumerId id) {
        return this.remoteSubsIds.add(id);
    }

    public boolean remove(ConsumerId id) {
        return this.remoteSubsIds.remove(id);
    }

    public boolean isEmpty() {
        return this.remoteSubsIds.isEmpty();
    }

    public int size() {
        return this.remoteSubsIds.size();
    }

    public ConsumerInfo getLocalInfo() {
        return this.localInfo;
    }

    public ConsumerInfo getRemoteInfo() {
        return this.remoteInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForCompletion() {
        if (this.dispatched.get() > 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Waiting for completion for sub: " + this.localInfo.getConsumerId() + ", dispatched: " + this.dispatched.get());
            }
            this.activeWaiter.set(true);
            if (this.dispatched.get() > 0) {
                AtomicBoolean atomicBoolean = this.activeWaiter;
                synchronized (atomicBoolean) {
                    try {
                        this.activeWaiter.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (this.dispatched.get() > 0) {
                    LOG.warn("Demand sub interrupted or timedout while waiting for outstanding responses, expect potentially " + this.dispatched.get() + " duplicate deliveried");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decrementOutstandingResponses() {
        if (this.dispatched.decrementAndGet() == 0 && this.activeWaiter.get()) {
            AtomicBoolean atomicBoolean = this.activeWaiter;
            synchronized (atomicBoolean) {
                this.activeWaiter.notifyAll();
            }
        }
    }

    public boolean incrementOutstandingResponses() {
        this.dispatched.incrementAndGet();
        if (this.activeWaiter.get()) {
            this.decrementOutstandingResponses();
            return false;
        }
        return true;
    }

    public NetworkBridgeFilter getNetworkBridgeFilter() {
        return this.networkBridgeFilter;
    }

    public void setNetworkBridgeFilter(NetworkBridgeFilter networkBridgeFilter) {
        this.networkBridgeFilter = networkBridgeFilter;
    }
}

