/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.network;

import com.bes.mq.broker.BrokerService;
import com.bes.mq.broker.BrokerServiceAware;
import com.bes.mq.broker.SslContext;
import com.bes.mq.command.DiscoveryEvent;
import com.bes.mq.network.DemandForwardingBridge;
import com.bes.mq.network.MBeanNetworkListener;
import com.bes.mq.network.NetworkBridge;
import com.bes.mq.network.NetworkBridgeFactory;
import com.bes.mq.network.NetworkConnector;
import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;
import com.bes.mq.transport.Transport;
import com.bes.mq.transport.TransportFactory;
import com.bes.mq.transport.discovery.DiscoveryAgent;
import com.bes.mq.transport.discovery.DiscoveryAgentFactory;
import com.bes.mq.transport.discovery.DiscoveryListener;
import com.bes.mq.util.IntrospectionSupport;
import com.bes.mq.util.ServiceStopper;
import com.bes.mq.util.ServiceSupport;
import com.bes.mq.util.URISupport;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.ObjectName;

public class DiscoveryNetworkConnector
extends NetworkConnector
implements DiscoveryListener {
    private static final Logger LOG = LoggerFactory.getLogger(DiscoveryNetworkConnector.class);
    private DiscoveryAgent discoveryAgent;
    private Map<String, String> parameters;

    public DiscoveryNetworkConnector() {
    }

    public DiscoveryNetworkConnector(URI discoveryURI) throws IOException {
        this.setUri(discoveryURI);
    }

    public void setUri(URI discoveryURI) throws IOException {
        this.setDiscoveryAgent(DiscoveryAgentFactory.createDiscoveryAgent(discoveryURI));
        try {
            this.parameters = URISupport.parseParameters(discoveryURI);
            IntrospectionSupport.setProperties(this.getDiscoveryAgent(), this.parameters);
        }
        catch (URISyntaxException e) {
            LOG.warn("Failed to parse query parameters from discoveryURI: " + discoveryURI, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onServiceAdd(DiscoveryEvent event) {
        block30: {
            if (this.serviceSupport.isStopped() || this.serviceSupport.isStopping()) {
                return;
            }
            String url = event.getServiceName();
            if (url != null) {
                Transport localTransport;
                Transport remoteTransport;
                URI uri;
                try {
                    uri = new URI(url);
                }
                catch (URISyntaxException e) {
                    LOG.warn("Could not connect to remote URI: " + url + " due to bad URI syntax: " + e, e);
                    return;
                }
                ConcurrentHashMap e = this.bridges;
                synchronized (e) {
                    if (this.bridges.containsKey(uri)) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Discovery agent generated a duplicate onServiceAdd event for: " + uri);
                        }
                        return;
                    }
                }
                if (this.localURI.equals(uri)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Not connecting loopback: " + uri);
                    }
                    return;
                }
                if (this.connectionFilter != null && !this.connectionFilter.connectTo(uri)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("connectionFilter disallows connection to: " + uri);
                    }
                    return;
                }
                URI connectUri = uri;
                if (LOG.isInfoEnabled()) {
                    LOG.info("Establishing network connection from " + this.localURI + " to " + connectUri);
                }
                try {
                    SslContext.setCurrentSslContext(this.getBrokerService().getSslContext());
                    try {
                        remoteTransport = TransportFactory.connect(connectUri);
                    }
                    catch (Exception e2) {
                        LOG.warn("Could not connect to remote URI: " + connectUri + ": " + e2.getMessage());
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Connection failure exception: " + e2, e2);
                        }
                        Object var9_11 = null;
                        SslContext.setCurrentSslContext(null);
                        return;
                    }
                    try {
                        localTransport = this.createLocalTransport();
                    }
                    catch (Exception e3) {
                        ServiceSupport.dispose(remoteTransport);
                        LOG.warn("Could not connect to local URI: " + this.localURI + ": " + e3.getMessage());
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Connection failure exception: " + e3, e3);
                        }
                        Object var9_12 = null;
                        SslContext.setCurrentSslContext(null);
                        return;
                    }
                    Object var9_13 = null;
                }
                catch (Throwable throwable) {
                    Object var9_14 = null;
                    SslContext.setCurrentSslContext(null);
                    throw throwable;
                }
                SslContext.setCurrentSslContext(null);
                NetworkBridge bridge = this.createBridge(localTransport, remoteTransport, event);
                try {
                    bridge.start();
                    ConcurrentHashMap concurrentHashMap = this.bridges;
                    synchronized (concurrentHashMap) {
                        this.bridges.put(uri, bridge);
                    }
                }
                catch (Exception e4) {
                    ServiceSupport.dispose(localTransport);
                    ServiceSupport.dispose(remoteTransport);
                    LOG.warn("Could not start network bridge between: " + this.localURI + " and: " + uri + " due to: " + e4);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Start failure exception: " + e4, e4);
                    }
                    try {
                        this.discoveryAgent.serviceFailed(event);
                    }
                    catch (IOException e1) {
                        if (!LOG.isDebugEnabled()) break block30;
                        LOG.debug("Discovery agent failure while handling failure event: " + e1.getMessage(), e1);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onServiceRemove(DiscoveryEvent event) {
        String url = event.getServiceName();
        if (url != null) {
            URI uri;
            try {
                uri = new URI(url);
            }
            catch (URISyntaxException e) {
                LOG.warn("Could not connect to remote URI: " + url + " due to bad URI syntax: " + e, e);
                return;
            }
            ConcurrentHashMap concurrentHashMap = this.bridges;
            synchronized (concurrentHashMap) {
                this.bridges.remove(uri);
            }
        }
    }

    public DiscoveryAgent getDiscoveryAgent() {
        return this.discoveryAgent;
    }

    public void setDiscoveryAgent(DiscoveryAgent discoveryAgent) {
        this.discoveryAgent = discoveryAgent;
        if (discoveryAgent != null) {
            this.discoveryAgent.setDiscoveryListener(this);
        }
    }

    protected void handleStart() throws Exception {
        if (this.discoveryAgent == null) {
            throw new IllegalStateException("You must configure the 'discoveryAgent' property");
        }
        if (this.discoveryAgent instanceof BrokerServiceAware) {
            ((BrokerServiceAware)((Object)this.discoveryAgent)).setBrokerService(this.getBrokerService());
        }
        this.discoveryAgent.start();
        super.handleStart();
    }

    protected void handleStop(ServiceStopper stopper) throws Exception {
        for (NetworkBridge bridge : this.bridges.values()) {
            try {
                bridge.stop();
            }
            catch (Exception e) {
                stopper.onException(this, e);
            }
        }
        this.bridges.clear();
        try {
            this.discoveryAgent.stop();
        }
        catch (Exception e) {
            stopper.onException(this, e);
        }
        super.handleStop(stopper);
    }

    protected NetworkBridge createBridge(Transport localTransport, Transport remoteTransport, final DiscoveryEvent event) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class DiscoverNetworkBridgeListener
        extends MBeanNetworkListener {
            public DiscoverNetworkBridgeListener(BrokerService brokerService, ObjectName connectorName) {
                super(brokerService, connectorName);
            }

            @Override
            public void bridgeFailed() {
                if (!DiscoveryNetworkConnector.this.serviceSupport.isStopped()) {
                    try {
                        DiscoveryNetworkConnector.this.discoveryAgent.serviceFailed(event);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }
        DiscoverNetworkBridgeListener listener = new DiscoverNetworkBridgeListener(this.getBrokerService(), this.getObjectName());
        DemandForwardingBridge result = NetworkBridgeFactory.createBridge(this, localTransport, remoteTransport, listener);
        result.setBrokerService(this.getBrokerService());
        return this.configureBridge(result);
    }

    public String toString() {
        return "ClusterConnector:" + this.getName() + ":" + this.getBrokerService();
    }
}

