/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.network;

import com.bes.mq.command.BESMQDestination;
import com.bes.mq.command.ConsumerId;
import com.bes.mq.command.ConsumerInfo;
import com.bes.mq.filter.DestinationFilter;
import com.bes.mq.network.ConduitBridge;
import com.bes.mq.network.DemandSubscription;
import com.bes.mq.network.NetworkBridgeConfiguration;
import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;
import com.bes.mq.transport.Transport;
import java.io.IOException;

public class DurableConduitBridge
extends ConduitBridge {
    private static final Logger LOG = LoggerFactory.getLogger(DurableConduitBridge.class);

    public DurableConduitBridge(NetworkBridgeConfiguration configuration, Transport localBroker, Transport remoteBroker) {
        super(configuration, localBroker, remoteBroker);
    }

    protected void setupStaticDestinations() {
        BESMQDestination[] dests;
        super.setupStaticDestinations();
        BESMQDestination[] bESMQDestinationArray = dests = this.configuration.isDynamicOnly() ? null : this.durableDestinations;
        if (dests != null) {
            for (BESMQDestination dest : dests) {
                if (!this.isPermissableDestination(dest) || this.doesConsumerExist(dest)) continue;
                DemandSubscription sub = this.createDemandSubscription(dest);
                if (dest.isTopic()) {
                    sub.getLocalInfo().setSubscriptionName(this.getSubscriberName(dest));
                }
                try {
                    this.addSubscription(sub);
                }
                catch (IOException e) {
                    LOG.error("Failed to add static destination " + dest, e);
                }
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace("Forwarding messages for durable destination: " + dest);
            }
        }
    }

    protected DemandSubscription createDemandSubscription(ConsumerInfo info) throws IOException {
        if (this.addToAlreadyInterestedConsumers(info)) {
            return null;
        }
        info.addNetworkConsumerId(info.getConsumerId());
        if (info.isDurable()) {
            info.setSubscriptionName(this.getSubscriberName(info.getDestination()));
            info.setConsumerId(new ConsumerId(this.localSessionInfo.getSessionId(), this.consumerIdGenerator.getNextSequenceId()));
        }
        info.setSelector(null);
        return this.doCreateDemandSubscription(info);
    }

    protected String getSubscriberName(BESMQDestination dest) {
        String subscriberName = "NC-DS_" + this.configuration.getBrokerName() + "_" + dest.getPhysicalName();
        return subscriberName;
    }

    protected boolean doesConsumerExist(BESMQDestination dest) {
        DestinationFilter filter = DestinationFilter.parseFilter(dest);
        for (DemandSubscription ds : this.subscriptionMapByLocalId.values()) {
            if (!filter.matches(ds.getLocalInfo().getDestination())) continue;
            return true;
        }
        return false;
    }
}

