/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.network;

import com.bes.mq.Service;
import com.bes.mq.command.BESMQQueue;
import com.bes.mq.command.BESMQTopic;
import com.bes.mq.command.BrokerId;
import com.bes.mq.command.BrokerInfo;
import com.bes.mq.command.Command;
import com.bes.mq.command.ConnectionId;
import com.bes.mq.command.ConnectionInfo;
import com.bes.mq.command.ConsumerInfo;
import com.bes.mq.command.ExceptionResponse;
import com.bes.mq.command.Message;
import com.bes.mq.command.MessageAck;
import com.bes.mq.command.MessageDispatch;
import com.bes.mq.command.ProducerInfo;
import com.bes.mq.command.Response;
import com.bes.mq.command.SessionInfo;
import com.bes.mq.command.ShutdownInfo;
import com.bes.mq.network.NetworkBridgeListener;
import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;
import com.bes.mq.transport.DefaultTransportListener;
import com.bes.mq.transport.FutureResponse;
import com.bes.mq.transport.ResponseCallback;
import com.bes.mq.transport.Transport;
import com.bes.mq.util.IdGenerator;
import com.bes.mq.util.ServiceStopper;
import com.bes.mq.util.ServiceSupport;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;

public class ForwardingBridge
implements Service {
    private static final IdGenerator ID_GENERATOR = new IdGenerator();
    private static final Logger LOG = LoggerFactory.getLogger(ForwardingBridge.class);
    final AtomicLong enqueueCounter = new AtomicLong();
    final AtomicLong dequeueCounter = new AtomicLong();
    ConnectionInfo connectionInfo;
    SessionInfo sessionInfo;
    ProducerInfo producerInfo;
    ConsumerInfo queueConsumerInfo;
    ConsumerInfo topicConsumerInfo;
    BrokerId localBrokerId;
    BrokerId remoteBrokerId;
    BrokerInfo localBrokerInfo;
    BrokerInfo remoteBrokerInfo;
    private final Transport localBroker;
    private final Transport remoteBroker;
    private String clientId;
    private int prefetchSize = 1000;
    private boolean dispatchAsync;
    private String destinationFilter = ">";
    private NetworkBridgeListener bridgeFailedListener;
    private boolean useCompression = false;

    public ForwardingBridge(Transport localBroker, Transport remoteBroker) {
        this.localBroker = localBroker;
        this.remoteBroker = remoteBroker;
    }

    public void start() throws Exception {
        LOG.info("Starting a network connection between " + this.localBroker + " and " + this.remoteBroker + " has been established.");
        this.localBroker.setTransportListener(new DefaultTransportListener(){

            public void onCommand(Object o) {
                Command command = (Command)o;
                ForwardingBridge.this.serviceLocalCommand(command);
            }

            public void onException(IOException error) {
                ForwardingBridge.this.serviceLocalException(error);
            }
        });
        this.remoteBroker.setTransportListener(new DefaultTransportListener(){

            public void onCommand(Object o) {
                Command command = (Command)o;
                ForwardingBridge.this.serviceRemoteCommand(command);
            }

            public void onException(IOException error) {
                ForwardingBridge.this.serviceRemoteException(error);
            }
        });
        this.localBroker.start();
        this.remoteBroker.start();
    }

    protected void triggerStartBridge() throws IOException {
        Thread thead = new Thread(){

            public void run() {
                try {
                    ForwardingBridge.this.startBridge();
                }
                catch (IOException e) {
                    LOG.error("Failed to start network bridge: " + e, e);
                }
            }
        };
        thead.start();
    }

    final void startBridge() throws IOException {
        this.connectionInfo = new ConnectionInfo();
        this.connectionInfo.setConnectionId(new ConnectionId(ID_GENERATOR.generateId()));
        this.connectionInfo.setClientId(this.clientId);
        this.localBroker.oneway(this.connectionInfo);
        this.remoteBroker.oneway(this.connectionInfo);
        this.sessionInfo = new SessionInfo(this.connectionInfo, 1L);
        this.localBroker.oneway(this.sessionInfo);
        this.remoteBroker.oneway(this.sessionInfo);
        this.queueConsumerInfo = new ConsumerInfo(this.sessionInfo, 1L);
        this.queueConsumerInfo.setDispatchAsync(this.dispatchAsync);
        this.queueConsumerInfo.setDestination(new BESMQQueue(this.destinationFilter));
        this.queueConsumerInfo.setPrefetchSize(this.prefetchSize);
        this.queueConsumerInfo.setPriority((byte)-5);
        this.localBroker.oneway(this.queueConsumerInfo);
        this.producerInfo = new ProducerInfo(this.sessionInfo, 1L);
        this.producerInfo.setResponseRequired(false);
        this.remoteBroker.oneway(this.producerInfo);
        if (this.connectionInfo.getClientId() != null) {
            this.topicConsumerInfo = new ConsumerInfo(this.sessionInfo, 2L);
            this.topicConsumerInfo.setDispatchAsync(this.dispatchAsync);
            this.topicConsumerInfo.setSubscriptionName("topic-bridge");
            this.topicConsumerInfo.setRetroactive(true);
            this.topicConsumerInfo.setDestination(new BESMQTopic(this.destinationFilter));
            this.topicConsumerInfo.setPrefetchSize(this.prefetchSize);
            this.topicConsumerInfo.setPriority((byte)-5);
            this.localBroker.oneway(this.topicConsumerInfo);
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("Network connection between " + this.localBroker + " and " + this.remoteBroker + " has been established.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws Exception {
        try {
            if (this.connectionInfo != null) {
                this.localBroker.request(this.connectionInfo.createRemoveCommand());
                this.remoteBroker.request(this.connectionInfo.createRemoveCommand());
            }
            this.localBroker.setTransportListener(null);
            this.remoteBroker.setTransportListener(null);
            this.localBroker.oneway(new ShutdownInfo());
            this.remoteBroker.oneway(new ShutdownInfo());
        }
        finally {
            ServiceStopper ss = new ServiceStopper();
            ss.stop(this.localBroker);
            ss.stop(this.remoteBroker);
            ss.throwFirstException();
        }
    }

    public void serviceRemoteException(Throwable error) {
        LOG.info("Unexpected remote exception: " + error);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Exception trace: ", error);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void serviceRemoteCommand(Command command) {
        block9: {
            try {
                if (command.isBrokerInfo()) {
                    ForwardingBridge forwardingBridge = this;
                    synchronized (forwardingBridge) {
                        this.remoteBrokerInfo = (BrokerInfo)command;
                        this.remoteBrokerId = this.remoteBrokerInfo.getBrokerId();
                        if (this.localBrokerId != null) {
                            if (this.localBrokerId.equals(this.remoteBrokerId)) {
                                LOG.info("Disconnecting loop back connection.");
                                ServiceSupport.dispose(this);
                            } else {
                                this.triggerStartBridge();
                            }
                        }
                        break block9;
                    }
                }
                LOG.warn("Unexpected remote command: " + command);
            }
            catch (IOException e) {
                this.serviceLocalException(e);
            }
        }
    }

    public void serviceLocalException(Throwable error) {
        LOG.info("Unexpected local exception: " + error);
        LOG.debug("Exception trace: ", error);
        this.fireBridgeFailed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void serviceLocalCommand(Command command) {
        block14: {
            try {
                if (command.isMessageDispatch()) {
                    this.enqueueCounter.incrementAndGet();
                    final MessageDispatch md = (MessageDispatch)command;
                    Message message = md.getMessage();
                    message.setProducerId(this.producerInfo.getProducerId());
                    if (message.getOriginalTransactionId() == null) {
                        message.setOriginalTransactionId(message.getTransactionId());
                    }
                    message.setTransactionId(null);
                    if (this.isUseCompression()) {
                        message.compress();
                    }
                    if (!message.isResponseRequired()) {
                        this.remoteBroker.oneway(message);
                        this.dequeueCounter.incrementAndGet();
                        this.localBroker.oneway(new MessageAck(md, 2, 1));
                    } else {
                        ResponseCallback callback = new ResponseCallback(){

                            public void onCompletion(FutureResponse future) {
                                try {
                                    Response response = future.getResult();
                                    if (response.isException()) {
                                        ExceptionResponse er = (ExceptionResponse)response;
                                        ForwardingBridge.this.serviceLocalException(er.getException());
                                    } else {
                                        ForwardingBridge.this.dequeueCounter.incrementAndGet();
                                        ForwardingBridge.this.localBroker.oneway(new MessageAck(md, 2, 1));
                                    }
                                }
                                catch (IOException e) {
                                    ForwardingBridge.this.serviceLocalException(e);
                                }
                            }
                        };
                        this.remoteBroker.asyncRequest(message, callback);
                    }
                    break block14;
                }
                if (command.isBrokerInfo()) {
                    ForwardingBridge md = this;
                    synchronized (md) {
                        this.localBrokerInfo = (BrokerInfo)command;
                        this.localBrokerId = this.localBrokerInfo.getBrokerId();
                        if (this.remoteBrokerId != null) {
                            if (this.remoteBrokerId.equals(this.localBrokerId)) {
                                LOG.info("Disconnecting loop back connection.");
                                ServiceSupport.dispose(this);
                            } else {
                                this.triggerStartBridge();
                            }
                        }
                        break block14;
                    }
                }
                LOG.debug("Unexpected local command: " + command);
            }
            catch (IOException e) {
                this.serviceLocalException(e);
            }
        }
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public int getPrefetchSize() {
        return this.prefetchSize;
    }

    public void setPrefetchSize(int prefetchSize) {
        this.prefetchSize = prefetchSize;
    }

    public boolean isDispatchAsync() {
        return this.dispatchAsync;
    }

    public void setDispatchAsync(boolean dispatchAsync) {
        this.dispatchAsync = dispatchAsync;
    }

    public String getDestinationFilter() {
        return this.destinationFilter;
    }

    public void setDestinationFilter(String destinationFilter) {
        this.destinationFilter = destinationFilter;
    }

    public void setNetworkBridgeFailedListener(NetworkBridgeListener listener) {
        this.bridgeFailedListener = listener;
    }

    private void fireBridgeFailed() {
        NetworkBridgeListener l = this.bridgeFailedListener;
        if (l != null) {
            l.bridgeFailed();
        }
    }

    public String getRemoteAddress() {
        return this.remoteBroker.getRemoteAddress();
    }

    public String getLocalAddress() {
        return this.localBroker.getRemoteAddress();
    }

    public String getLocalBrokerName() {
        return this.localBrokerInfo == null ? null : this.localBrokerInfo.getBrokerName();
    }

    public String getRemoteBrokerName() {
        return this.remoteBrokerInfo == null ? null : this.remoteBrokerInfo.getBrokerName();
    }

    public long getDequeueCounter() {
        return this.dequeueCounter.get();
    }

    public long getEnqueueCounter() {
        return this.enqueueCounter.get();
    }

    public void setUseCompression(boolean useCompression) {
        this.useCompression = useCompression;
    }

    public boolean isUseCompression() {
        return this.useCompression;
    }
}

