/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.network;

import com.bes.mq.broker.BrokerService;
import com.bes.mq.broker.jmx.AnnotatedMBean;
import com.bes.mq.broker.jmx.NetworkBridgeView;
import com.bes.mq.network.NetworkBridge;
import com.bes.mq.network.NetworkBridgeListener;
import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;
import com.bes.mq.util.JMXSupport;
import java.util.HashMap;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class MBeanNetworkListener
implements NetworkBridgeListener {
    private static final Logger LOG = LoggerFactory.getLogger(MBeanNetworkListener.class);
    BrokerService brokerService;
    ObjectName connectorName;
    boolean createdByDuplex = false;

    public MBeanNetworkListener(BrokerService brokerService, ObjectName connectorName) {
        this.brokerService = brokerService;
        this.connectorName = connectorName;
    }

    public void bridgeFailed() {
    }

    public void onStart(NetworkBridge bridge) {
        if (!this.brokerService.isUseJmx()) {
            return;
        }
        NetworkBridgeView view = new NetworkBridgeView(bridge);
        view.setCreateByDuplex(this.createdByDuplex);
        try {
            ObjectName objectName = this.createNetworkBridgeObjectName(bridge);
            AnnotatedMBean.registerMBean(this.brokerService.getManagementContext(), view, objectName);
            bridge.setMbeanObjectName(objectName);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Registered: " + bridge + " as: " + objectName);
            }
        }
        catch (Throwable e) {
            LOG.debug("Network bridge could not be registered in JMX: " + e.getMessage(), e);
        }
    }

    public void onStop(NetworkBridge bridge) {
        if (!this.brokerService.isUseJmx()) {
            return;
        }
        try {
            ObjectName objectName = bridge.getMbeanObjectName();
            if (objectName != null) {
                this.brokerService.getManagementContext().unregisterMBean(objectName);
            }
        }
        catch (Throwable e) {
            LOG.debug("Network bridge could not be unregistered in JMX: " + e.getMessage(), e);
        }
    }

    protected ObjectName createNetworkBridgeObjectName(NetworkBridge bridge) throws MalformedObjectNameException {
        HashMap<String, String> map = new HashMap<String, String>(this.connectorName.getKeyPropertyList());
        return new ObjectName(this.connectorName.getDomain() + ":" + "BrokerName=" + JMXSupport.encodeObjectNamePart((String)map.get("BrokerName")) + "," + "Type=NetworkBridge," + "NetworkConnectorName=" + JMXSupport.encodeObjectNamePart((String)map.get("NetworkConnectorName")) + "," + "Name=" + JMXSupport.encodeObjectNamePart(JMXSupport.encodeObjectNamePart(bridge.getRemoteAddress())));
    }

    public void setCreatedByDuplex(boolean createdByDuplex) {
        this.createdByDuplex = createdByDuplex;
    }
}

