/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.network;

import com.bes.mq.network.CompositeDemandForwardingBridge;
import com.bes.mq.network.DemandForwardingBridgeSupport;
import com.bes.mq.network.NetworkConnector;
import com.bes.mq.transport.Transport;
import com.bes.mq.transport.TransportFactory;
import com.bes.mq.util.ServiceStopper;
import java.net.URI;

public class MulticastNetworkConnector
extends NetworkConnector {
    private Transport localTransport;
    private Transport remoteTransport;
    private URI remoteURI;
    private DemandForwardingBridgeSupport bridge;

    public MulticastNetworkConnector() {
    }

    public MulticastNetworkConnector(URI remoteURI) {
        this.remoteURI = remoteURI;
    }

    public DemandForwardingBridgeSupport getBridge() {
        return this.bridge;
    }

    public void setBridge(DemandForwardingBridgeSupport bridge) {
        this.bridge = bridge;
    }

    public Transport getLocalTransport() {
        return this.localTransport;
    }

    public void setLocalTransport(Transport localTransport) {
        this.localTransport = localTransport;
    }

    public Transport getRemoteTransport() {
        return this.remoteTransport;
    }

    public void setRemoteTransport(Transport remoteTransport) {
        this.remoteTransport = remoteTransport;
    }

    public URI getRemoteURI() {
        return this.remoteURI;
    }

    public void setRemoteURI(URI remoteURI) {
        this.remoteURI = remoteURI;
    }

    protected void handleStart() throws Exception {
        if (this.remoteTransport == null) {
            if (this.remoteURI == null) {
                throw new IllegalArgumentException("Must specify the remoteURI property");
            }
            this.remoteTransport = TransportFactory.connect(this.remoteURI);
        }
        if (this.localTransport == null) {
            this.localTransport = this.createLocalTransport();
        }
        this.bridge = this.createBridge(this.localTransport, this.remoteTransport);
        this.configureBridge(this.bridge);
        this.bridge.start();
        this.remoteTransport.start();
        this.localTransport.start();
        super.handleStart();
    }

    protected void handleStop(ServiceStopper stopper) throws Exception {
        super.handleStop(stopper);
        if (this.bridge != null) {
            try {
                this.bridge.stop();
            }
            catch (Exception e) {
                stopper.onException(this, e);
            }
        }
        if (this.remoteTransport != null) {
            try {
                this.remoteTransport.stop();
            }
            catch (Exception e) {
                stopper.onException(this, e);
            }
        }
        if (this.localTransport != null) {
            try {
                this.localTransport.stop();
            }
            catch (Exception e) {
                stopper.onException(this, e);
            }
        }
    }

    public String toString() {
        return this.getClass().getName() + ":" + this.getName() + "[" + this.remoteTransport.toString() + "]";
    }

    protected DemandForwardingBridgeSupport createBridge(Transport local, Transport remote) {
        CompositeDemandForwardingBridge bridge = new CompositeDemandForwardingBridge(this, local, remote);
        bridge.setBrokerService(this.getBrokerService());
        return bridge;
    }
}

