/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.network;

import com.bes.mq.command.BESMQDestination;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetworkBridgeConfiguration {
    private boolean conduitSubscriptions = true;
    private boolean dynamicOnly;
    private boolean dispatchAsync = true;
    private boolean decreaseNetworkConsumerPriority;
    private int consumerPriorityBase = -5;
    private boolean duplex;
    private boolean bridgeTempDestinations = true;
    private int prefetchSize = 1000;
    private int networkTTL = 1;
    private String brokerName = "localhost";
    private String brokerURL = "";
    private String userName;
    private String password;
    private String destinationFilter = null;
    private String name = "NC";
    private List<BESMQDestination> excludedDestinations;
    private List<BESMQDestination> dynamicallyIncludedDestinations;
    private List<BESMQDestination> staticallyIncludedDestinations;
    private boolean suppressDuplicateQueueSubscriptions = false;
    private boolean suppressDuplicateTopicSubscriptions = true;
    private boolean suppressSameRouteSubscriptions = true;
    private boolean syncSendPersistentMessage = true;
    private boolean syncSendNonPersistentMessage;
    private boolean staticBridge = false;
    private boolean useCompression = false;

    public boolean isConduitSubscriptions() {
        return this.conduitSubscriptions;
    }

    public void setConduitSubscriptions(boolean conduitSubscriptions) {
        this.conduitSubscriptions = conduitSubscriptions;
    }

    public boolean isDynamicOnly() {
        return this.dynamicOnly;
    }

    public void setDynamicOnly(boolean dynamicOnly) {
        this.dynamicOnly = dynamicOnly;
    }

    public boolean isBridgeTempDestinations() {
        return this.bridgeTempDestinations;
    }

    public void setBridgeTempDestinations(boolean bridgeTempDestinations) {
        this.bridgeTempDestinations = bridgeTempDestinations;
    }

    public boolean isDecreaseNetworkConsumerPriority() {
        return this.decreaseNetworkConsumerPriority;
    }

    public void setDecreaseNetworkConsumerPriority(boolean decreaseNetworkConsumerPriority) {
        this.decreaseNetworkConsumerPriority = decreaseNetworkConsumerPriority;
    }

    public boolean isDispatchAsync() {
        return this.dispatchAsync;
    }

    public void setDispatchAsync(boolean dispatchAsync) {
        this.dispatchAsync = dispatchAsync;
    }

    public boolean isDuplex() {
        return this.duplex;
    }

    public void setDuplex(boolean duplex) {
        this.duplex = duplex;
    }

    public String getBrokerName() {
        return this.brokerName;
    }

    public void setBrokerName(String brokerName) {
        this.brokerName = brokerName;
    }

    public int getNetworkTTL() {
        return this.networkTTL;
    }

    public void setNetworkTTL(int networkTTL) {
        this.networkTTL = networkTTL;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getPrefetchSize() {
        return this.prefetchSize;
    }

    public void setPrefetchSize(int prefetchSize) {
        this.prefetchSize = prefetchSize;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getDestinationFilter() {
        if (this.destinationFilter == null) {
            if (this.dynamicallyIncludedDestinations != null && !this.dynamicallyIncludedDestinations.isEmpty()) {
                StringBuffer filter = new StringBuffer();
                String delimiter = "";
                for (BESMQDestination destination : this.dynamicallyIncludedDestinations) {
                    if (destination.isTemporary()) continue;
                    filter.append(delimiter);
                    filter.append("BESMQ.Notification.Consumer.");
                    filter.append(destination.getDestinationTypeAsString());
                    filter.append(".");
                    filter.append(destination.getPhysicalName());
                    delimiter = ",";
                }
                return filter.toString();
            }
            return "BESMQ.Notification.Consumer.>";
        }
        if (!this.destinationFilter.startsWith("BESMQ.Notification.Consumer.")) {
            return "BESMQ.Notification.Consumer." + this.destinationFilter;
        }
        return this.destinationFilter;
    }

    public void setDestinationFilter(String destinationFilter) {
        this.destinationFilter = destinationFilter;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<BESMQDestination> getExcludedDestinations() {
        return this.excludedDestinations;
    }

    public void setExcludedDestinations(List<BESMQDestination> excludedDestinations) {
        this.excludedDestinations = excludedDestinations;
    }

    public List<BESMQDestination> getDynamicallyIncludedDestinations() {
        return this.dynamicallyIncludedDestinations;
    }

    public void setDynamicallyIncludedDestinations(List<BESMQDestination> dynamicallyIncludedDestinations) {
        this.dynamicallyIncludedDestinations = dynamicallyIncludedDestinations;
    }

    public List<BESMQDestination> getStaticallyIncludedDestinations() {
        return this.staticallyIncludedDestinations;
    }

    public void setStaticallyIncludedDestinations(List<BESMQDestination> staticallyIncludedDestinations) {
        this.staticallyIncludedDestinations = staticallyIncludedDestinations;
    }

    public boolean isSuppressDuplicateQueueSubscriptions() {
        return this.suppressDuplicateQueueSubscriptions;
    }

    public void setSuppressDuplicateQueueSubscriptions(boolean val) {
        this.suppressDuplicateQueueSubscriptions = val;
    }

    public boolean isSuppressDuplicateTopicSubscriptions() {
        return this.suppressDuplicateTopicSubscriptions;
    }

    public void setSuppressDuplicateTopicSubscriptions(boolean val) {
        this.suppressDuplicateTopicSubscriptions = val;
    }

    public boolean isSyncSendPersistentMessage() {
        return this.syncSendPersistentMessage;
    }

    public void setSyncSendPersistentMessage(boolean syncSendPersistentMessage) {
        this.syncSendPersistentMessage = syncSendPersistentMessage;
    }

    public boolean isSyncSendNonPersistentMessage() {
        return this.syncSendNonPersistentMessage;
    }

    public void setSyncSendNonPersistentMessage(boolean syncSendNonPersistentMessage) {
        this.syncSendNonPersistentMessage = syncSendNonPersistentMessage;
    }

    public String getBrokerURL() {
        return this.brokerURL;
    }

    public void setBrokerURL(String brokerURL) {
        this.brokerURL = brokerURL;
    }

    public int getConsumerPriorityBase() {
        return this.consumerPriorityBase;
    }

    public void setConsumerPriorityBase(int consumerPriorityBase) {
        this.consumerPriorityBase = consumerPriorityBase;
    }

    public boolean isStaticBridge() {
        return this.staticBridge;
    }

    public void setStaticBridge(boolean staticBridge) {
        this.staticBridge = staticBridge;
    }

    public void setUseCompression(boolean useCompression) {
        this.useCompression = useCompression;
    }

    public boolean isUseCompression() {
        return this.useCompression;
    }

    public boolean isSuppressSameRouteSubscriptions() {
        return this.suppressSameRouteSubscriptions;
    }

    public void setSuppressSameRouteSubscriptions(boolean suppressSameRouteSubscriptions) {
        this.suppressSameRouteSubscriptions = suppressSameRouteSubscriptions;
    }
}

