/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.network;

import com.bes.mq.Service;
import com.bes.mq.broker.BrokerService;
import com.bes.mq.broker.jmx.AnnotatedMBean;
import com.bes.mq.broker.jmx.NetworkBridgeView;
import com.bes.mq.command.BESMQDestination;
import com.bes.mq.command.ConsumerId;
import com.bes.mq.network.ConnectionFilter;
import com.bes.mq.network.DemandForwardingBridgeSupport;
import com.bes.mq.network.NetworkBridge;
import com.bes.mq.network.NetworkBridgeConfiguration;
import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;
import com.bes.mq.transport.Transport;
import com.bes.mq.transport.TransportFactory;
import com.bes.mq.util.JMXSupport;
import com.bes.mq.util.ServiceStopper;
import com.bes.mq.util.ServiceSupport;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NetworkConnector
extends NetworkBridgeConfiguration
implements Service {
    private static final Logger LOG = LoggerFactory.getLogger(NetworkConnector.class);
    protected URI localURI;
    protected ConnectionFilter connectionFilter;
    protected ConcurrentHashMap<URI, NetworkBridge> bridges = new ConcurrentHashMap();
    protected ServiceSupport serviceSupport = new ServiceSupport(){

        protected void doStart() throws Exception {
            NetworkConnector.this.handleStart();
        }

        protected void doStop(ServiceStopper stopper) throws Exception {
            NetworkConnector.this.handleStop(stopper);
        }
    };
    private Set<BESMQDestination> durableDestinations;
    private List<BESMQDestination> excludedDestinations = new CopyOnWriteArrayList<BESMQDestination>();
    private List<BESMQDestination> dynamicallyIncludedDestinations = new CopyOnWriteArrayList<BESMQDestination>();
    private List<BESMQDestination> staticallyIncludedDestinations = new CopyOnWriteArrayList<BESMQDestination>();
    private BrokerService brokerService;
    private ObjectName objectName;

    public NetworkConnector() {
    }

    public NetworkConnector(URI localURI) {
        this.localURI = localURI;
    }

    public URI getLocalUri() throws URISyntaxException {
        return this.localURI;
    }

    public void setLocalUri(URI localURI) {
        this.localURI = localURI;
    }

    public Set<BESMQDestination> getDurableDestinations() {
        return this.durableDestinations;
    }

    public void setDurableDestinations(Set<BESMQDestination> durableDestinations) {
        this.durableDestinations = durableDestinations;
    }

    @Override
    public List<BESMQDestination> getExcludedDestinations() {
        return this.excludedDestinations;
    }

    @Override
    public void setExcludedDestinations(List<BESMQDestination> excludedDestinations) {
        this.excludedDestinations = excludedDestinations;
    }

    public void addExcludedDestination(BESMQDestination destiantion) {
        this.excludedDestinations.add(destiantion);
    }

    @Override
    public List<BESMQDestination> getStaticallyIncludedDestinations() {
        return this.staticallyIncludedDestinations;
    }

    @Override
    public void setStaticallyIncludedDestinations(List<BESMQDestination> staticallyIncludedDestinations) {
        this.staticallyIncludedDestinations = staticallyIncludedDestinations;
    }

    public void addStaticallyIncludedDestination(BESMQDestination destiantion) {
        this.staticallyIncludedDestinations.add(destiantion);
    }

    @Override
    public List<BESMQDestination> getDynamicallyIncludedDestinations() {
        return this.dynamicallyIncludedDestinations;
    }

    @Override
    public void setDynamicallyIncludedDestinations(List<BESMQDestination> dynamicallyIncludedDestinations) {
        this.dynamicallyIncludedDestinations = dynamicallyIncludedDestinations;
    }

    public void addDynamicallyIncludedDestination(BESMQDestination destiantion) {
        this.dynamicallyIncludedDestinations.add(destiantion);
    }

    public ConnectionFilter getConnectionFilter() {
        return this.connectionFilter;
    }

    public void setConnectionFilter(ConnectionFilter connectionFilter) {
        this.connectionFilter = connectionFilter;
    }

    protected NetworkBridge configureBridge(DemandForwardingBridgeSupport result) {
        List<BESMQDestination> destsList = this.getDynamicallyIncludedDestinations();
        BESMQDestination[] dests = destsList.toArray(new BESMQDestination[destsList.size()]);
        result.setDynamicallyIncludedDestinations(dests);
        destsList = this.getExcludedDestinations();
        dests = destsList.toArray(new BESMQDestination[destsList.size()]);
        result.setExcludedDestinations(dests);
        destsList = this.getStaticallyIncludedDestinations();
        dests = destsList.toArray(new BESMQDestination[destsList.size()]);
        result.setStaticallyIncludedDestinations(dests);
        if (this.durableDestinations != null) {
            HashSet<BESMQDestination> topics = new HashSet<BESMQDestination>();
            for (BESMQDestination d : this.durableDestinations) {
                if (!d.isTopic()) continue;
                topics.add(d);
            }
            BESMQDestination[] dest = new BESMQDestination[topics.size()];
            dest = topics.toArray(dest);
            result.setDurableDestinations(dest);
        }
        return result;
    }

    protected Transport createLocalTransport() throws Exception {
        return TransportFactory.connect(this.localURI);
    }

    @Override
    public void start() throws Exception {
        this.serviceSupport.start();
    }

    @Override
    public void stop() throws Exception {
        this.serviceSupport.stop();
    }

    protected void handleStart() throws Exception {
        if (this.localURI == null) {
            throw new IllegalStateException("Must configure the 'localURI' property");
        }
        LOG.info(this + " started");
    }

    protected void handleStop(ServiceStopper stopper) throws Exception {
        LOG.info(this + " stopped");
    }

    public boolean isStarted() {
        return this.serviceSupport.isStarted();
    }

    public boolean isStopped() {
        return this.serviceSupport.isStopped();
    }

    public boolean isStopping() {
        return this.serviceSupport.isStopping();
    }

    public ObjectName getObjectName() {
        return this.objectName;
    }

    public void setObjectName(ObjectName objectName) {
        this.objectName = objectName;
    }

    public BrokerService getBrokerService() {
        return this.brokerService;
    }

    public void setBrokerService(BrokerService brokerService) {
        this.brokerService = brokerService;
    }

    protected void registerNetworkBridgeMBean(NetworkBridge bridge) {
        if (!this.getBrokerService().isUseJmx()) {
            return;
        }
        NetworkBridgeView view = new NetworkBridgeView(bridge);
        try {
            ObjectName objectName = this.createNetworkBridgeObjectName(bridge);
            AnnotatedMBean.registerMBean(this.getBrokerService().getManagementContext(), view, objectName);
        }
        catch (Throwable e) {
            LOG.debug("Network bridge could not be registered in JMX: " + e.getMessage(), e);
        }
    }

    protected void unregisterNetworkBridgeMBean(NetworkBridge bridge) {
        if (!this.getBrokerService().isUseJmx()) {
            return;
        }
        try {
            ObjectName objectName = this.createNetworkBridgeObjectName(bridge);
            this.getBrokerService().getManagementContext().unregisterMBean(objectName);
        }
        catch (Throwable e) {
            LOG.debug("Network bridge could not be unregistered in JMX: " + e.getMessage(), e);
        }
    }

    protected ObjectName createNetworkBridgeObjectName(NetworkBridge bridge) throws MalformedObjectNameException {
        ObjectName connectorName = this.getObjectName();
        HashMap<String, String> map = new HashMap<String, String>(connectorName.getKeyPropertyList());
        return new ObjectName(connectorName.getDomain() + ":" + "BrokerName=" + JMXSupport.encodeObjectNamePart((String)map.get("BrokerName")) + "," + "Type=NetworkBridge," + "NetworkConnectorName=" + JMXSupport.encodeObjectNamePart((String)map.get("NetworkConnectorName")) + "," + "Name=" + JMXSupport.encodeObjectNamePart(JMXSupport.encodeObjectNamePart(bridge.getRemoteAddress())));
    }

    public boolean removeDemandSubscription(ConsumerId consumerId) {
        boolean removeSucceeded = false;
        for (NetworkBridge bridge : this.bridges.values()) {
            DemandForwardingBridgeSupport demandBridge;
            if (!(bridge instanceof DemandForwardingBridgeSupport) || !(demandBridge = (DemandForwardingBridgeSupport)bridge).removeDemandSubscriptionByLocalId(consumerId)) continue;
            removeSucceeded = true;
            break;
        }
        return removeSucceeded;
    }

    public Collection<NetworkBridge> activeBridges() {
        return this.bridges.values();
    }
}

