/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.notification;

import com.bes.mq.BESMQMessageConsumer;
import com.bes.mq.Service;
import com.bes.mq.command.BESMQDestination;
import com.bes.mq.command.BESMQMessage;
import com.bes.mq.command.BESMQTopic;
import com.bes.mq.command.ConsumerId;
import com.bes.mq.command.ConsumerInfo;
import com.bes.mq.command.DataStructure;
import com.bes.mq.command.RemoveInfo;
import com.bes.mq.notification.ConsumerEvent;
import com.bes.mq.notification.ConsumerListener;
import com.bes.mq.notification.ConsumerStartedEvent;
import com.bes.mq.notification.ConsumerStoppedEvent;
import com.bes.mq.notification.NotificationSupport;
import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Session;

public class ConsumerEventSource
implements Service,
MessageListener {
    private static final Logger LOG = LoggerFactory.getLogger(ConsumerEventSource.class);
    private final Connection connection;
    private final BESMQDestination destination;
    private ConsumerListener listener;
    private AtomicBoolean started = new AtomicBoolean(false);
    private AtomicInteger consumerCount = new AtomicInteger();
    private Session session;
    private BESMQMessageConsumer consumer;

    public ConsumerEventSource(Connection connection, Destination destination) throws JMSException {
        this.connection = connection;
        this.destination = BESMQDestination.transform(destination);
    }

    public void setConsumerListener(ConsumerListener listener) {
        this.listener = listener;
    }

    public String getConsumerId() {
        return this.consumer != null ? this.consumer.getConsumerId().toString() : "NOT_SET";
    }

    public void start() throws Exception {
        if (this.started.compareAndSet(false, true)) {
            this.session = this.connection.createSession(false, 1);
            BESMQTopic notificationTopic = NotificationSupport.getConsumerNotificationTopic(this.destination);
            this.consumer = (BESMQMessageConsumer)this.session.createConsumer(notificationTopic);
            this.consumer.setMessageListener(this);
        }
    }

    public void stop() throws Exception {
        if (this.started.compareAndSet(true, false) && this.session != null) {
            this.session.close();
        }
    }

    public void onMessage(Message message) {
        if (message instanceof BESMQMessage) {
            BESMQMessage activeMessage = (BESMQMessage)message;
            DataStructure command = activeMessage.getDataStructure();
            int count = 0;
            if (command instanceof ConsumerInfo) {
                count = this.consumerCount.incrementAndGet();
                count = this.extractConsumerCountFromMessage(message, count);
                this.fireConsumerEvent(new ConsumerStartedEvent(this, this.destination, (ConsumerInfo)command, count));
            } else if (command instanceof RemoveInfo) {
                RemoveInfo removeInfo = (RemoveInfo)command;
                if (removeInfo.isConsumerRemove()) {
                    count = this.consumerCount.decrementAndGet();
                    count = this.extractConsumerCountFromMessage(message, count);
                    this.fireConsumerEvent(new ConsumerStoppedEvent(this, this.destination, (ConsumerId)removeInfo.getObjectId(), count));
                }
            } else {
                LOG.warn("Unknown command: " + command);
            }
        } else {
            LOG.warn("Unknown message type: " + message + ". Message ignored");
        }
    }

    protected int extractConsumerCountFromMessage(Message message, int count) {
        try {
            Object value = message.getObjectProperty("consumerCount");
            if (value instanceof Number) {
                Number n = (Number)value;
                return n.intValue();
            }
            LOG.warn("No consumerCount header available on the message: " + message);
        }
        catch (Exception e) {
            LOG.warn("Failed to extract consumerCount from message: " + message + ".Reason: " + e, e);
        }
        return count;
    }

    protected void fireConsumerEvent(ConsumerEvent event) {
        if (this.listener != null) {
            this.listener.onConsumerEvent(event);
        }
    }
}

