/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.notification;

import com.bes.mq.command.BESMQDestination;
import com.bes.mq.command.BESMQMessage;
import com.bes.mq.command.BESMQQueue;
import com.bes.mq.command.BESMQTempQueue;
import com.bes.mq.command.BESMQTempTopic;
import com.bes.mq.command.BESMQTopic;
import com.bes.mq.command.DataStructure;
import com.bes.mq.command.DestinationInfo;
import com.bes.mq.notification.ConsumerEventSource;
import com.bes.mq.notification.DestinationEvent;
import com.bes.mq.notification.DestinationListener;
import com.bes.mq.notification.NotificationSupport;
import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DestinationSource
implements MessageListener {
    private static final Logger LOG = LoggerFactory.getLogger(ConsumerEventSource.class);
    private AtomicBoolean started = new AtomicBoolean(false);
    private final Connection connection;
    private Session session;
    private MessageConsumer queueConsumer;
    private MessageConsumer topicConsumer;
    private MessageConsumer tempTopicConsumer;
    private MessageConsumer tempQueueConsumer;
    private Set<BESMQQueue> queues = new CopyOnWriteArraySet<BESMQQueue>();
    private Set<BESMQTopic> topics = new CopyOnWriteArraySet<BESMQTopic>();
    private Set<BESMQTempQueue> temporaryQueues = new CopyOnWriteArraySet<BESMQTempQueue>();
    private Set<BESMQTempTopic> temporaryTopics = new CopyOnWriteArraySet<BESMQTempTopic>();
    private DestinationListener listener;

    public DestinationSource(Connection connection) throws JMSException {
        this.connection = connection;
    }

    public DestinationListener getListener() {
        return this.listener;
    }

    public void setDestinationListener(DestinationListener listener) {
        this.listener = listener;
    }

    public Set<BESMQQueue> getQueues() {
        return this.queues;
    }

    public Set<BESMQTopic> getTopics() {
        return this.topics;
    }

    public Set<BESMQTempQueue> getTemporaryQueues() {
        return this.temporaryQueues;
    }

    public Set<BESMQTempTopic> getTemporaryTopics() {
        return this.temporaryTopics;
    }

    public void start() throws JMSException {
        if (this.started.compareAndSet(false, true)) {
            this.session = this.connection.createSession(false, 1);
            this.queueConsumer = this.session.createConsumer(NotificationSupport.QUEUE_NOTIFICATION_TOPIC);
            this.queueConsumer.setMessageListener(this);
            this.topicConsumer = this.session.createConsumer(NotificationSupport.TOPIC_NOTIFICATION_TOPIC);
            this.topicConsumer.setMessageListener(this);
            this.tempQueueConsumer = this.session.createConsumer(NotificationSupport.TEMP_QUEUE_NOTIFICATION_TOPIC);
            this.tempQueueConsumer.setMessageListener(this);
            this.tempTopicConsumer = this.session.createConsumer(NotificationSupport.TEMP_TOPIC_NOTIFICATION_TOPIC);
            this.tempTopicConsumer.setMessageListener(this);
        }
    }

    public void stop() throws JMSException {
        if (this.started.compareAndSet(true, false) && this.session != null) {
            this.session.close();
        }
    }

    @Override
    public void onMessage(Message message) {
        if (message instanceof BESMQMessage) {
            BESMQMessage activeMessage = (BESMQMessage)message;
            DataStructure command = activeMessage.getDataStructure();
            if (command instanceof DestinationInfo) {
                DestinationInfo destinationInfo = (DestinationInfo)command;
                DestinationEvent event = new DestinationEvent(this, destinationInfo);
                this.fireDestinationEvent(event);
            } else {
                LOG.warn("Unknown dataStructure: " + command);
            }
        } else {
            LOG.warn("Unknown message type: " + message + ". Message ignored");
        }
    }

    protected void fireDestinationEvent(DestinationEvent event) {
        BESMQDestination destination = event.getDestination();
        boolean add = event.isAddOperation();
        if (destination instanceof BESMQQueue) {
            BESMQQueue queue = (BESMQQueue)destination;
            if (add) {
                this.queues.add(queue);
            } else {
                this.queues.remove(queue);
            }
        } else if (destination instanceof BESMQTopic) {
            BESMQTopic topic = (BESMQTopic)destination;
            if (add) {
                this.topics.add(topic);
            } else {
                this.topics.remove(topic);
            }
        } else if (destination instanceof BESMQTempQueue) {
            BESMQTempQueue queue = (BESMQTempQueue)destination;
            if (add) {
                this.temporaryQueues.add(queue);
            } else {
                this.temporaryQueues.remove(queue);
            }
        } else if (destination instanceof BESMQTempTopic) {
            BESMQTempTopic topic = (BESMQTempTopic)destination;
            if (add) {
                this.temporaryTopics.add(topic);
            } else {
                this.temporaryTopics.remove(topic);
            }
        } else {
            LOG.warn("Unknown destination type: " + destination);
        }
        if (this.listener != null) {
            this.listener.onDestinationEvent(event);
        }
    }
}

