/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.notification;

import com.bes.mq.broker.Broker;
import com.bes.mq.broker.BrokerFilter;
import com.bes.mq.broker.ConnectionContext;
import com.bes.mq.broker.ProducerBrokerExchange;
import com.bes.mq.broker.region.Destination;
import com.bes.mq.broker.region.MessageReference;
import com.bes.mq.broker.region.Subscription;
import com.bes.mq.broker.region.TopicSubscription;
import com.bes.mq.command.BESMQDestination;
import com.bes.mq.command.BESMQMessage;
import com.bes.mq.command.BESMQTopic;
import com.bes.mq.command.BrokerInfo;
import com.bes.mq.command.Command;
import com.bes.mq.command.ConnectionId;
import com.bes.mq.command.ConnectionInfo;
import com.bes.mq.command.ConsumerId;
import com.bes.mq.command.ConsumerInfo;
import com.bes.mq.command.DestinationInfo;
import com.bes.mq.command.Message;
import com.bes.mq.command.MessageId;
import com.bes.mq.command.ProducerId;
import com.bes.mq.command.ProducerInfo;
import com.bes.mq.notification.NotificationSupport;
import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;
import com.bes.mq.security.SecurityContext;
import com.bes.mq.state.ProducerState;
import com.bes.mq.usage.Usage;
import com.bes.mq.util.IdGenerator;
import com.bes.mq.util.LongSequenceGenerator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotificationBroker
extends BrokerFilter {
    private static final Logger LOG = LoggerFactory.getLogger(NotificationBroker.class);
    private static final IdGenerator ID_GENERATOR = new IdGenerator();
    protected final ConcurrentHashMap<ConnectionId, ConnectionInfo> connections = new ConcurrentHashMap();
    protected final ConcurrentHashMap<ConsumerId, ConsumerInfo> consumers = new ConcurrentHashMap();
    protected final ConcurrentHashMap<ProducerId, ProducerInfo> producers = new ConcurrentHashMap();
    protected final ConcurrentHashMap<BESMQDestination, DestinationInfo> destinations = new ConcurrentHashMap();
    protected final ConcurrentHashMap<BrokerInfo, BESMQMessage> networkBridges = new ConcurrentHashMap();
    protected final ProducerId notificationProducerId = new ProducerId();
    private final LongSequenceGenerator messageIdGenerator = new LongSequenceGenerator();

    public NotificationBroker(Broker next) {
        super(next);
        this.notificationProducerId.setConnectionId(ID_GENERATOR.generateId());
    }

    @Override
    public void addConnection(ConnectionContext context, ConnectionInfo info) throws Exception {
        super.addConnection(context, info);
        BESMQTopic topic = NotificationSupport.getConnectionNotificationTopic();
        ConnectionInfo copy = info.copy();
        copy.setUserName("");
        copy.setPassword("");
        this.fireNotification(context, topic, copy);
        this.connections.put(copy.getConnectionId(), copy);
    }

    @Override
    public Subscription addConsumer(ConnectionContext context, ConsumerInfo info) throws Exception {
        Subscription answer = super.addConsumer(context, info);
        if (!NotificationSupport.isNotificationTopic(info.getDestination())) {
            BESMQTopic topic = NotificationSupport.getConsumerNotificationTopic(info.getDestination());
            this.consumers.put(info.getConsumerId(), info);
            this.fireConsumerNotification(context, info.getDestination(), topic, info);
        } else {
            BESMQTopic topic;
            if (NotificationSupport.isConnectionNotificationTopic(info.getDestination())) {
                for (ConnectionInfo connectionInfo : this.connections.values()) {
                    topic = NotificationSupport.getConnectionNotificationTopic();
                    this.fireNotification(context, topic, connectionInfo, info.getConsumerId());
                }
            }
            if (NotificationSupport.isTempDestinationNotificationTopic(info.getDestination())) {
                for (DestinationInfo destinationInfo : this.destinations.values()) {
                    if (!destinationInfo.getDestination().isTemporary()) continue;
                    topic = NotificationSupport.getDestinationNotificationTopic(destinationInfo.getDestination());
                    this.fireNotification(context, topic, destinationInfo, info.getConsumerId());
                }
            } else if (NotificationSupport.isDestinationNotificationTopic(info.getDestination())) {
                for (DestinationInfo destinationInfo : this.destinations.values()) {
                    topic = NotificationSupport.getDestinationNotificationTopic(destinationInfo.getDestination());
                    this.fireNotification(context, topic, destinationInfo, info.getConsumerId());
                }
            }
            if (NotificationSupport.isProducerNotificationTopic(info.getDestination())) {
                for (ProducerInfo producerInfo : this.producers.values()) {
                    topic = NotificationSupport.getProducerNotificationTopic(producerInfo.getDestination());
                    this.fireProducerNotification(context, producerInfo.getDestination(), topic, producerInfo, info.getConsumerId());
                }
            }
            if (NotificationSupport.isConsumerNotificationTopic(info.getDestination())) {
                for (ConsumerInfo consumerInfo : this.consumers.values()) {
                    topic = NotificationSupport.getConsumerNotificationTopic(consumerInfo.getDestination());
                    this.fireConsumerNotification(context, consumerInfo.getDestination(), topic, consumerInfo, info.getConsumerId());
                }
            }
            if (NotificationSupport.isNetworkBridgeNotificationTopic(info.getDestination())) {
                for (BrokerInfo brokerInfo : this.networkBridges.keySet()) {
                    topic = NotificationSupport.getNetworkBridgeNotificationTopic();
                    this.fireNotification(context, topic, brokerInfo, null, this.networkBridges.get(brokerInfo));
                }
            }
        }
        return answer;
    }

    @Override
    public void addProducer(ConnectionContext context, ProducerInfo info) throws Exception {
        super.addProducer(context, info);
        if (info.getDestination() != null && !NotificationSupport.isNotificationTopic(info.getDestination())) {
            BESMQTopic topic = NotificationSupport.getProducerNotificationTopic(info.getDestination());
            this.fireProducerNotification(context, info.getDestination(), topic, info);
            this.producers.put(info.getProducerId(), info);
        }
    }

    @Override
    public Destination addDestination(ConnectionContext context, BESMQDestination destination, boolean create) throws Exception {
        DestinationInfo info;
        DestinationInfo previous;
        Destination answer = super.addDestination(context, destination, create);
        if (!NotificationSupport.isNotificationTopic(destination) && (previous = this.destinations.putIfAbsent(destination, info = new DestinationInfo(context.getConnectionId(), 0, destination))) == null) {
            BESMQTopic topic = NotificationSupport.getDestinationNotificationTopic(destination);
            this.fireNotification(context, topic, info);
        }
        return answer;
    }

    @Override
    public void addDestinationInfo(ConnectionContext context, DestinationInfo info) throws Exception {
        DestinationInfo previous;
        BESMQDestination destination = info.getDestination();
        this.next.addDestinationInfo(context, info);
        if (!NotificationSupport.isNotificationTopic(destination) && (previous = this.destinations.putIfAbsent(destination, info)) == null) {
            BESMQTopic topic = NotificationSupport.getDestinationNotificationTopic(destination);
            this.fireNotification(context, topic, info);
        }
    }

    @Override
    public void removeDestination(ConnectionContext context, BESMQDestination destination, long timeout) throws Exception {
        super.removeDestination(context, destination, timeout);
        DestinationInfo info = this.destinations.remove(destination);
        if (info != null) {
            BESMQTopic[] notificationDestinations;
            info = info.copy();
            info.setDestination(destination);
            info.setOperationType((byte)1);
            BESMQTopic topic = NotificationSupport.getDestinationNotificationTopic(destination);
            this.fireNotification(context, topic, info);
            for (BESMQTopic notificationDestination : notificationDestinations = NotificationSupport.getAllDestinationNotificationTopics(destination)) {
                try {
                    this.next.removeDestination(context, notificationDestination, -1L);
                }
                catch (Exception expectedIfDestinationDidNotExistYet) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void removeDestinationInfo(ConnectionContext context, DestinationInfo destInfo) throws Exception {
        super.removeDestinationInfo(context, destInfo);
        DestinationInfo info = this.destinations.remove(destInfo.getDestination());
        if (info != null) {
            BESMQTopic[] notificationDestinations;
            info = info.copy();
            info.setDestination(destInfo.getDestination());
            info.setOperationType((byte)1);
            BESMQTopic topic = NotificationSupport.getDestinationNotificationTopic(destInfo.getDestination());
            this.fireNotification(context, topic, info);
            for (BESMQTopic notificationDestination : notificationDestinations = NotificationSupport.getAllDestinationNotificationTopics(destInfo.getDestination())) {
                try {
                    this.next.removeDestination(context, notificationDestination, -1L);
                }
                catch (Exception expectedIfDestinationDidNotExistYet) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void removeConnection(ConnectionContext context, ConnectionInfo info, Throwable error) throws Exception {
        super.removeConnection(context, info, error);
        BESMQTopic topic = NotificationSupport.getConnectionNotificationTopic();
        this.fireNotification(context, topic, info.createRemoveCommand());
        this.connections.remove(info.getConnectionId());
    }

    @Override
    public void removeConsumer(ConnectionContext context, ConsumerInfo info) throws Exception {
        super.removeConsumer(context, info);
        BESMQDestination dest = info.getDestination();
        if (!NotificationSupport.isNotificationTopic(dest)) {
            BESMQTopic topic = NotificationSupport.getConsumerNotificationTopic(dest);
            this.consumers.remove(info.getConsumerId());
            if (!dest.isTemporary() || this.destinations.containsKey(dest)) {
                this.fireConsumerNotification(context, dest, topic, info.createRemoveCommand());
            }
        }
    }

    @Override
    public void removeProducer(ConnectionContext context, ProducerInfo info) throws Exception {
        super.removeProducer(context, info);
        BESMQDestination dest = info.getDestination();
        if (info.getDestination() != null && !NotificationSupport.isNotificationTopic(dest)) {
            BESMQTopic topic = NotificationSupport.getProducerNotificationTopic(dest);
            this.producers.remove(info.getProducerId());
            if (!dest.isTemporary() || this.destinations.contains(dest)) {
                this.fireProducerNotification(context, dest, topic, info.createRemoveCommand());
            }
        }
    }

    @Override
    public void messageExpired(ConnectionContext context, MessageReference messageReference, Subscription subscription) {
        super.messageExpired(context, messageReference, subscription);
        try {
            if (!messageReference.isNotification()) {
                BESMQTopic topic = NotificationSupport.getExpiredMessageTopic(messageReference.getMessage().getDestination());
                Message payload = messageReference.getMessage().copy();
                payload.clearBody();
                BESMQMessage notificationMessage = new BESMQMessage();
                notificationMessage.setStringProperty("orignalMessageId", payload.getMessageId().toString());
                this.fireNotification(context, topic, payload, null, notificationMessage);
            }
        }
        catch (Exception e) {
            this.handleFireFailure("expired", e);
        }
    }

    @Override
    public void messageConsumed(ConnectionContext context, MessageReference messageReference) {
        super.messageConsumed(context, messageReference);
        try {
            if (!messageReference.isNotification()) {
                BESMQTopic topic = NotificationSupport.getMessageConsumedNotificationTopic(messageReference.getMessage().getDestination());
                Message payload = messageReference.getMessage().copy();
                payload.clearBody();
                this.fireNotification(context, topic, payload);
            }
        }
        catch (Exception e) {
            this.handleFireFailure("consumed", e);
        }
    }

    @Override
    public void messageDelivered(ConnectionContext context, MessageReference messageReference) {
        super.messageDelivered(context, messageReference);
        try {
            if (!messageReference.isNotification()) {
                BESMQTopic topic = NotificationSupport.getMessageDeliveredNotificationTopic(messageReference.getMessage().getDestination());
                Message payload = messageReference.getMessage().copy();
                payload.clearBody();
                this.fireNotification(context, topic, payload);
            }
        }
        catch (Exception e) {
            this.handleFireFailure("delivered", e);
        }
    }

    @Override
    public void messageDiscarded(ConnectionContext context, Subscription sub, MessageReference messageReference) {
        super.messageDiscarded(context, sub, messageReference);
        try {
            if (!messageReference.isNotification()) {
                BESMQTopic topic = NotificationSupport.getMessageDiscardedNotificationTopic(messageReference.getMessage().getDestination());
                Message payload = messageReference.getMessage().copy();
                payload.clearBody();
                BESMQMessage notificationMessage = new BESMQMessage();
                if (sub instanceof TopicSubscription) {
                    notificationMessage.setIntProperty("discardedCount", ((TopicSubscription)sub).discarded());
                }
                notificationMessage.setStringProperty("consumerId", sub.getConsumerInfo().getConsumerId().toString());
                this.fireNotification(context, topic, payload, null, notificationMessage);
            }
        }
        catch (Exception e) {
            this.handleFireFailure("discarded", e);
        }
    }

    @Override
    public void slowConsumer(ConnectionContext context, Destination destination, Subscription subs) {
        super.slowConsumer(context, destination, subs);
        try {
            if (!NotificationSupport.isNotificationTopic(destination.getBESMQDestination())) {
                BESMQTopic topic = NotificationSupport.getSlowConsumerNotificationTopic(destination.getBESMQDestination());
                BESMQMessage notificationMessage = new BESMQMessage();
                notificationMessage.setStringProperty("consumerId", subs.getConsumerInfo().getConsumerId().toString());
                this.fireNotification(context, topic, subs.getConsumerInfo(), null, notificationMessage);
            }
        }
        catch (Exception e) {
            this.handleFireFailure("slow consumer", e);
        }
    }

    @Override
    public void fastProducer(ConnectionContext context, ProducerInfo producerInfo, BESMQDestination destination) {
        super.fastProducer(context, producerInfo, destination);
        try {
            if (!NotificationSupport.isNotificationTopic(destination)) {
                BESMQTopic topic = NotificationSupport.getFastProducerNotificationTopic(destination);
                BESMQMessage notificationMessage = new BESMQMessage();
                notificationMessage.setStringProperty("producerId", producerInfo.getProducerId().toString());
                this.fireNotification(context, topic, producerInfo, null, notificationMessage);
            }
        }
        catch (Exception e) {
            this.handleFireFailure("fast producer", e);
        }
    }

    @Override
    public void isFull(ConnectionContext context, Destination destination, Usage usage) {
        super.isFull(context, destination, usage);
        if (!NotificationSupport.isNotificationTopic(destination.getBESMQDestination())) {
            try {
                BESMQTopic topic = NotificationSupport.getFullNotificationTopic(destination.getBESMQDestination());
                BESMQMessage notificationMessage = new BESMQMessage();
                notificationMessage.setStringProperty("usageName", usage.getName());
                this.fireNotification(context, topic, null, null, notificationMessage);
            }
            catch (Exception e) {
                this.handleFireFailure("is full", e);
            }
        }
    }

    @Override
    public void nowMasterBroker() {
        super.nowMasterBroker();
        try {
            BESMQTopic topic = NotificationSupport.getMasterBrokerNotificationTopic();
            BESMQMessage notificationMessage = new BESMQMessage();
            ConnectionContext context = new ConnectionContext();
            context.setSecurityContext(SecurityContext.BROKER_SECURITY_CONTEXT);
            context.setBroker(this.getBrokerService().getBroker());
            this.fireNotification(context, topic, null, null, notificationMessage);
        }
        catch (Exception e) {
            this.handleFireFailure("now master broker", e);
        }
    }

    @Override
    public boolean sendToDeadLetterQueue(ConnectionContext context, MessageReference messageReference, Subscription subscription, Throwable poisonCause) {
        boolean wasDLQd = super.sendToDeadLetterQueue(context, messageReference, subscription, poisonCause);
        if (wasDLQd) {
            try {
                if (!messageReference.isNotification()) {
                    BESMQTopic topic = NotificationSupport.getMessageDLQdNotificationTopic(messageReference.getMessage().getDestination());
                    Message payload = messageReference.getMessage().copy();
                    payload.clearBody();
                    this.fireNotification(context, topic, payload);
                }
            }
            catch (Exception e) {
                this.handleFireFailure("add to DLQ", e);
            }
        }
        return wasDLQd;
    }

    @Override
    public void networkBridgeStarted(BrokerInfo brokerInfo, boolean createdByDuplex, String remoteIp) {
        try {
            if (brokerInfo != null) {
                BESMQMessage notificationMessage = new BESMQMessage();
                notificationMessage.setBooleanProperty("started", true);
                notificationMessage.setBooleanProperty("createdByDuplex", createdByDuplex);
                notificationMessage.setStringProperty("remoteIp", remoteIp);
                this.networkBridges.putIfAbsent(brokerInfo, notificationMessage);
                BESMQTopic topic = NotificationSupport.getNetworkBridgeNotificationTopic();
                ConnectionContext context = new ConnectionContext();
                context.setSecurityContext(SecurityContext.BROKER_SECURITY_CONTEXT);
                context.setBroker(this.getBrokerService().getBroker());
                this.fireNotification(context, topic, brokerInfo, null, notificationMessage);
            }
        }
        catch (Exception e) {
            this.handleFireFailure("network bridge started", e);
        }
    }

    @Override
    public void networkBridgeStopped(BrokerInfo brokerInfo) {
        try {
            if (brokerInfo != null) {
                BESMQMessage notificationMessage = new BESMQMessage();
                notificationMessage.setBooleanProperty("started", false);
                this.networkBridges.remove(brokerInfo);
                BESMQTopic topic = NotificationSupport.getNetworkBridgeNotificationTopic();
                ConnectionContext context = new ConnectionContext();
                context.setSecurityContext(SecurityContext.BROKER_SECURITY_CONTEXT);
                context.setBroker(this.getBrokerService().getBroker());
                this.fireNotification(context, topic, brokerInfo, null, notificationMessage);
            }
        }
        catch (Exception e) {
            this.handleFireFailure("network bridge stopped", e);
        }
    }

    private void handleFireFailure(String message, Throwable cause) {
        LOG.warn("Failed to fire " + message + " notification, reason: " + cause);
        if (LOG.isDebugEnabled()) {
            LOG.debug(message + " detail", cause);
        }
    }

    protected void fireNotification(ConnectionContext context, BESMQTopic topic, Command command) throws Exception {
        this.fireNotification(context, topic, command, null);
    }

    protected void fireNotification(ConnectionContext context, BESMQTopic topic, Command command, ConsumerId targetConsumerId) throws Exception {
        BESMQMessage notificationMessage = new BESMQMessage();
        this.fireNotification(context, topic, command, targetConsumerId, notificationMessage);
    }

    protected void fireConsumerNotification(ConnectionContext context, BESMQDestination consumerDestination, BESMQTopic topic, Command command) throws Exception {
        this.fireConsumerNotification(context, consumerDestination, topic, command, null);
    }

    protected void fireConsumerNotification(ConnectionContext context, BESMQDestination consumerDestination, BESMQTopic topic, Command command, ConsumerId targetConsumerId) throws Exception {
        BESMQMessage notificationMessage = new BESMQMessage();
        int count = 0;
        Set<Destination> set = this.getDestinations(consumerDestination);
        if (set != null) {
            for (Destination dest : set) {
                count = (int)((long)count + dest.getDestinationStatistics().getConsumers().getCount());
            }
        }
        notificationMessage.setIntProperty("consumerCount", count);
        this.fireNotification(context, topic, command, targetConsumerId, notificationMessage);
    }

    protected void fireProducerNotification(ConnectionContext context, BESMQDestination producerDestination, BESMQTopic topic, Command command) throws Exception {
        this.fireProducerNotification(context, producerDestination, topic, command, null);
    }

    protected void fireProducerNotification(ConnectionContext context, BESMQDestination producerDestination, BESMQTopic topic, Command command, ConsumerId targetConsumerId) throws Exception {
        Set<Destination> set;
        BESMQMessage notificationMessage = new BESMQMessage();
        int count = 0;
        if (producerDestination != null && (set = this.getDestinations(producerDestination)) != null) {
            for (Destination dest : set) {
                count = (int)((long)count + dest.getDestinationStatistics().getProducers().getCount());
            }
        }
        notificationMessage.setIntProperty("producerCount", count);
        this.fireNotification(context, topic, command, targetConsumerId, notificationMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireNotification(ConnectionContext context, BESMQTopic topic, Command command, ConsumerId targetConsumerId, BESMQMessage notificationMessage) throws Exception {
        if (this.getBrokerService().isStarted()) {
            notificationMessage.setStringProperty("originBrokerName", this.getBrokerName());
            String id = this.getBrokerId() != null ? this.getBrokerId().getValue() : "NOT_SET";
            notificationMessage.setStringProperty("originBrokerId", id);
            String url = this.getBrokerService().getVmConnectorURI().toString();
            if (this.getBrokerService().getDefaultSocketURIString() != null) {
                url = this.getBrokerService().getDefaultSocketURIString();
            }
            notificationMessage.setStringProperty("originBrokerURL", url);
            notificationMessage.setDataStructure(command);
            notificationMessage.setPersistent(false);
            notificationMessage.setType("Notification");
            notificationMessage.setMessageId(new MessageId(this.notificationProducerId, this.messageIdGenerator.getNextSequenceId()));
            notificationMessage.setTargetConsumerId(targetConsumerId);
            notificationMessage.setDestination(topic);
            notificationMessage.setResponseRequired(false);
            notificationMessage.setProducerId(this.notificationProducerId);
            boolean originalFlowControl = context.isProducerFlowControl();
            ProducerBrokerExchange producerExchange = new ProducerBrokerExchange();
            producerExchange.setConnectionContext(context);
            producerExchange.setMutable(true);
            producerExchange.setProducerState(new ProducerState(new ProducerInfo()));
            try {
                context.setProducerFlowControl(false);
                this.next.send(producerExchange, notificationMessage);
            }
            finally {
                context.setProducerFlowControl(originalFlowControl);
            }
        }
    }

    public Map<ConnectionId, ConnectionInfo> getNotificationConnections() {
        return this.connections;
    }

    public Map<ConsumerId, ConsumerInfo> getNotificationConsumers() {
        return this.consumers;
    }

    public Map<ProducerId, ProducerInfo> getNotificationProducers() {
        return this.producers;
    }

    public Map<BESMQDestination, DestinationInfo> getNotificationDestinations() {
        return this.destinations;
    }
}

