/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.notification;

import com.bes.mq.BESMQMessageTransformation;
import com.bes.mq.command.BESMQDestination;
import com.bes.mq.command.BESMQTopic;
import java.util.ArrayList;
import javax.jms.Destination;
import javax.jms.JMSException;

public final class NotificationSupport {
    public static final String NOTIFICATION_TOPIC_PREFIX = "BESMQ.Notification.";
    public static final BESMQTopic CONNECTION_NOTIFICATION_TOPIC = new BESMQTopic("BESMQ.Notification.Connection");
    public static final BESMQTopic QUEUE_NOTIFICATION_TOPIC = new BESMQTopic("BESMQ.Notification.Queue");
    public static final BESMQTopic TOPIC_NOTIFICATION_TOPIC = new BESMQTopic("BESMQ.Notification.Topic");
    public static final BESMQTopic TEMP_QUEUE_NOTIFICATION_TOPIC = new BESMQTopic("BESMQ.Notification.TempQueue");
    public static final BESMQTopic TEMP_TOPIC_NOTIFICATION_TOPIC = new BESMQTopic("BESMQ.Notification.TempTopic");
    public static final String PRODUCER_NOTIFICATION_TOPIC_PREFIX = "BESMQ.Notification.Producer.";
    public static final String QUEUE_PRODUCER_NOTIFICATION_TOPIC_PREFIX = "BESMQ.Notification.Producer.Queue.";
    public static final String TOPIC_PRODUCER_NOTIFICATION_TOPIC_PREFIX = "BESMQ.Notification.Producer.Topic.";
    public static final String CONSUMER_NOTIFICATION_TOPIC_PREFIX = "BESMQ.Notification.Consumer.";
    public static final String QUEUE_CONSUMER_NOTIFICATION_TOPIC_PREFIX = "BESMQ.Notification.Consumer.Queue.";
    public static final String TOPIC_CONSUMER_NOTIFICATION_TOPIC_PREFIX = "BESMQ.Notification.Consumer.Topic.";
    public static final String EXPIRED_TOPIC_MESSAGES_TOPIC_PREFIX = "BESMQ.Notification.Expired.Topic.";
    public static final String EXPIRED_QUEUE_MESSAGES_TOPIC_PREFIX = "BESMQ.Notification.Expired.Queue.";
    public static final String NO_TOPIC_CONSUMERS_TOPIC_PREFIX = "BESMQ.Notification.NoConsumer.Topic.";
    public static final String NO_QUEUE_CONSUMERS_TOPIC_PREFIX = "BESMQ.Notification.NoConsumer.Queue.";
    public static final String SLOW_CONSUMER_TOPIC_PREFIX = "BESMQ.Notification.SlowConsumer.";
    public static final String FAST_PRODUCER_TOPIC_PREFIX = "BESMQ.Notification.FastProducer.";
    public static final String MESSAGE_DISCAREDED_TOPIC_PREFIX = "BESMQ.Notification.MessageDiscarded.";
    public static final String FULL_TOPIC_PREFIX = "BESMQ.Notification.FULL.";
    public static final String MESSAGE_DELIVERED_TOPIC_PREFIX = "BESMQ.Notification.MessageDelivered.";
    public static final String MESSAGE_CONSUMED_TOPIC_PREFIX = "BESMQ.Notification.MessageConsumed.";
    public static final String MESSAGE_DLQ_TOPIC_PREFIX = "BESMQ.Notification.MessageDLQd.";
    public static final String MASTER_BROKER_TOPIC_PREFIX = "BESMQ.Notification.MasterBroker";
    public static final String NETWORK_BRIDGE_TOPIC_PREFIX = "BESMQ.Notification.NetworkBridge";
    public static final String AGENT_TOPIC = "BESMQ.Agent";
    public static final String ADIVSORY_MESSAGE_TYPE = "Notification";
    public static final String MSG_PROPERTY_ORIGIN_BROKER_ID = "originBrokerId";
    public static final String MSG_PROPERTY_ORIGIN_BROKER_NAME = "originBrokerName";
    public static final String MSG_PROPERTY_ORIGIN_BROKER_URL = "originBrokerURL";
    public static final String MSG_PROPERTY_USAGE_NAME = "usageName";
    public static final String MSG_PROPERTY_CONSUMER_ID = "consumerId";
    public static final String MSG_PROPERTY_PRODUCER_ID = "producerId";
    public static final String MSG_PROPERTY_MESSAGE_ID = "orignalMessageId";
    public static final String MSG_PROPERTY_CONSUMER_COUNT = "consumerCount";
    public static final String MSG_PROPERTY_DISCARDED_COUNT = "discardedCount";
    public static final BESMQTopic ALL_DESTINATIONS_COMPOSITE_NOTIFICATION_TOPIC = new BESMQTopic(TOPIC_NOTIFICATION_TOPIC.getPhysicalName() + "," + QUEUE_NOTIFICATION_TOPIC.getPhysicalName() + "," + TEMP_QUEUE_NOTIFICATION_TOPIC.getPhysicalName() + "," + TEMP_TOPIC_NOTIFICATION_TOPIC.getPhysicalName());
    public static final BESMQTopic TEMP_DESTINATION_COMPOSITE_NOTIFICATION_TOPIC = new BESMQTopic(TEMP_QUEUE_NOTIFICATION_TOPIC.getPhysicalName() + "," + TEMP_TOPIC_NOTIFICATION_TOPIC.getPhysicalName());
    private static final BESMQTopic AGENT_TOPIC_DESTINATION = new BESMQTopic("BESMQ.Agent");

    private NotificationSupport() {
    }

    public static BESMQTopic getConnectionNotificationTopic() {
        return CONNECTION_NOTIFICATION_TOPIC;
    }

    public static BESMQTopic[] getAllDestinationNotificationTopics(Destination destination) throws JMSException {
        return NotificationSupport.getAllDestinationNotificationTopics(BESMQMessageTransformation.transformDestination(destination));
    }

    public static BESMQTopic[] getAllDestinationNotificationTopics(BESMQDestination destination) throws JMSException {
        ArrayList<BESMQTopic> result = new ArrayList<BESMQTopic>();
        result.add(NotificationSupport.getConsumerNotificationTopic(destination));
        result.add(NotificationSupport.getProducerNotificationTopic(destination));
        result.add(NotificationSupport.getExpiredMessageTopic(destination));
        result.add(NotificationSupport.getNoConsumersNotificationTopic(destination));
        result.add(NotificationSupport.getSlowConsumerNotificationTopic(destination));
        result.add(NotificationSupport.getFastProducerNotificationTopic(destination));
        result.add(NotificationSupport.getMessageDiscardedNotificationTopic(destination));
        result.add(NotificationSupport.getMessageDeliveredNotificationTopic(destination));
        result.add(NotificationSupport.getMessageConsumedNotificationTopic(destination));
        result.add(NotificationSupport.getMessageDLQdNotificationTopic(destination));
        result.add(NotificationSupport.getFullNotificationTopic(destination));
        return result.toArray(new BESMQTopic[0]);
    }

    public static BESMQTopic getConsumerNotificationTopic(Destination destination) throws JMSException {
        return NotificationSupport.getConsumerNotificationTopic(BESMQMessageTransformation.transformDestination(destination));
    }

    public static BESMQTopic getConsumerNotificationTopic(BESMQDestination destination) {
        if (destination.isQueue()) {
            return new BESMQTopic(QUEUE_CONSUMER_NOTIFICATION_TOPIC_PREFIX + destination.getPhysicalName());
        }
        return new BESMQTopic(TOPIC_CONSUMER_NOTIFICATION_TOPIC_PREFIX + destination.getPhysicalName());
    }

    public static BESMQTopic getProducerNotificationTopic(Destination destination) throws JMSException {
        return NotificationSupport.getProducerNotificationTopic(BESMQMessageTransformation.transformDestination(destination));
    }

    public static BESMQTopic getProducerNotificationTopic(BESMQDestination destination) {
        if (destination.isQueue()) {
            return new BESMQTopic(QUEUE_PRODUCER_NOTIFICATION_TOPIC_PREFIX + destination.getPhysicalName());
        }
        return new BESMQTopic(TOPIC_PRODUCER_NOTIFICATION_TOPIC_PREFIX + destination.getPhysicalName());
    }

    public static BESMQTopic getExpiredMessageTopic(Destination destination) throws JMSException {
        return NotificationSupport.getExpiredMessageTopic(BESMQMessageTransformation.transformDestination(destination));
    }

    public static BESMQTopic getExpiredMessageTopic(BESMQDestination destination) {
        if (destination.isQueue()) {
            return NotificationSupport.getExpiredQueueMessageNotificationTopic(destination);
        }
        return NotificationSupport.getExpiredTopicMessageNotificationTopic(destination);
    }

    public static BESMQTopic getExpiredTopicMessageNotificationTopic(BESMQDestination destination) {
        String name = EXPIRED_TOPIC_MESSAGES_TOPIC_PREFIX + destination.getPhysicalName();
        return new BESMQTopic(name);
    }

    public static BESMQTopic getExpiredQueueMessageNotificationTopic(Destination destination) throws JMSException {
        return NotificationSupport.getExpiredQueueMessageNotificationTopic(BESMQMessageTransformation.transformDestination(destination));
    }

    public static BESMQTopic getExpiredQueueMessageNotificationTopic(BESMQDestination destination) {
        String name = EXPIRED_QUEUE_MESSAGES_TOPIC_PREFIX + destination.getPhysicalName();
        return new BESMQTopic(name);
    }

    public static BESMQTopic getNoConsumersNotificationTopic(Destination destination) throws JMSException {
        return NotificationSupport.getExpiredMessageTopic(BESMQMessageTransformation.transformDestination(destination));
    }

    public static BESMQTopic getNoConsumersNotificationTopic(BESMQDestination destination) {
        if (destination.isQueue()) {
            return NotificationSupport.getNoQueueConsumersNotificationTopic(destination);
        }
        return NotificationSupport.getNoTopicConsumersNotificationTopic(destination);
    }

    public static BESMQTopic getNoTopicConsumersNotificationTopic(Destination destination) throws JMSException {
        return NotificationSupport.getNoTopicConsumersNotificationTopic(BESMQMessageTransformation.transformDestination(destination));
    }

    public static BESMQTopic getNoTopicConsumersNotificationTopic(BESMQDestination destination) {
        String name = NO_TOPIC_CONSUMERS_TOPIC_PREFIX + destination.getPhysicalName();
        return new BESMQTopic(name);
    }

    public static BESMQTopic getNoQueueConsumersNotificationTopic(Destination destination) throws JMSException {
        return NotificationSupport.getNoQueueConsumersNotificationTopic(BESMQMessageTransformation.transformDestination(destination));
    }

    public static BESMQTopic getNoQueueConsumersNotificationTopic(BESMQDestination destination) {
        String name = NO_QUEUE_CONSUMERS_TOPIC_PREFIX + destination.getPhysicalName();
        return new BESMQTopic(name);
    }

    public static BESMQTopic getSlowConsumerNotificationTopic(Destination destination) throws JMSException {
        return NotificationSupport.getSlowConsumerNotificationTopic(BESMQMessageTransformation.transformDestination(destination));
    }

    public static BESMQTopic getSlowConsumerNotificationTopic(BESMQDestination destination) {
        String name = SLOW_CONSUMER_TOPIC_PREFIX + destination.getDestinationTypeAsString() + "." + destination.getPhysicalName();
        return new BESMQTopic(name);
    }

    public static BESMQTopic getFastProducerNotificationTopic(Destination destination) throws JMSException {
        return NotificationSupport.getFastProducerNotificationTopic(BESMQMessageTransformation.transformDestination(destination));
    }

    public static BESMQTopic getFastProducerNotificationTopic(BESMQDestination destination) {
        String name = FAST_PRODUCER_TOPIC_PREFIX + destination.getDestinationTypeAsString() + "." + destination.getPhysicalName();
        return new BESMQTopic(name);
    }

    public static BESMQTopic getMessageDiscardedNotificationTopic(Destination destination) throws JMSException {
        return NotificationSupport.getMessageDiscardedNotificationTopic(BESMQMessageTransformation.transformDestination(destination));
    }

    public static BESMQTopic getMessageDiscardedNotificationTopic(BESMQDestination destination) {
        String name = MESSAGE_DISCAREDED_TOPIC_PREFIX + destination.getDestinationTypeAsString() + "." + destination.getPhysicalName();
        return new BESMQTopic(name);
    }

    public static BESMQTopic getMessageDeliveredNotificationTopic(Destination destination) throws JMSException {
        return NotificationSupport.getMessageDeliveredNotificationTopic(BESMQMessageTransformation.transformDestination(destination));
    }

    public static BESMQTopic getMessageDeliveredNotificationTopic(BESMQDestination destination) {
        String name = MESSAGE_DELIVERED_TOPIC_PREFIX + destination.getDestinationTypeAsString() + "." + destination.getPhysicalName();
        return new BESMQTopic(name);
    }

    public static BESMQTopic getMessageConsumedNotificationTopic(Destination destination) throws JMSException {
        return NotificationSupport.getMessageConsumedNotificationTopic(BESMQMessageTransformation.transformDestination(destination));
    }

    public static BESMQTopic getMessageConsumedNotificationTopic(BESMQDestination destination) {
        String name = MESSAGE_CONSUMED_TOPIC_PREFIX + destination.getDestinationTypeAsString() + "." + destination.getPhysicalName();
        return new BESMQTopic(name);
    }

    public static BESMQTopic getMessageDLQdNotificationTopic(BESMQDestination destination) {
        String name = MESSAGE_DLQ_TOPIC_PREFIX + destination.getDestinationTypeAsString() + "." + destination.getPhysicalName();
        return new BESMQTopic(name);
    }

    public static BESMQTopic getMasterBrokerNotificationTopic() {
        return new BESMQTopic(MASTER_BROKER_TOPIC_PREFIX);
    }

    public static BESMQTopic getNetworkBridgeNotificationTopic() {
        return new BESMQTopic(NETWORK_BRIDGE_TOPIC_PREFIX);
    }

    public static BESMQTopic getFullNotificationTopic(Destination destination) throws JMSException {
        return NotificationSupport.getFullNotificationTopic(BESMQMessageTransformation.transformDestination(destination));
    }

    public static BESMQTopic getFullNotificationTopic(BESMQDestination destination) {
        String name = FULL_TOPIC_PREFIX + destination.getDestinationTypeAsString() + "." + destination.getPhysicalName();
        return new BESMQTopic(name);
    }

    public static BESMQTopic getDestinationNotificationTopic(Destination destination) throws JMSException {
        return NotificationSupport.getDestinationNotificationTopic(BESMQMessageTransformation.transformDestination(destination));
    }

    public static BESMQTopic getDestinationNotificationTopic(BESMQDestination destination) {
        switch (destination.getDestinationType()) {
            case 1: {
                return QUEUE_NOTIFICATION_TOPIC;
            }
            case 2: {
                return TOPIC_NOTIFICATION_TOPIC;
            }
            case 5: {
                return TEMP_QUEUE_NOTIFICATION_TOPIC;
            }
            case 6: {
                return TEMP_TOPIC_NOTIFICATION_TOPIC;
            }
        }
        throw new RuntimeException("Unknown destination type: " + destination.getDestinationType());
    }

    public static boolean isDestinationNotificationTopic(Destination destination) throws JMSException {
        return NotificationSupport.isDestinationNotificationTopic(BESMQMessageTransformation.transformDestination(destination));
    }

    public static boolean isTempDestinationNotificationTopic(BESMQDestination destination) {
        if (destination.isComposite()) {
            BESMQDestination[] compositeDestinations = destination.getCompositeDestinations();
            for (int i = 0; i < compositeDestinations.length; ++i) {
                if (NotificationSupport.isTempDestinationNotificationTopic(compositeDestinations[i])) continue;
                return false;
            }
            return true;
        }
        return destination.equals(TEMP_QUEUE_NOTIFICATION_TOPIC) || destination.equals(TEMP_TOPIC_NOTIFICATION_TOPIC);
    }

    public static boolean isDestinationNotificationTopic(BESMQDestination destination) {
        if (destination.isComposite()) {
            BESMQDestination[] compositeDestinations = destination.getCompositeDestinations();
            for (int i = 0; i < compositeDestinations.length; ++i) {
                if (!NotificationSupport.isDestinationNotificationTopic(compositeDestinations[i])) continue;
                return true;
            }
            return false;
        }
        return destination.equals(TEMP_QUEUE_NOTIFICATION_TOPIC) || destination.equals(TEMP_TOPIC_NOTIFICATION_TOPIC) || destination.equals(QUEUE_NOTIFICATION_TOPIC) || destination.equals(TOPIC_NOTIFICATION_TOPIC);
    }

    public static boolean isNotificationTopic(Destination destination) throws JMSException {
        return NotificationSupport.isNotificationTopic(BESMQMessageTransformation.transformDestination(destination));
    }

    public static boolean isNotificationTopic(BESMQDestination destination) {
        if (destination != null) {
            if (destination.isComposite()) {
                BESMQDestination[] compositeDestinations = destination.getCompositeDestinations();
                for (int i = 0; i < compositeDestinations.length; ++i) {
                    if (!NotificationSupport.isNotificationTopic(compositeDestinations[i])) continue;
                    return true;
                }
                return false;
            }
            return destination.isTopic() && destination.getPhysicalName().startsWith(NOTIFICATION_TOPIC_PREFIX);
        }
        return false;
    }

    public static boolean isConnectionNotificationTopic(Destination destination) throws JMSException {
        return NotificationSupport.isConnectionNotificationTopic(BESMQMessageTransformation.transformDestination(destination));
    }

    public static boolean isConnectionNotificationTopic(BESMQDestination destination) {
        if (destination.isComposite()) {
            BESMQDestination[] compositeDestinations = destination.getCompositeDestinations();
            for (int i = 0; i < compositeDestinations.length; ++i) {
                if (!NotificationSupport.isConnectionNotificationTopic(compositeDestinations[i])) continue;
                return true;
            }
            return false;
        }
        return destination.equals(CONNECTION_NOTIFICATION_TOPIC);
    }

    public static boolean isProducerNotificationTopic(Destination destination) throws JMSException {
        return NotificationSupport.isProducerNotificationTopic(BESMQMessageTransformation.transformDestination(destination));
    }

    public static boolean isProducerNotificationTopic(BESMQDestination destination) {
        if (destination.isComposite()) {
            BESMQDestination[] compositeDestinations = destination.getCompositeDestinations();
            for (int i = 0; i < compositeDestinations.length; ++i) {
                if (!NotificationSupport.isProducerNotificationTopic(compositeDestinations[i])) continue;
                return true;
            }
            return false;
        }
        return destination.isTopic() && destination.getPhysicalName().startsWith(PRODUCER_NOTIFICATION_TOPIC_PREFIX);
    }

    public static boolean isConsumerNotificationTopic(Destination destination) throws JMSException {
        return NotificationSupport.isConsumerNotificationTopic(BESMQMessageTransformation.transformDestination(destination));
    }

    public static boolean isConsumerNotificationTopic(BESMQDestination destination) {
        if (destination.isComposite()) {
            BESMQDestination[] compositeDestinations = destination.getCompositeDestinations();
            for (int i = 0; i < compositeDestinations.length; ++i) {
                if (!NotificationSupport.isConsumerNotificationTopic(compositeDestinations[i])) continue;
                return true;
            }
            return false;
        }
        return destination.isTopic() && destination.getPhysicalName().startsWith(CONSUMER_NOTIFICATION_TOPIC_PREFIX);
    }

    public static boolean isSlowConsumerNotificationTopic(Destination destination) throws JMSException {
        return NotificationSupport.isSlowConsumerNotificationTopic(BESMQMessageTransformation.transformDestination(destination));
    }

    public static boolean isSlowConsumerNotificationTopic(BESMQDestination destination) {
        if (destination.isComposite()) {
            BESMQDestination[] compositeDestinations = destination.getCompositeDestinations();
            for (int i = 0; i < compositeDestinations.length; ++i) {
                if (!NotificationSupport.isSlowConsumerNotificationTopic(compositeDestinations[i])) continue;
                return true;
            }
            return false;
        }
        return destination.isTopic() && destination.getPhysicalName().startsWith(SLOW_CONSUMER_TOPIC_PREFIX);
    }

    public static boolean isFastProducerNotificationTopic(Destination destination) throws JMSException {
        return NotificationSupport.isFastProducerNotificationTopic(BESMQMessageTransformation.transformDestination(destination));
    }

    public static boolean isFastProducerNotificationTopic(BESMQDestination destination) {
        if (destination.isComposite()) {
            BESMQDestination[] compositeDestinations = destination.getCompositeDestinations();
            for (int i = 0; i < compositeDestinations.length; ++i) {
                if (!NotificationSupport.isFastProducerNotificationTopic(compositeDestinations[i])) continue;
                return true;
            }
            return false;
        }
        return destination.isTopic() && destination.getPhysicalName().startsWith(FAST_PRODUCER_TOPIC_PREFIX);
    }

    public static boolean isMessageConsumedNotificationTopic(Destination destination) throws JMSException {
        return NotificationSupport.isMessageConsumedNotificationTopic(BESMQMessageTransformation.transformDestination(destination));
    }

    public static boolean isMessageConsumedNotificationTopic(BESMQDestination destination) {
        if (destination.isComposite()) {
            BESMQDestination[] compositeDestinations = destination.getCompositeDestinations();
            for (int i = 0; i < compositeDestinations.length; ++i) {
                if (!NotificationSupport.isMessageConsumedNotificationTopic(compositeDestinations[i])) continue;
                return true;
            }
            return false;
        }
        return destination.isTopic() && destination.getPhysicalName().startsWith(MESSAGE_CONSUMED_TOPIC_PREFIX);
    }

    public static boolean isMasterBrokerNotificationTopic(Destination destination) throws JMSException {
        return NotificationSupport.isMasterBrokerNotificationTopic(BESMQMessageTransformation.transformDestination(destination));
    }

    public static boolean isMasterBrokerNotificationTopic(BESMQDestination destination) {
        if (destination.isComposite()) {
            BESMQDestination[] compositeDestinations = destination.getCompositeDestinations();
            for (int i = 0; i < compositeDestinations.length; ++i) {
                if (!NotificationSupport.isMasterBrokerNotificationTopic(compositeDestinations[i])) continue;
                return true;
            }
            return false;
        }
        return destination.isTopic() && destination.getPhysicalName().startsWith(MASTER_BROKER_TOPIC_PREFIX);
    }

    public static boolean isMessageDeliveredNotificationTopic(Destination destination) throws JMSException {
        return NotificationSupport.isMessageDeliveredNotificationTopic(BESMQMessageTransformation.transformDestination(destination));
    }

    public static boolean isMessageDeliveredNotificationTopic(BESMQDestination destination) {
        if (destination.isComposite()) {
            BESMQDestination[] compositeDestinations = destination.getCompositeDestinations();
            for (int i = 0; i < compositeDestinations.length; ++i) {
                if (!NotificationSupport.isMessageDeliveredNotificationTopic(compositeDestinations[i])) continue;
                return true;
            }
            return false;
        }
        return destination.isTopic() && destination.getPhysicalName().startsWith(MESSAGE_DELIVERED_TOPIC_PREFIX);
    }

    public static boolean isMessageDiscardedNotificationTopic(Destination destination) throws JMSException {
        return NotificationSupport.isMessageDiscardedNotificationTopic(BESMQMessageTransformation.transformDestination(destination));
    }

    public static boolean isMessageDiscardedNotificationTopic(BESMQDestination destination) {
        if (destination.isComposite()) {
            BESMQDestination[] compositeDestinations = destination.getCompositeDestinations();
            for (int i = 0; i < compositeDestinations.length; ++i) {
                if (!NotificationSupport.isMessageDiscardedNotificationTopic(compositeDestinations[i])) continue;
                return true;
            }
            return false;
        }
        return destination.isTopic() && destination.getPhysicalName().startsWith(MESSAGE_DISCAREDED_TOPIC_PREFIX);
    }

    public static boolean isFullNotificationTopic(Destination destination) throws JMSException {
        return NotificationSupport.isFullNotificationTopic(BESMQMessageTransformation.transformDestination(destination));
    }

    public static boolean isFullNotificationTopic(BESMQDestination destination) {
        if (destination.isComposite()) {
            BESMQDestination[] compositeDestinations = destination.getCompositeDestinations();
            for (int i = 0; i < compositeDestinations.length; ++i) {
                if (!NotificationSupport.isFullNotificationTopic(compositeDestinations[i])) continue;
                return true;
            }
            return false;
        }
        return destination.isTopic() && destination.getPhysicalName().startsWith(FULL_TOPIC_PREFIX);
    }

    public static boolean isNetworkBridgeNotificationTopic(Destination destination) throws JMSException {
        return NotificationSupport.isNetworkBridgeNotificationTopic(BESMQMessageTransformation.transformDestination(destination));
    }

    public static boolean isNetworkBridgeNotificationTopic(BESMQDestination destination) {
        if (destination.isComposite()) {
            BESMQDestination[] compositeDestinations = destination.getCompositeDestinations();
            for (int i = 0; i < compositeDestinations.length; ++i) {
                if (!NotificationSupport.isNetworkBridgeNotificationTopic(compositeDestinations[i])) continue;
                return true;
            }
            return false;
        }
        return destination.isTopic() && destination.getPhysicalName().startsWith(NETWORK_BRIDGE_TOPIC_PREFIX);
    }

    public static Destination getAgentDestination() {
        return AGENT_TOPIC_DESTINATION;
    }
}

