/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.notification;

import com.bes.mq.Service;
import com.bes.mq.command.BESMQDestination;
import com.bes.mq.command.BESMQMessage;
import com.bes.mq.command.BESMQTopic;
import com.bes.mq.command.DataStructure;
import com.bes.mq.command.ProducerId;
import com.bes.mq.command.ProducerInfo;
import com.bes.mq.command.RemoveInfo;
import com.bes.mq.notification.NotificationSupport;
import com.bes.mq.notification.ProducerEvent;
import com.bes.mq.notification.ProducerListener;
import com.bes.mq.notification.ProducerStartedEvent;
import com.bes.mq.notification.ProducerStoppedEvent;
import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Session;

public class ProducerEventSource
implements Service,
MessageListener {
    private static final Logger LOG = LoggerFactory.getLogger(ProducerEventSource.class);
    private final Connection connection;
    private final BESMQDestination destination;
    private ProducerListener listener;
    private AtomicBoolean started = new AtomicBoolean(false);
    private AtomicInteger producerCount = new AtomicInteger();
    private Session session;
    private MessageConsumer consumer;

    public ProducerEventSource(Connection connection, Destination destination) throws JMSException {
        this.connection = connection;
        this.destination = BESMQDestination.transform(destination);
    }

    public void setProducerListener(ProducerListener listener) {
        this.listener = listener;
    }

    public void start() throws Exception {
        if (this.started.compareAndSet(false, true)) {
            this.session = this.connection.createSession(false, 1);
            BESMQTopic notificationTopic = NotificationSupport.getProducerNotificationTopic(this.destination);
            this.consumer = this.session.createConsumer(notificationTopic);
            this.consumer.setMessageListener(this);
        }
    }

    public void stop() throws Exception {
        if (this.started.compareAndSet(true, false) && this.session != null) {
            this.session.close();
        }
    }

    public void onMessage(Message message) {
        if (message instanceof BESMQMessage) {
            BESMQMessage activeMessage = (BESMQMessage)message;
            DataStructure command = activeMessage.getDataStructure();
            int count = 0;
            if (command instanceof ProducerInfo) {
                count = this.producerCount.incrementAndGet();
                count = this.extractProducerCountFromMessage(message, count);
                this.fireProducerEvent(new ProducerStartedEvent(this, this.destination, (ProducerInfo)command, count));
            } else if (command instanceof RemoveInfo) {
                RemoveInfo removeInfo = (RemoveInfo)command;
                if (removeInfo.isProducerRemove()) {
                    count = this.producerCount.decrementAndGet();
                    count = this.extractProducerCountFromMessage(message, count);
                    this.fireProducerEvent(new ProducerStoppedEvent(this, this.destination, (ProducerId)removeInfo.getObjectId(), count));
                }
            } else {
                LOG.warn("Unknown command: " + command);
            }
        } else {
            LOG.warn("Unknown message type: " + message + ". Message ignored");
        }
    }

    protected int extractProducerCountFromMessage(Message message, int count) {
        try {
            Object value = message.getObjectProperty("producerCount");
            if (value instanceof Number) {
                Number n = (Number)value;
                return n.intValue();
            }
            LOG.warn("No producerCount header available on the message: " + message);
        }
        catch (Exception e) {
            LOG.warn("Failed to extract producerCount from message: " + message + ".Reason: " + e, e);
        }
        return count;
    }

    protected void fireProducerEvent(ProducerEvent event) {
        if (this.listener != null) {
            this.listener.onProducerEvent(event);
        }
    }
}

