/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.org.apache.http.impl;

import com.bes.mq.org.apache.http.ConnectionReuseStrategy;
import com.bes.mq.org.apache.http.Header;
import com.bes.mq.org.apache.http.HeaderIterator;
import com.bes.mq.org.apache.http.HttpResponse;
import com.bes.mq.org.apache.http.HttpVersion;
import com.bes.mq.org.apache.http.ParseException;
import com.bes.mq.org.apache.http.ProtocolVersion;
import com.bes.mq.org.apache.http.TokenIterator;
import com.bes.mq.org.apache.http.annotation.Immutable;
import com.bes.mq.org.apache.http.message.BasicTokenIterator;
import com.bes.mq.org.apache.http.protocol.HttpContext;

@Immutable
public class DefaultConnectionReuseStrategy
implements ConnectionReuseStrategy {
    @Override
    public boolean keepAlive(HttpResponse response, HttpContext context) {
        HeaderIterator hit;
        ProtocolVersion ver;
        block17: {
            if (response == null) {
                throw new IllegalArgumentException("HTTP response may not be null.");
            }
            if (context == null) {
                throw new IllegalArgumentException("HTTP context may not be null.");
            }
            ver = response.getStatusLine().getProtocolVersion();
            Header teh = response.getFirstHeader("Transfer-Encoding");
            if (teh != null) {
                if (!"chunked".equalsIgnoreCase(teh.getValue())) {
                    return false;
                }
            } else if (this.canResponseHaveBody(response)) {
                Header[] clhs = response.getHeaders("Content-Length");
                if (clhs.length == 1) {
                    Header clh = clhs[0];
                    try {
                        int contentLen = Integer.parseInt(clh.getValue());
                        if (contentLen < 0) {
                            return false;
                        }
                        break block17;
                    }
                    catch (NumberFormatException ex) {
                        return false;
                    }
                }
                return false;
            }
        }
        if (!(hit = response.headerIterator("Connection")).hasNext()) {
            hit = response.headerIterator("Proxy-Connection");
        }
        if (hit.hasNext()) {
            try {
                TokenIterator ti = this.createTokenIterator(hit);
                boolean keepalive = false;
                while (ti.hasNext()) {
                    String token = ti.nextToken();
                    if ("Close".equalsIgnoreCase(token)) {
                        return false;
                    }
                    if (!"Keep-Alive".equalsIgnoreCase(token)) continue;
                    keepalive = true;
                }
                if (keepalive) {
                    return true;
                }
            }
            catch (ParseException px) {
                return false;
            }
        }
        return !ver.lessEquals(HttpVersion.HTTP_1_0);
    }

    protected TokenIterator createTokenIterator(HeaderIterator hit) {
        return new BasicTokenIterator(hit);
    }

    private boolean canResponseHaveBody(HttpResponse response) {
        int status = response.getStatusLine().getStatusCode();
        return status >= 200 && status != 204 && status != 304 && status != 205;
    }
}

