/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.org.apache.http.impl.auth;

import com.bes.mq.org.apache.http.FormattedHeader;
import com.bes.mq.org.apache.http.Header;
import com.bes.mq.org.apache.http.HttpRequest;
import com.bes.mq.org.apache.http.annotation.NotThreadSafe;
import com.bes.mq.org.apache.http.auth.AuthenticationException;
import com.bes.mq.org.apache.http.auth.ChallengeState;
import com.bes.mq.org.apache.http.auth.ContextAwareAuthScheme;
import com.bes.mq.org.apache.http.auth.Credentials;
import com.bes.mq.org.apache.http.auth.MalformedChallengeException;
import com.bes.mq.org.apache.http.protocol.HTTP;
import com.bes.mq.org.apache.http.protocol.HttpContext;
import com.bes.mq.org.apache.http.util.CharArrayBuffer;
import java.util.Locale;

@NotThreadSafe
public abstract class AuthSchemeBase
implements ContextAwareAuthScheme {
    private ChallengeState challengeState;

    public AuthSchemeBase(ChallengeState challengeState) {
        this.challengeState = challengeState;
    }

    public AuthSchemeBase() {
        this(null);
    }

    @Override
    public void processChallenge(Header header) throws MalformedChallengeException {
        int pos;
        CharArrayBuffer buffer;
        if (header == null) {
            throw new IllegalArgumentException("Header may not be null");
        }
        String authheader = header.getName();
        if (authheader.equalsIgnoreCase("WWW-Authenticate")) {
            this.challengeState = ChallengeState.TARGET;
        } else if (authheader.equalsIgnoreCase("Proxy-Authenticate")) {
            this.challengeState = ChallengeState.PROXY;
        } else {
            throw new MalformedChallengeException("Unexpected header name: " + authheader);
        }
        if (header instanceof FormattedHeader) {
            buffer = ((FormattedHeader)header).getBuffer();
            pos = ((FormattedHeader)header).getValuePos();
        } else {
            String s = header.getValue();
            if (s == null) {
                throw new MalformedChallengeException("Header value is null");
            }
            buffer = new CharArrayBuffer(s.length());
            buffer.append(s);
            pos = 0;
        }
        while (pos < buffer.length() && HTTP.isWhitespace(buffer.charAt(pos))) {
            ++pos;
        }
        int beginIndex = pos;
        while (pos < buffer.length() && !HTTP.isWhitespace(buffer.charAt(pos))) {
            ++pos;
        }
        int endIndex = pos;
        String s = buffer.substring(beginIndex, endIndex);
        if (!s.equalsIgnoreCase(this.getSchemeName())) {
            throw new MalformedChallengeException("Invalid scheme identifier: " + s);
        }
        this.parseChallenge(buffer, pos, buffer.length());
    }

    @Override
    public Header authenticate(Credentials credentials, HttpRequest request, HttpContext context) throws AuthenticationException {
        return this.authenticate(credentials, request);
    }

    protected abstract void parseChallenge(CharArrayBuffer var1, int var2, int var3) throws MalformedChallengeException;

    public boolean isProxy() {
        return this.challengeState != null && this.challengeState == ChallengeState.PROXY;
    }

    public ChallengeState getChallengeState() {
        return this.challengeState;
    }

    public String toString() {
        String name = this.getSchemeName();
        if (name != null) {
            return name.toUpperCase(Locale.US);
        }
        return super.toString();
    }
}

