/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.org.apache.http.impl.client;

import com.bes.mq.org.apache.http.annotation.Immutable;
import com.bes.mq.org.apache.http.auth.AuthScheme;
import com.bes.mq.org.apache.http.auth.AuthState;
import com.bes.mq.org.apache.http.auth.Credentials;
import com.bes.mq.org.apache.http.client.UserTokenHandler;
import com.bes.mq.org.apache.http.conn.HttpRoutedConnection;
import com.bes.mq.org.apache.http.protocol.HttpContext;
import java.security.Principal;
import javax.net.ssl.SSLSession;

@Immutable
public class DefaultUserTokenHandler
implements UserTokenHandler {
    @Override
    public Object getUserToken(HttpContext context) {
        SSLSession sslsession;
        HttpRoutedConnection conn;
        Principal userPrincipal = null;
        AuthState targetAuthState = (AuthState)context.getAttribute("http.auth.target-scope");
        if (targetAuthState != null && (userPrincipal = DefaultUserTokenHandler.getAuthPrincipal(targetAuthState)) == null) {
            AuthState proxyAuthState = (AuthState)context.getAttribute("http.auth.proxy-scope");
            userPrincipal = DefaultUserTokenHandler.getAuthPrincipal(proxyAuthState);
        }
        if (userPrincipal == null && (conn = (HttpRoutedConnection)context.getAttribute("http.connection")).isOpen() && (sslsession = conn.getSSLSession()) != null) {
            userPrincipal = sslsession.getLocalPrincipal();
        }
        return userPrincipal;
    }

    private static Principal getAuthPrincipal(AuthState authState) {
        Credentials creds;
        AuthScheme scheme = authState.getAuthScheme();
        if (scheme != null && scheme.isComplete() && scheme.isConnectionBased() && (creds = authState.getCredentials()) != null) {
            return creds.getUserPrincipal();
        }
        return null;
    }
}

