/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.org.apache.http.impl.entity;

import com.bes.mq.org.apache.http.Header;
import com.bes.mq.org.apache.http.HttpEntity;
import com.bes.mq.org.apache.http.HttpException;
import com.bes.mq.org.apache.http.HttpMessage;
import com.bes.mq.org.apache.http.annotation.Immutable;
import com.bes.mq.org.apache.http.entity.BasicHttpEntity;
import com.bes.mq.org.apache.http.entity.ContentLengthStrategy;
import com.bes.mq.org.apache.http.impl.io.ChunkedInputStream;
import com.bes.mq.org.apache.http.impl.io.ContentLengthInputStream;
import com.bes.mq.org.apache.http.impl.io.IdentityInputStream;
import com.bes.mq.org.apache.http.io.SessionInputBuffer;
import java.io.IOException;

@Immutable
public class EntityDeserializer {
    private final ContentLengthStrategy lenStrategy;

    public EntityDeserializer(ContentLengthStrategy lenStrategy) {
        if (lenStrategy == null) {
            throw new IllegalArgumentException("Content length strategy may not be null");
        }
        this.lenStrategy = lenStrategy;
    }

    protected BasicHttpEntity doDeserialize(SessionInputBuffer inbuffer, HttpMessage message) throws HttpException, IOException {
        Header contentEncodingHeader;
        BasicHttpEntity entity = new BasicHttpEntity();
        long len = this.lenStrategy.determineLength(message);
        if (len == -2L) {
            entity.setChunked(true);
            entity.setContentLength(-1L);
            entity.setContent(new ChunkedInputStream(inbuffer));
        } else if (len == -1L) {
            entity.setChunked(false);
            entity.setContentLength(-1L);
            entity.setContent(new IdentityInputStream(inbuffer));
        } else {
            entity.setChunked(false);
            entity.setContentLength(len);
            entity.setContent(new ContentLengthInputStream(inbuffer, len));
        }
        Header contentTypeHeader = message.getFirstHeader("Content-Type");
        if (contentTypeHeader != null) {
            entity.setContentType(contentTypeHeader);
        }
        if ((contentEncodingHeader = message.getFirstHeader("Content-Encoding")) != null) {
            entity.setContentEncoding(contentEncodingHeader);
        }
        return entity;
    }

    public HttpEntity deserialize(SessionInputBuffer inbuffer, HttpMessage message) throws HttpException, IOException {
        if (inbuffer == null) {
            throw new IllegalArgumentException("Session input buffer may not be null");
        }
        if (message == null) {
            throw new IllegalArgumentException("HTTP message may not be null");
        }
        return this.doDeserialize(inbuffer, message);
    }
}

