/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.org.apache.http.impl.entity;

import com.bes.mq.org.apache.http.HttpEntity;
import com.bes.mq.org.apache.http.HttpException;
import com.bes.mq.org.apache.http.HttpMessage;
import com.bes.mq.org.apache.http.annotation.Immutable;
import com.bes.mq.org.apache.http.entity.ContentLengthStrategy;
import com.bes.mq.org.apache.http.impl.io.ChunkedOutputStream;
import com.bes.mq.org.apache.http.impl.io.ContentLengthOutputStream;
import com.bes.mq.org.apache.http.impl.io.IdentityOutputStream;
import com.bes.mq.org.apache.http.io.SessionOutputBuffer;
import java.io.IOException;
import java.io.OutputStream;

@Immutable
public class EntitySerializer {
    private final ContentLengthStrategy lenStrategy;

    public EntitySerializer(ContentLengthStrategy lenStrategy) {
        if (lenStrategy == null) {
            throw new IllegalArgumentException("Content length strategy may not be null");
        }
        this.lenStrategy = lenStrategy;
    }

    protected OutputStream doSerialize(SessionOutputBuffer outbuffer, HttpMessage message) throws HttpException, IOException {
        long len = this.lenStrategy.determineLength(message);
        if (len == -2L) {
            return new ChunkedOutputStream(outbuffer);
        }
        if (len == -1L) {
            return new IdentityOutputStream(outbuffer);
        }
        return new ContentLengthOutputStream(outbuffer, len);
    }

    public void serialize(SessionOutputBuffer outbuffer, HttpMessage message, HttpEntity entity) throws HttpException, IOException {
        if (outbuffer == null) {
            throw new IllegalArgumentException("Session output buffer may not be null");
        }
        if (message == null) {
            throw new IllegalArgumentException("HTTP message may not be null");
        }
        if (entity == null) {
            throw new IllegalArgumentException("HTTP entity may not be null");
        }
        OutputStream outstream = this.doSerialize(outbuffer, message);
        entity.writeTo(outstream);
        outstream.close();
    }
}

