/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.org.apache.http.impl.io;

import com.bes.mq.org.apache.http.Header;
import com.bes.mq.org.apache.http.HeaderIterator;
import com.bes.mq.org.apache.http.HttpException;
import com.bes.mq.org.apache.http.HttpMessage;
import com.bes.mq.org.apache.http.annotation.NotThreadSafe;
import com.bes.mq.org.apache.http.io.HttpMessageWriter;
import com.bes.mq.org.apache.http.io.SessionOutputBuffer;
import com.bes.mq.org.apache.http.message.BasicLineFormatter;
import com.bes.mq.org.apache.http.message.LineFormatter;
import com.bes.mq.org.apache.http.params.HttpParams;
import com.bes.mq.org.apache.http.util.CharArrayBuffer;
import java.io.IOException;

@NotThreadSafe
public abstract class AbstractMessageWriter<T extends HttpMessage>
implements HttpMessageWriter<T> {
    protected final SessionOutputBuffer sessionBuffer;
    protected final CharArrayBuffer lineBuf;
    protected final LineFormatter lineFormatter;

    public AbstractMessageWriter(SessionOutputBuffer buffer, LineFormatter formatter, HttpParams params) {
        if (buffer == null) {
            throw new IllegalArgumentException("Session input buffer may not be null");
        }
        this.sessionBuffer = buffer;
        this.lineBuf = new CharArrayBuffer(128);
        this.lineFormatter = formatter != null ? formatter : BasicLineFormatter.DEFAULT;
    }

    protected abstract void writeHeadLine(T var1) throws IOException;

    @Override
    public void write(T message) throws IOException, HttpException {
        if (message == null) {
            throw new IllegalArgumentException("HTTP message may not be null");
        }
        this.writeHeadLine(message);
        HeaderIterator it = message.headerIterator();
        while (it.hasNext()) {
            Header header = it.nextHeader();
            this.sessionBuffer.writeLine(this.lineFormatter.formatHeader(this.lineBuf, header));
        }
        this.lineBuf.clear();
        this.sessionBuffer.writeLine(this.lineBuf);
    }
}

