/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.org.apache.http.impl.pool;

import com.bes.mq.org.apache.http.HttpClientConnection;
import com.bes.mq.org.apache.http.HttpHost;
import com.bes.mq.org.apache.http.annotation.ThreadSafe;
import com.bes.mq.org.apache.http.impl.pool.BasicConnFactory;
import com.bes.mq.org.apache.http.impl.pool.BasicPoolEntry;
import com.bes.mq.org.apache.http.params.HttpParams;
import com.bes.mq.org.apache.http.pool.AbstractConnPool;
import com.bes.mq.org.apache.http.pool.ConnFactory;
import java.util.concurrent.atomic.AtomicLong;

@ThreadSafe
public class BasicConnPool
extends AbstractConnPool<HttpHost, HttpClientConnection, BasicPoolEntry> {
    private static AtomicLong COUNTER = new AtomicLong();

    public BasicConnPool(ConnFactory<HttpHost, HttpClientConnection> connFactory) {
        super(connFactory, 2, 20);
    }

    public BasicConnPool(HttpParams params) {
        super(new BasicConnFactory(params), 2, 20);
    }

    @Override
    protected BasicPoolEntry createEntry(HttpHost host, HttpClientConnection conn) {
        return new BasicPoolEntry(Long.toString(COUNTER.getAndIncrement()), host, conn);
    }
}

