/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.org.apache.http.message;

import com.bes.mq.org.apache.http.Header;
import com.bes.mq.org.apache.http.HeaderElement;
import com.bes.mq.org.apache.http.ParseException;
import com.bes.mq.org.apache.http.annotation.Immutable;
import com.bes.mq.org.apache.http.message.BasicHeaderValueParser;
import com.bes.mq.org.apache.http.message.BasicLineFormatter;
import java.io.Serializable;

@Immutable
public class BasicHeader
implements Header,
Cloneable,
Serializable {
    private static final long serialVersionUID = -5427236326487562174L;
    private final String name;
    private final String value;

    public BasicHeader(String name, String value) {
        if (name == null) {
            throw new IllegalArgumentException("Name may not be null");
        }
        this.name = name;
        this.value = value;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return BasicLineFormatter.DEFAULT.formatHeader(null, this).toString();
    }

    @Override
    public HeaderElement[] getElements() throws ParseException {
        if (this.value != null) {
            return BasicHeaderValueParser.parseElements(this.value, null);
        }
        return new HeaderElement[0];
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

