/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.org.apache.http.protocol;

import com.bes.mq.org.apache.http.HttpEntity;
import com.bes.mq.org.apache.http.HttpEntityEnclosingRequest;
import com.bes.mq.org.apache.http.HttpException;
import com.bes.mq.org.apache.http.HttpRequest;
import com.bes.mq.org.apache.http.HttpRequestInterceptor;
import com.bes.mq.org.apache.http.HttpVersion;
import com.bes.mq.org.apache.http.ProtocolVersion;
import com.bes.mq.org.apache.http.annotation.Immutable;
import com.bes.mq.org.apache.http.params.HttpProtocolParams;
import com.bes.mq.org.apache.http.protocol.HttpContext;
import java.io.IOException;

@Immutable
public class RequestExpectContinue
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        HttpEntity entity;
        if (request == null) {
            throw new IllegalArgumentException("HTTP request may not be null");
        }
        if (request instanceof HttpEntityEnclosingRequest && (entity = ((HttpEntityEnclosingRequest)request).getEntity()) != null && entity.getContentLength() != 0L) {
            ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
            if (HttpProtocolParams.useExpectContinue(request.getParams()) && !ver.lessEquals(HttpVersion.HTTP_1_0)) {
                request.addHeader("Expect", "100-continue");
            }
        }
    }
}

