/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.org.xmlpull.v1.builder.impl;

import com.bes.mq.org.xmlpull.v1.builder.XmlAttribute;
import com.bes.mq.org.xmlpull.v1.builder.XmlElement;
import com.bes.mq.org.xmlpull.v1.builder.XmlNamespace;

public class XmlAttributeImpl
implements XmlAttribute {
    private XmlElement owner_;
    private String prefix_;
    private XmlNamespace namespace_;
    private String name_;
    private String value_;
    private String type_ = "CDATA";
    private boolean default_;

    @Override
    public Object clone() throws CloneNotSupportedException {
        XmlAttributeImpl cloned = (XmlAttributeImpl)super.clone();
        cloned.owner_ = null;
        cloned.prefix_ = this.prefix_;
        cloned.namespace_ = this.namespace_;
        cloned.name_ = this.name_;
        cloned.value_ = this.value_;
        cloned.default_ = this.default_;
        return cloned;
    }

    XmlAttributeImpl(XmlElement owner, String name, String value) {
        this.owner_ = owner;
        this.name_ = name;
        if (value == null) {
            throw new IllegalArgumentException("attribute value can not be null");
        }
        this.value_ = value;
    }

    XmlAttributeImpl(XmlElement owner, XmlNamespace namespace, String name, String value) {
        this(owner, name, value);
        this.namespace_ = namespace;
    }

    XmlAttributeImpl(XmlElement owner, String type, XmlNamespace namespace, String name, String value) {
        this(owner, namespace, name, value);
        this.type_ = type;
    }

    XmlAttributeImpl(XmlElement owner, String type, XmlNamespace namespace, String name, String value, boolean specified) {
        this(owner, namespace, name, value);
        if (type == null) {
            throw new IllegalArgumentException("attribute type can not be null");
        }
        this.type_ = type;
        this.default_ = !specified;
    }

    @Override
    public XmlElement getOwner() {
        return this.owner_;
    }

    @Override
    public XmlNamespace getNamespace() {
        return this.namespace_;
    }

    @Override
    public String getNamespaceName() {
        return this.namespace_ != null ? this.namespace_.getNamespaceName() : null;
    }

    @Override
    public String getName() {
        return this.name_;
    }

    @Override
    public String getValue() {
        return this.value_;
    }

    @Override
    public String getType() {
        return this.type_;
    }

    @Override
    public boolean isSpecified() {
        return !this.default_;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof XmlAttribute)) {
            return false;
        }
        XmlAttribute otherAttr = (XmlAttribute)other;
        return this.getNamespaceName().equals(otherAttr.getNamespaceName()) && this.getName().equals(otherAttr.getName()) && this.getValue().equals(otherAttr.getValue());
    }

    public String toString() {
        return "name=" + this.name_ + " value=" + this.value_;
    }
}

