/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.plugin;

import com.bes.mq.broker.Broker;
import com.bes.mq.broker.BrokerFilter;
import com.bes.mq.broker.BrokerService;
import com.bes.mq.broker.ConnectionContext;
import com.bes.mq.broker.ProducerBrokerExchange;
import com.bes.mq.broker.jmx.BrokerViewMBean;
import com.bes.mq.broker.jmx.SubscriptionViewMBean;
import com.bes.mq.broker.region.Destination;
import com.bes.mq.broker.region.DestinationStatistics;
import com.bes.mq.broker.region.RegionBroker;
import com.bes.mq.command.BESMQDestination;
import com.bes.mq.command.BESMQMapMessage;
import com.bes.mq.command.Message;
import com.bes.mq.command.MessageId;
import com.bes.mq.command.ProducerId;
import com.bes.mq.command.ProducerInfo;
import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;
import com.bes.mq.state.ProducerState;
import com.bes.mq.usage.SystemUsage;
import com.bes.mq.util.IdGenerator;
import com.bes.mq.util.LongSequenceGenerator;
import java.io.File;
import java.net.URI;
import java.util.Set;
import javax.jms.JMSException;
import javax.management.ObjectName;

public class StatisticsBroker
extends BrokerFilter {
    private static Logger LOG = LoggerFactory.getLogger(StatisticsBroker.class);
    static final String STATS_DESTINATION_PREFIX = "BESMQ.Statistics.Destination";
    static final String STATS_BROKER_PREFIX = "BESMQ.Statistics.Broker";
    static final String STATS_BROKER_RESET_HEADER = "BESMQ.Statistics.Broker.Reset";
    static final String STATS_SUBSCRIPTION_PREFIX = "BESMQ.Statistics.Subscription";
    private static final IdGenerator ID_GENERATOR = new IdGenerator();
    private final LongSequenceGenerator messageIdGenerator = new LongSequenceGenerator();
    protected final ProducerId notificationProducerId = new ProducerId();
    protected BrokerViewMBean brokerView;

    public StatisticsBroker(Broker next) {
        super(next);
        this.notificationProducerId.setConnectionId(ID_GENERATOR.generateId());
    }

    public void send(ProducerBrokerExchange producerExchange, Message messageSend) throws Exception {
        BESMQDestination msgDest = messageSend.getDestination();
        BESMQDestination replyTo = messageSend.getReplyTo();
        if (replyTo != null) {
            String physicalName = msgDest.getPhysicalName();
            boolean destStats = physicalName.regionMatches(true, 0, STATS_DESTINATION_PREFIX, 0, STATS_DESTINATION_PREFIX.length());
            boolean brokerStats = physicalName.regionMatches(true, 0, STATS_BROKER_PREFIX, 0, STATS_BROKER_PREFIX.length());
            boolean subStats = physicalName.regionMatches(true, 0, STATS_SUBSCRIPTION_PREFIX, 0, STATS_SUBSCRIPTION_PREFIX.length());
            BrokerService brokerService = this.getBrokerService();
            RegionBroker regionBroker = (RegionBroker)brokerService.getRegionBroker();
            if (destStats) {
                String queueryName = physicalName.substring(STATS_DESTINATION_PREFIX.length(), physicalName.length());
                BESMQDestination queryDest = BESMQDestination.createDestination(queueryName, msgDest.getDestinationType());
                Set<Destination> set = this.getDestinations(queryDest);
                for (Destination dest : set) {
                    DestinationStatistics stats = dest.getDestinationStatistics();
                    if (stats == null) continue;
                    BESMQMapMessage statsMessage = new BESMQMapMessage();
                    statsMessage.setString("destinationName", dest.getBESMQDestination().toString());
                    statsMessage.setLong("size", stats.getMessages().getCount());
                    statsMessage.setLong("enqueueCount", stats.getEnqueues().getCount());
                    statsMessage.setLong("dequeueCount", stats.getDequeues().getCount());
                    statsMessage.setLong("dispatchCount", stats.getDispatched().getCount());
                    statsMessage.setLong("expiredCount", stats.getExpired().getCount());
                    statsMessage.setLong("inflightCount", stats.getInflight().getCount());
                    statsMessage.setLong("messagesCached", stats.getMessagesCached().getCount());
                    statsMessage.setInt("memoryPercentUsage", dest.getMemoryUsage().getPercentUsage());
                    statsMessage.setLong("memoryUsage", dest.getMemoryUsage().getUsage());
                    statsMessage.setLong("memoryLimit", dest.getMemoryUsage().getLimit());
                    statsMessage.setDouble("averageEnqueueTime", stats.getProcessTime().getAverageTime());
                    statsMessage.setDouble("maxEnqueueTime", stats.getProcessTime().getMaxTime());
                    statsMessage.setDouble("minEnqueueTime", stats.getProcessTime().getMinTime());
                    statsMessage.setLong("consumerCount", stats.getConsumers().getCount());
                    statsMessage.setLong("producerCount", stats.getProducers().getCount());
                    statsMessage.setJMSCorrelationID(messageSend.getCorrelationId());
                    this.sendStats(producerExchange.getConnectionContext(), statsMessage, replyTo);
                }
            } else if (subStats) {
                this.sendSubStats(producerExchange.getConnectionContext(), this.getBrokerView().getQueueSubscribers(), replyTo);
                this.sendSubStats(producerExchange.getConnectionContext(), this.getBrokerView().getTopicSubscribers(), replyTo);
            } else if (brokerStats) {
                if (messageSend.getProperties().containsKey(STATS_BROKER_RESET_HEADER)) {
                    this.getBrokerView().resetStatistics();
                }
                BESMQMapMessage statsMessage = new BESMQMapMessage();
                SystemUsage systemUsage = brokerService.getSystemUsage();
                DestinationStatistics stats = regionBroker.getDestinationStatistics();
                statsMessage.setString("brokerName", regionBroker.getBrokerName());
                statsMessage.setString("brokerId", regionBroker.getBrokerId().toString());
                statsMessage.setLong("size", stats.getMessages().getCount());
                statsMessage.setLong("enqueueCount", stats.getEnqueues().getCount());
                statsMessage.setLong("dequeueCount", stats.getDequeues().getCount());
                statsMessage.setLong("dispatchCount", stats.getDispatched().getCount());
                statsMessage.setLong("expiredCount", stats.getExpired().getCount());
                statsMessage.setLong("inflightCount", stats.getInflight().getCount());
                statsMessage.setLong("messagesCached", stats.getMessagesCached().getCount());
                statsMessage.setInt("memoryPercentUsage", systemUsage.getMemoryUsage().getPercentUsage());
                statsMessage.setLong("memoryUsage", systemUsage.getMemoryUsage().getUsage());
                statsMessage.setLong("memoryLimit", systemUsage.getMemoryUsage().getLimit());
                statsMessage.setInt("storePercentUsage", systemUsage.getStoreUsage().getPercentUsage());
                statsMessage.setLong("storeUsage", systemUsage.getStoreUsage().getUsage());
                statsMessage.setLong("storeLimit", systemUsage.getStoreUsage().getLimit());
                statsMessage.setInt("tempPercentUsage", systemUsage.getTempUsage().getPercentUsage());
                statsMessage.setLong("tempUsage", systemUsage.getTempUsage().getUsage());
                statsMessage.setLong("tempLimit", systemUsage.getTempUsage().getLimit());
                statsMessage.setDouble("averageEnqueueTime", stats.getProcessTime().getAverageTime());
                statsMessage.setDouble("maxEnqueueTime", stats.getProcessTime().getMaxTime());
                statsMessage.setDouble("minEnqueueTime", stats.getProcessTime().getMinTime());
                statsMessage.setLong("consumerCount", stats.getConsumers().getCount());
                statsMessage.setLong("producerCount", stats.getProducers().getCount());
                String answer = brokerService.getTransportConnectorURIsAsMap().get("tcp");
                answer = answer != null ? answer : "";
                statsMessage.setString("besmp", answer);
                answer = brokerService.getTransportConnectorURIsAsMap().get("stomp");
                answer = answer != null ? answer : "";
                statsMessage.setString("stomp", answer);
                answer = brokerService.getTransportConnectorURIsAsMap().get("ssl");
                answer = answer != null ? answer : "";
                statsMessage.setString("ssl", answer);
                answer = brokerService.getTransportConnectorURIsAsMap().get("stomp+ssl");
                answer = answer != null ? answer : "";
                statsMessage.setString("stomp+ssl", answer);
                URI uri = brokerService.getVmConnectorURI();
                answer = uri != null ? uri.toString() : "";
                statsMessage.setString("vm", answer);
                File file = brokerService.getDataDirectoryFile();
                answer = file != null ? file.getCanonicalPath() : "";
                statsMessage.setString("dataDirectory", answer);
                statsMessage.setJMSCorrelationID(messageSend.getCorrelationId());
                this.sendStats(producerExchange.getConnectionContext(), statsMessage, replyTo);
            } else {
                super.send(producerExchange, messageSend);
            }
        } else {
            super.send(producerExchange, messageSend);
        }
    }

    BrokerViewMBean getBrokerView() throws Exception {
        if (this.brokerView == null) {
            ObjectName brokerName = this.getBrokerService().getBrokerObjectName();
            this.brokerView = (BrokerViewMBean)this.getBrokerService().getManagementContext().newProxyInstance(brokerName, BrokerViewMBean.class, true);
        }
        return this.brokerView;
    }

    public void start() throws Exception {
        super.start();
        LOG.info("Starting StatisticsBroker");
    }

    public void stop() throws Exception {
        super.stop();
    }

    protected void sendSubStats(ConnectionContext context, ObjectName[] subscribers, BESMQDestination replyTo) throws Exception {
        for (int i = 0; i < subscribers.length; ++i) {
            ObjectName name = subscribers[i];
            SubscriptionViewMBean subscriber = (SubscriptionViewMBean)this.getBrokerService().getManagementContext().newProxyInstance(name, SubscriptionViewMBean.class, true);
            BESMQMapMessage statsMessage = this.prepareSubscriptionMessage(subscriber);
            this.sendStats(context, statsMessage, replyTo);
        }
    }

    protected BESMQMapMessage prepareSubscriptionMessage(SubscriptionViewMBean subscriber) throws JMSException {
        BESMQMapMessage statsMessage = new BESMQMapMessage();
        statsMessage.setString("destinationName", subscriber.getDestinationName());
        statsMessage.setString("clientId", subscriber.getClientId());
        statsMessage.setString("connectionId", subscriber.getConnectionId());
        statsMessage.setLong("sessionId", subscriber.getSessionId());
        statsMessage.setString("selector", subscriber.getSelector());
        statsMessage.setLong("enqueueCounter", subscriber.getEnqueueCounter());
        statsMessage.setLong("dequeueCounter", subscriber.getDequeueCounter());
        statsMessage.setLong("dispatchedCounter", subscriber.getDispatchedCounter());
        statsMessage.setLong("dispatchedQueueSize", subscriber.getDispatchedQueueSize());
        statsMessage.setInt("prefetchSize", subscriber.getPrefetchSize());
        statsMessage.setInt("maximumPendingMessageLimit", subscriber.getMaximumPendingMessageLimit());
        statsMessage.setBoolean("exclusive", subscriber.isExclusive());
        statsMessage.setBoolean("retroactive", subscriber.isRetroactive());
        statsMessage.setBoolean("slowConsumer", subscriber.isSlowConsumer());
        return statsMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendStats(ConnectionContext context, BESMQMapMessage msg, BESMQDestination replyTo) throws Exception {
        msg.setPersistent(false);
        msg.setType("Notification");
        msg.setMessageId(new MessageId(this.notificationProducerId, this.messageIdGenerator.getNextSequenceId()));
        msg.setDestination(replyTo);
        msg.setResponseRequired(false);
        msg.setProducerId(this.notificationProducerId);
        boolean originalFlowControl = context.isProducerFlowControl();
        ProducerBrokerExchange producerExchange = new ProducerBrokerExchange();
        producerExchange.setConnectionContext(context);
        producerExchange.setMutable(true);
        producerExchange.setProducerState(new ProducerState(new ProducerInfo()));
        try {
            context.setProducerFlowControl(false);
            this.next.send(producerExchange, msg);
        }
        finally {
            context.setProducerFlowControl(originalFlowControl);
        }
    }
}

