/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.plugin;

import com.bes.mq.broker.Broker;
import com.bes.mq.broker.BrokerFilter;
import com.bes.mq.broker.ConnectionContext;
import com.bes.mq.broker.region.Subscription;
import com.bes.mq.command.ConsumerInfo;
import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.concurrent.ConcurrentHashMap;

public class SubQueueSelectorCacheBroker
extends BrokerFilter
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(SubQueueSelectorCacheBroker.class);
    private ConcurrentHashMap<String, String> subSelectorCache = new ConcurrentHashMap();
    private final File persistFile;
    private boolean running = true;
    private Thread persistThread;
    private static final long MAX_PERSIST_INTERVAL = 600000L;
    private static final String SELECTOR_CACHE_PERSIST_THREAD_NAME = "SelectorCachePersistThread";

    public SubQueueSelectorCacheBroker(Broker next, File persistFile) {
        super(next);
        this.persistFile = persistFile;
        LOG.info("Using persisted selector cache from[" + persistFile + "]");
        this.readCache();
        this.persistThread = new Thread((Runnable)this, SELECTOR_CACHE_PERSIST_THREAD_NAME);
        this.persistThread.start();
    }

    public void stop() throws Exception {
        this.running = false;
        if (this.persistThread != null) {
            this.persistThread.interrupt();
            this.persistThread.join();
        }
    }

    public Subscription addConsumer(ConnectionContext context, ConsumerInfo info) throws Exception {
        LOG.debug("Caching consumer selector [" + info.getSelector() + "] on a " + info.getDestination().getQualifiedName());
        if (info.getSelector() != null) {
            this.subSelectorCache.put(info.getDestination().getQualifiedName(), info.getSelector());
        }
        return super.addConsumer(context, info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readCache() {
        if (this.persistFile != null && this.persistFile.exists()) {
            try {
                FileInputStream fis = new FileInputStream(this.persistFile);
                try {
                    ObjectInputStream in = new ObjectInputStream(fis);
                    try {
                        this.subSelectorCache = (ConcurrentHashMap)in.readObject();
                    }
                    catch (ClassNotFoundException ex) {
                        LOG.error("Invalid selector cache data found. Please remove file.", ex);
                    }
                    finally {
                        in.close();
                    }
                }
                finally {
                    fis.close();
                }
            }
            catch (IOException ex) {
                LOG.error("Unable to read persisted selector cache...it will be ignored!", ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void persistCache() {
        LOG.debug("Persisting selector cache....");
        try {
            FileOutputStream fos = new FileOutputStream(this.persistFile);
            try {
                ObjectOutputStream out = new ObjectOutputStream(fos);
                try {
                    out.writeObject(this.subSelectorCache);
                }
                finally {
                    out.flush();
                    out.close();
                }
            }
            catch (IOException ex) {
                LOG.error("Unable to persist selector cache", ex);
            }
            finally {
                fos.close();
            }
        }
        catch (IOException ex) {
            LOG.error("Unable to access file[" + this.persistFile + "]", ex);
        }
    }

    public String getSelector(String destination) {
        return this.subSelectorCache.get(destination);
    }

    public void run() {
        while (this.running) {
            try {
                Thread.sleep(600000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.persistCache();
        }
    }
}

