/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.pool;

import com.bes.mq.BESMQConnection;
import com.bes.mq.BESMQConnectionFactory;
import com.bes.mq.BESMQSession;
import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;
import com.bes.mq.util.IOExceptionSupport;
import java.io.IOException;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.apache.geronimo.transaction.manager.NamedXAResource;
import org.apache.geronimo.transaction.manager.NamedXAResourceFactory;
import org.apache.geronimo.transaction.manager.RecoverableTransactionManager;
import org.apache.geronimo.transaction.manager.WrapperNamedXAResource;

public class BESMQResourceManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(BESMQResourceManager.class);
    private String resourceName;
    private TransactionManager transactionManager;
    private ConnectionFactory connectionFactory;

    public void recoverResource() {
        try {
            if (!Recovery.recover(this)) {
                LOGGER.info("Resource manager is unrecoverable");
            }
        }
        catch (NoClassDefFoundError e) {
            LOGGER.info("Resource manager is unrecoverable due to missing classes: " + e);
        }
        catch (Throwable e) {
            LOGGER.warn("Error while recovering resource manager", e);
        }
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setTransactionManager(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public static class ConnectionAndWrapperNamedXAResource
    extends WrapperNamedXAResource {
        final BESMQConnection connection;

        public ConnectionAndWrapperNamedXAResource(XAResource xaResource, String name, BESMQConnection connection) {
            super(xaResource, name);
            this.connection = connection;
        }
    }

    public static class Recovery {
        public static boolean isRecoverable(BESMQResourceManager rm) {
            return rm.getConnectionFactory() instanceof BESMQConnectionFactory && rm.getTransactionManager() instanceof RecoverableTransactionManager && rm.getResourceName() != null && !"".equals(rm.getResourceName());
        }

        public static boolean recover(final BESMQResourceManager rm) throws IOException {
            if (Recovery.isRecoverable(rm)) {
                try {
                    final BESMQConnectionFactory connFactory = (BESMQConnectionFactory)rm.getConnectionFactory();
                    BESMQConnection activeConn = (BESMQConnection)connFactory.createConnection();
                    BESMQSession session = (BESMQSession)activeConn.createSession(true, 0);
                    WrapperNamedXAResource namedXaResource = new WrapperNamedXAResource((XAResource)session.getTransactionContext(), rm.getResourceName());
                    RecoverableTransactionManager rtxManager = (RecoverableTransactionManager)rm.getTransactionManager();
                    rtxManager.registerNamedXAResourceFactory(new NamedXAResourceFactory(){

                        public String getName() {
                            return rm.getResourceName();
                        }

                        public NamedXAResource getNamedXAResource() throws SystemException {
                            try {
                                BESMQConnection activeConn = (BESMQConnection)connFactory.createConnection();
                                BESMQSession session = (BESMQSession)activeConn.createSession(true, 0);
                                activeConn.start();
                                LOGGER.debug("New NamedXAResource's connection: " + activeConn);
                                return new ConnectionAndWrapperNamedXAResource(session.getTransactionContext(), this.getName(), activeConn);
                            }
                            catch (Exception e) {
                                SystemException se = new SystemException("Failed to create ConnectionAndWrapperNamedXAResource, " + e.getLocalizedMessage());
                                se.initCause(e);
                                LOGGER.error(se.getLocalizedMessage(), se);
                                throw se;
                            }
                        }

                        public void returnNamedXAResource(NamedXAResource namedXaResource) {
                            if (namedXaResource instanceof ConnectionAndWrapperNamedXAResource) {
                                try {
                                    LOGGER.debug("Closing returned NamedXAResource's connection: " + ((ConnectionAndWrapperNamedXAResource)namedXaResource).connection);
                                    ((ConnectionAndWrapperNamedXAResource)namedXaResource).connection.close();
                                }
                                catch (Exception ignored) {
                                    LOGGER.debug("Failed to close returned NamedXAResource: " + namedXaResource, ignored);
                                }
                            }
                        }
                    });
                    return true;
                }
                catch (JMSException e) {
                    throw IOExceptionSupport.create(e);
                }
            }
            return false;
        }
    }
}

