/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.pool;

import com.bes.mq.BESMQConnectionFactory;
import com.bes.mq.jndi.JNDIReferenceFactory;
import com.bes.mq.jndi.JNDIResource;
import com.bes.mq.jndi.JNDIStorableInterface;
import com.bes.mq.pool.PooledConnectionFactory;
import java.util.Properties;
import javax.naming.NamingException;
import javax.naming.Reference;

public class BMQJNDIPooledConnectionFactory
extends PooledConnectionFactory
implements JNDIStorableInterface,
JNDIResource {
    private Properties properties;
    private String jndiName;

    public BMQJNDIPooledConnectionFactory() {
    }

    public BMQJNDIPooledConnectionFactory(String brokerURL) {
        super(brokerURL);
    }

    public BMQJNDIPooledConnectionFactory(BESMQConnectionFactory connectionFactory) {
        super(connectionFactory);
    }

    @Override
    public synchronized void setProperties(Properties props) {
        this.properties = props;
        this.buildFromProperties(props);
    }

    @Override
    public synchronized Properties getProperties() {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        this.populateProperties(this.properties);
        return this.properties;
    }

    @Override
    public Reference getReference() throws NamingException {
        return JNDIReferenceFactory.createReference(this.getClass().getName(), this);
    }

    public void buildFromProperties(Properties properties) {
        if (properties == null) {
            properties = new Properties();
        }
        ((BESMQConnectionFactory)this.getConnectionFactory()).buildFromProperties(properties);
        String temp = properties.getProperty("maximumActive");
        if (temp != null && temp.length() > 0) {
            this.setMaxSessionsPerConnection(Integer.parseInt(temp));
        }
        if ((temp = properties.getProperty("maxSessionsPerConnection")) != null && temp.length() > 0) {
            this.setMaxSessionsPerConnection(Integer.parseInt(temp));
        }
        if ((temp = properties.getProperty("maxConnections")) != null && temp.length() > 0) {
            this.setMaxConnections(Integer.parseInt(temp));
        }
        if ((temp = properties.getProperty("blockClient")) != null && temp.length() > 0) {
            this.setBlockClient(Boolean.parseBoolean(temp));
        }
        if ((temp = properties.getProperty("idleTimeout")) != null && temp.length() > 0) {
            this.setIdleTimeout(Integer.parseInt(temp));
        }
        if ((temp = properties.getProperty("leakTimeout")) != null && temp.length() > 0) {
            this.setLeakTimeout(Integer.parseInt(temp));
        }
        if ((temp = properties.getProperty("checkPeriod")) != null && temp.length() > 0) {
            this.setCheckPeriod(Long.parseLong(temp));
        }
        if ((temp = properties.getProperty("jndiName")) != null && temp.length() > 0) {
            this.setJndiName(temp);
        }
    }

    public void populateProperties(Properties props) {
        ((BESMQConnectionFactory)this.getConnectionFactory()).populateProperties(props);
        props.setProperty("maximumActive", Integer.toString(this.getMaxSessionsPerConnection()));
        props.setProperty("maxSessionsPerConnection", Integer.toString(this.getMaxSessionsPerConnection()));
        props.setProperty("maxConnections", Integer.toString(this.getMaxConnections()));
        props.setProperty("blockClient", Boolean.toString(this.isBlockClient()));
        props.setProperty("idleTimeout", Integer.toString(this.getIdleTimeout()));
        props.setProperty("leakTimeout", Long.toString(this.getLeakTimeout()));
        props.setProperty("checkPeriod", Long.toString(this.getCheckPeriod()));
        if (this.jndiName != null && this.jndiName.length() > 0) {
            props.setProperty("jndiName", this.jndiName);
        }
    }

    @Override
    public String getJndiName() {
        return this.jndiName;
    }

    @Override
    public void setJndiName(String jndiName) {
        this.jndiName = jndiName;
    }
}

