/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.pool;

import com.bes.mq.BESMQConnection;
import com.bes.mq.BESMQSession;
import com.bes.mq.org.apache.commons.pool.KeyedPoolableObjectFactory;
import com.bes.mq.org.apache.commons.pool.impl.GenericKeyedObjectPool;
import com.bes.mq.pool.PooledSession;
import com.bes.mq.pool.SessionKey;
import com.bes.mq.transport.TransportListener;
import com.bes.mq.util.JMSExceptionSupport;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.JMSException;
import javax.jms.Session;

public class ConnectionPool {
    private BESMQConnection connection;
    private int referenceCount;
    private long lastUsed;
    private long firstUsed;
    private boolean hasFailed;
    private boolean hasExpired;
    private int idleTimeout;
    private long expiryTimeout;
    private final AtomicBoolean started;
    private final GenericKeyedObjectPool<SessionKey, PooledSession> sessionPool;
    private final List<PooledSession> loanedSessions;

    public ConnectionPool(BESMQConnection connection) {
        this.firstUsed = this.lastUsed = System.currentTimeMillis();
        this.idleTimeout = 300000;
        this.expiryTimeout = 0L;
        this.started = new AtomicBoolean(false);
        this.loanedSessions = new CopyOnWriteArrayList<PooledSession>();
        this.connection = connection;
        connection.addTransportListener(new TransportListener(){

            @Override
            public void onCommand(Object command) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onException(IOException error) {
                ConnectionPool connectionPool = ConnectionPool.this;
                synchronized (connectionPool) {
                    ConnectionPool.this.hasFailed = true;
                }
            }

            @Override
            public void transportInterupted() {
            }

            @Override
            public void transportResumed() {
            }
        });
        if (connection.isTransportFailed()) {
            this.hasFailed = true;
        }
        this.sessionPool = new GenericKeyedObjectPool<SessionKey, PooledSession>(new KeyedPoolableObjectFactory<SessionKey, PooledSession>(){

            @Override
            public void activateObject(SessionKey key, PooledSession session) throws Exception {
                ConnectionPool.this.loanedSessions.add(session);
            }

            @Override
            public void destroyObject(SessionKey key, PooledSession session) throws Exception {
                ConnectionPool.this.loanedSessions.remove(session);
                session.getInternalSession().close();
            }

            @Override
            public PooledSession makeObject(SessionKey key) throws Exception {
                BESMQSession session = (BESMQSession)ConnectionPool.this.connection.createSession(key.isTransacted(), key.getAckMode());
                return new PooledSession(key, session, ConnectionPool.this.sessionPool);
            }

            @Override
            public void passivateObject(SessionKey key, PooledSession session) throws Exception {
                ConnectionPool.this.loanedSessions.remove(session);
            }

            @Override
            public boolean validateObject(SessionKey key, PooledSession session) {
                return true;
            }
        });
    }

    public void start() throws JMSException {
        if (this.started.compareAndSet(false, true)) {
            try {
                this.connection.start();
            }
            catch (JMSException e) {
                this.started.set(false);
                throw e;
            }
        }
    }

    public synchronized BESMQConnection getConnection() {
        return this.connection;
    }

    public Session createSession(boolean transacted, int ackMode) throws JMSException {
        PooledSession session;
        SessionKey key = new SessionKey(transacted, ackMode);
        try {
            session = this.sessionPool.borrowObject(key);
        }
        catch (Exception e) {
            throw JMSExceptionSupport.create(e);
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() {
        if (this.connection != null) {
            try {
                this.sessionPool.close();
            }
            catch (Exception e) {
                try {
                    this.connection.close();
                }
                catch (Exception exception) {
                }
                finally {
                    this.connection = null;
                }
            }
            finally {
                try {
                    this.connection.close();
                }
                catch (Exception e) {
                }
                finally {
                    this.connection = null;
                }
            }
        }
    }

    public synchronized void incrementReferenceCount() {
        ++this.referenceCount;
        this.lastUsed = System.currentTimeMillis();
    }

    public synchronized void decrementReferenceCount() {
        --this.referenceCount;
        this.lastUsed = System.currentTimeMillis();
        if (this.referenceCount == 0) {
            for (PooledSession session : this.loanedSessions) {
                try {
                    session.close();
                }
                catch (Exception exception) {}
            }
            this.loanedSessions.clear();
            if (this.getConnection() != null) {
                this.getConnection().cleanUpTempDestinations();
            }
            this.expiredCheck();
        }
    }

    public synchronized boolean expiredCheck() {
        boolean expired = false;
        if (this.connection == null) {
            return true;
        }
        if ((this.hasExpired || this.hasFailed) && this.referenceCount == 0) {
            this.close();
            expired = true;
        }
        if (this.expiryTimeout > 0L && System.currentTimeMillis() > this.firstUsed + this.expiryTimeout) {
            this.hasExpired = true;
            if (this.referenceCount == 0) {
                this.close();
                expired = true;
            }
        }
        if (this.referenceCount == 0 && this.idleTimeout > 0 && System.currentTimeMillis() > this.lastUsed + (long)this.idleTimeout) {
            this.hasExpired = true;
            this.close();
            expired = true;
        }
        return expired;
    }

    public int getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(int idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    public void setExpiryTimeout(long expiryTimeout) {
        this.expiryTimeout = expiryTimeout;
    }

    public long getExpiryTimeout() {
        return this.expiryTimeout;
    }

    public int getMaxSessionsPerConnection() {
        return this.sessionPool.getMaxActive();
    }

    public void setMaxSessionsPerConnection(int maxSessionsPerConnection) {
        this.sessionPool.setMaxActive(maxSessionsPerConnection);
    }

    public int getNumSessions() {
        return this.sessionPool.getNumIdle() + this.sessionPool.getNumActive();
    }

    public int getNumIdleSessions() {
        return this.sessionPool.getNumIdle();
    }

    public int getNumActiveSessions() {
        return this.sessionPool.getNumActive();
    }

    public void setBlockClient(boolean block) {
        this.sessionPool.setWhenExhaustedAction(block ? (byte)1 : 0);
    }

    public boolean isBlockClient() {
        return this.sessionPool.getWhenExhaustedAction() == 1;
    }

    public String toString() {
        return "ConnectionPool[" + this.connection + "]";
    }
}

