/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.pool;

import com.bes.mq.BESMQConnection;
import com.bes.mq.org.apache.commons.pool.ObjectPoolFactory;
import com.bes.mq.pool.PooledSession;
import com.bes.mq.pool.XaConnectionPool;
import com.bes.mq.ra.LocalAndXATransaction;
import javax.jms.JMSException;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.apache.geronimo.transaction.manager.WrapperNamedXAResource;

public class JcaConnectionPool
extends XaConnectionPool {
    private String name;

    public JcaConnectionPool(BESMQConnection connection, TransactionManager transactionManager, String name) {
        super(connection, transactionManager);
        this.name = name;
    }

    public JcaConnectionPool(BESMQConnection connection, ObjectPoolFactory poolFactory, TransactionManager transactionManager, String name) {
        this(connection, transactionManager, name);
    }

    @Override
    protected XAResource createXaResource(PooledSession session) throws JMSException {
        LocalAndXATransaction xares = new LocalAndXATransaction(session.getInternalSession().getTransactionContext());
        if (this.name != null) {
            xares = new WrapperNamedXAResource((XAResource)xares, this.name);
        }
        return xares;
    }
}

