/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.pool;

import com.bes.mq.AlreadyClosedException;
import com.bes.mq.BESMQConnection;
import com.bes.mq.BESMQSession;
import com.bes.mq.EnhancedConnection;
import com.bes.mq.notification.DestinationSource;
import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;
import com.bes.mq.pool.ConnectionPool;
import com.bes.mq.pool.PooledSession;
import com.bes.mq.pool.PooledSessionEventListener;
import com.bes.mq.pool.SessionKey;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.jms.ConnectionConsumer;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueSession;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;

public class PooledConnection
implements TopicConnection,
QueueConnection,
EnhancedConnection,
PooledSessionEventListener {
    private static final transient Logger LOG = LoggerFactory.getLogger(PooledConnection.class);
    private ConnectionPool pool;
    private volatile boolean stopped;
    private final List<TemporaryQueue> connTempQueues = new CopyOnWriteArrayList<TemporaryQueue>();
    private final List<TemporaryTopic> connTempTopics = new CopyOnWriteArrayList<TemporaryTopic>();

    public PooledConnection(ConnectionPool pool) {
        this.pool = pool;
    }

    public PooledConnection newInstance() {
        return new PooledConnection(this.pool);
    }

    @Override
    public void close() throws JMSException {
        this.cleanupConnectionTemporaryDestinations();
        if (this.pool != null) {
            this.pool.decrementReferenceCount();
            this.pool = null;
        }
    }

    @Override
    public void start() throws JMSException {
        this.assertNotClosed();
        this.pool.start();
    }

    @Override
    public void stop() throws JMSException {
        this.stopped = true;
    }

    @Override
    public ConnectionConsumer createConnectionConsumer(Destination destination, String selector, ServerSessionPool serverSessionPool, int maxMessages) throws JMSException {
        return this.getConnection().createConnectionConsumer(destination, selector, serverSessionPool, maxMessages);
    }

    @Override
    public ConnectionConsumer createConnectionConsumer(Topic topic, String s, ServerSessionPool serverSessionPool, int maxMessages) throws JMSException {
        return this.getConnection().createConnectionConsumer(topic, s, serverSessionPool, maxMessages);
    }

    @Override
    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String selector, String s1, ServerSessionPool serverSessionPool, int i) throws JMSException {
        return this.getConnection().createDurableConnectionConsumer(topic, selector, s1, serverSessionPool, i);
    }

    @Override
    public String getClientID() throws JMSException {
        return this.getConnection().getClientID();
    }

    @Override
    public ExceptionListener getExceptionListener() throws JMSException {
        return this.getConnection().getExceptionListener();
    }

    @Override
    public ConnectionMetaData getMetaData() throws JMSException {
        return this.getConnection().getMetaData();
    }

    @Override
    public void setExceptionListener(ExceptionListener exceptionListener) throws JMSException {
        this.getConnection().setExceptionListener(exceptionListener);
    }

    @Override
    public void setClientID(String clientID) throws JMSException {
        if (this.getConnection().getClientID() == null || !this.getClientID().equals(clientID)) {
            this.getConnection().setClientID(clientID);
        }
    }

    @Override
    public ConnectionConsumer createConnectionConsumer(Queue queue, String selector, ServerSessionPool serverSessionPool, int maxMessages) throws JMSException {
        return this.getConnection().createConnectionConsumer(queue, selector, serverSessionPool, maxMessages);
    }

    @Override
    public QueueSession createQueueSession(boolean transacted, int ackMode) throws JMSException {
        return (QueueSession)this.createSession(transacted, ackMode);
    }

    @Override
    public TopicSession createTopicSession(boolean transacted, int ackMode) throws JMSException {
        return (TopicSession)this.createSession(transacted, ackMode);
    }

    @Override
    public Session createSession(boolean transacted, int ackMode) throws JMSException {
        PooledSession result = (PooledSession)this.pool.createSession(transacted, ackMode);
        result.addTempDestEventListener(this);
        return result;
    }

    @Override
    public DestinationSource getDestinationSource() throws JMSException {
        return this.getConnection().getDestinationSource();
    }

    @Override
    public void onTemporaryQueueCreate(TemporaryQueue tempQueue) {
        this.connTempQueues.add(tempQueue);
    }

    @Override
    public void onTemporaryTopicCreate(TemporaryTopic tempTopic) {
        this.connTempTopics.add(tempTopic);
    }

    public BESMQConnection getConnection() throws JMSException {
        this.assertNotClosed();
        return this.pool.getConnection();
    }

    protected void assertNotClosed() throws AlreadyClosedException {
        if (this.stopped || this.pool == null) {
            throw new AlreadyClosedException();
        }
    }

    protected BESMQSession createSession(SessionKey key) throws JMSException {
        return (BESMQSession)this.getConnection().createSession(key.isTransacted(), key.getAckMode());
    }

    public String toString() {
        return "PooledConnection { " + this.pool + " }";
    }

    protected void cleanupConnectionTemporaryDestinations() {
        for (TemporaryQueue tempQueue : this.connTempQueues) {
            try {
                tempQueue.delete();
            }
            catch (JMSException ex) {
                LOG.info("Failed to delete Temporary Queue \"" + tempQueue.toString() + "\" on closing pooled connection: " + ex.getMessage());
            }
        }
        this.connTempQueues.clear();
        for (TemporaryTopic tempTopic : this.connTempTopics) {
            try {
                tempTopic.delete();
            }
            catch (JMSException ex) {
                LOG.info("Failed to delete Temporary Topic \"" + tempTopic.toString() + "\" on closing pooled connection: " + ex.getMessage());
            }
        }
        this.connTempTopics.clear();
    }

    public int getNumSessions() {
        return this.pool.getNumSessions();
    }

    public int getNumActiveSessions() {
        return this.pool.getNumActiveSessions();
    }

    public int getNumtIdleSessions() {
        return this.pool.getNumIdleSessions();
    }
}

