/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.pool;

import com.bes.mq.BESMQConnection;
import com.bes.mq.BESMQConnectionFactory;
import com.bes.mq.Service;
import com.bes.mq.org.apache.commons.pool.KeyedObjectPool;
import com.bes.mq.org.apache.commons.pool.KeyedPoolableObjectFactory;
import com.bes.mq.org.apache.commons.pool.ObjectPoolFactory;
import com.bes.mq.org.apache.commons.pool.impl.GenericKeyedObjectPool;
import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;
import com.bes.mq.pool.ConnectionKey;
import com.bes.mq.pool.ConnectionPool;
import com.bes.mq.pool.PooledConnection;
import com.bes.mq.util.JMSExceptionSupport;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;

public class PooledConnectionFactory
implements ConnectionFactory,
Service {
    private static final transient Logger LOG = LoggerFactory.getLogger(PooledConnectionFactory.class);
    private final AtomicBoolean stopped = new AtomicBoolean(false);
    private final GenericKeyedObjectPool<ConnectionKey, ConnectionPool> connectionsPool;
    private ConnectionFactory connectionFactory;
    private int maxSessionsPerConnection = 10;
    private int idleTimeout = 300000;
    private boolean blockClient = true;

    public PooledConnectionFactory() {
        this(new BESMQConnectionFactory());
    }

    public PooledConnectionFactory(String brokerURL) {
        this(new BESMQConnectionFactory(brokerURL));
    }

    public PooledConnectionFactory(BESMQConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
        this.connectionsPool = new GenericKeyedObjectPool<ConnectionKey, ConnectionPool>(new KeyedPoolableObjectFactory<ConnectionKey, ConnectionPool>(){

            @Override
            public void activateObject(ConnectionKey key, ConnectionPool connection) throws Exception {
            }

            @Override
            public void destroyObject(ConnectionKey key, ConnectionPool connection) throws Exception {
                try {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Destroying connection: {}", connection);
                    }
                    connection.close();
                }
                catch (Exception e) {
                    LOG.warn("Failed to close connection: " + connection + ". This exception will be ignored.", e);
                }
            }

            @Override
            public ConnectionPool makeObject(ConnectionKey key) throws Exception {
                BESMQConnection delegate = PooledConnectionFactory.this.createConnection(key);
                ConnectionPool connection = new ConnectionPool(delegate);
                connection.setIdleTimeout(PooledConnectionFactory.this.getIdleTimeout());
                connection.setMaxSessionsPerConnection(PooledConnectionFactory.this.getMaxSessionsPerConnection());
                connection.setBlockClient(PooledConnectionFactory.this.isBlockClient());
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Created new connection: {}", connection);
                }
                return connection;
            }

            @Override
            public void passivateObject(ConnectionKey key, ConnectionPool connection) throws Exception {
            }

            @Override
            public boolean validateObject(ConnectionKey key, ConnectionPool connection) {
                if (connection != null && connection.expiredCheck()) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Connection has expired: {} and will be destroyed", connection);
                    }
                    return false;
                }
                return true;
            }
        });
        this.connectionsPool.setMaxIdle(1);
        this.connectionsPool.setTestOnBorrow(true);
        this.connectionsPool.setTestWhileIdle(true);
        this.connectionsPool.setTimeBetweenEvictionRunsMillis(3000000L);
        this.connectionsPool.setNumTestsPerEvictionRun(this.getMaxConnections());
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    @Override
    public Connection createConnection() throws JMSException {
        return this.createConnection(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Connection createConnection(String userName, String password) throws JMSException {
        if (this.stopped.get()) {
            LOG.debug("PooledConnectionFactory is stopped, skip creating new connection.");
            return null;
        }
        ConnectionPool connection = null;
        ConnectionKey key = new ConnectionKey(userName, password);
        if (this.connectionsPool.getNumIdle((Object)key) < this.getMaxConnections()) {
            try {
                this.connectionsPool.setLifo(true);
                this.connectionsPool.addObject(key);
            }
            catch (Exception e) {
                throw JMSExceptionSupport.create("Error while attempting to add new Connection to the pool", e);
            }
        } else {
            this.connectionsPool.setLifo(false);
        }
        try {
            while (connection == null) {
                ConnectionPool e = connection = this.connectionsPool.borrowObject(key);
                synchronized (e) {
                    if (connection.getConnection() != null && connection.getNumActiveSessions() < connection.getMaxSessionsPerConnection()) {
                        connection.incrementReferenceCount();
                        break;
                    }
                }
                this.connectionsPool.returnObject(key, connection);
                connection = null;
            }
        }
        catch (Exception e) {
            throw JMSExceptionSupport.create("Error while attempting to retrieve a connection from the pool", e);
        }
        try {
            this.connectionsPool.returnObject(key, connection);
        }
        catch (Exception e) {
            throw JMSExceptionSupport.create("Error when returning connection to the pool", e);
        }
        return new PooledConnection(connection);
    }

    public ObjectPoolFactory<?> getPoolFactory() {
        return null;
    }

    protected BESMQConnection createConnection(ConnectionKey key) throws JMSException {
        if (key.getUserName() == null && key.getPassword() == null) {
            return (BESMQConnection)this.connectionFactory.createConnection();
        }
        return (BESMQConnection)this.connectionFactory.createConnection(key.getUserName(), key.getPassword());
    }

    @Override
    public void start() {
        this.stopped.set(false);
    }

    @Override
    public void stop() {
        LOG.debug("Stopping the PooledConnectionFactory, number of connections in cache: {}", this.connectionsPool.getNumActive());
        if (this.stopped.compareAndSet(false, true)) {
            try {
                this.connectionsPool.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void clear() {
        if (this.stopped.get()) {
            return;
        }
        this.connectionsPool.clear();
    }

    @Deprecated
    public int getMaximumActive() {
        return this.getMaxSessionsPerConnection();
    }

    @Deprecated
    public void setMaximumActive(int maximumActive) {
        this.setMaxSessionsPerConnection(maximumActive);
    }

    public int getMaxSessionsPerConnection() {
        return this.maxSessionsPerConnection;
    }

    public void setMaxSessionsPerConnection(int maxSessionsPerConnection) {
        this.maxSessionsPerConnection = maxSessionsPerConnection;
    }

    public void setBlockClient(boolean block) {
        this.blockClient = block;
    }

    public boolean isBlockClient() {
        return this.blockClient;
    }

    public int getMaxConnections() {
        return this.connectionsPool.getMaxIdle();
    }

    public void setMaxConnections(int maxConnections) {
        this.connectionsPool.setMaxIdle(maxConnections);
    }

    public int getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(int idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    KeyedObjectPool<ConnectionKey, ConnectionPool> getConnectionsPool() {
        return this.connectionsPool;
    }

    public void setCheckPeriod(long checkPeriod) {
        this.connectionsPool.setTimeBetweenEvictionRunsMillis(checkPeriod);
    }

    public long getCheckPeriod() {
        return this.connectionsPool.getTimeBetweenEvictionRunsMillis();
    }

    public int getNumConnections() {
        return this.connectionsPool.getNumIdle();
    }

    public void setPoolFactory(ObjectPoolFactory<?> factory) {
    }

    public long getLeakTimeout() {
        return this.connectionsPool.getMinEvictableIdleTimeMillis();
    }

    public void setLeakTimeout(long leakTimeout) {
        this.connectionsPool.setMinEvictableIdleTimeMillis(leakTimeout);
    }
}

