/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.pool;

import com.bes.mq.BESMQMessageProducer;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;

public class PooledProducer
implements MessageProducer {
    private final BESMQMessageProducer messageProducer;
    private final Destination destination;
    private int deliveryMode;
    private boolean disableMessageID;
    private boolean disableMessageTimestamp;
    private int priority;
    private long timeToLive;

    public PooledProducer(BESMQMessageProducer messageProducer, Destination destination) throws JMSException {
        this.messageProducer = messageProducer;
        this.destination = destination;
        this.deliveryMode = messageProducer.getDeliveryMode();
        this.disableMessageID = messageProducer.getDisableMessageID();
        this.disableMessageTimestamp = messageProducer.getDisableMessageTimestamp();
        this.priority = messageProducer.getPriority();
        this.timeToLive = messageProducer.getTimeToLive();
    }

    @Override
    public void close() throws JMSException {
    }

    @Override
    public void send(Destination destination, Message message) throws JMSException {
        this.send(destination, message, this.getDeliveryMode(), this.getPriority(), this.getTimeToLive());
    }

    @Override
    public void send(Message message) throws JMSException {
        this.send(this.destination, message, this.getDeliveryMode(), this.getPriority(), this.getTimeToLive());
    }

    @Override
    public void send(Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.send(this.destination, message, deliveryMode, priority, timeToLive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(Destination destination, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        BESMQMessageProducer messageProducer;
        if (destination == null) {
            destination = this.destination;
        }
        BESMQMessageProducer bESMQMessageProducer = messageProducer = this.getMessageProducer();
        synchronized (bESMQMessageProducer) {
            messageProducer.send(destination, message, deliveryMode, priority, timeToLive);
        }
    }

    @Override
    public Destination getDestination() {
        return this.destination;
    }

    @Override
    public int getDeliveryMode() {
        return this.deliveryMode;
    }

    @Override
    public void setDeliveryMode(int deliveryMode) {
        this.deliveryMode = deliveryMode;
    }

    @Override
    public boolean getDisableMessageID() {
        return this.disableMessageID;
    }

    @Override
    public void setDisableMessageID(boolean disableMessageID) {
        this.disableMessageID = disableMessageID;
    }

    @Override
    public boolean getDisableMessageTimestamp() {
        return this.disableMessageTimestamp;
    }

    @Override
    public void setDisableMessageTimestamp(boolean disableMessageTimestamp) {
        this.disableMessageTimestamp = disableMessageTimestamp;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int priority) {
        this.priority = priority;
    }

    @Override
    public long getTimeToLive() {
        return this.timeToLive;
    }

    @Override
    public void setTimeToLive(long timeToLive) {
        this.timeToLive = timeToLive;
    }

    protected BESMQMessageProducer getMessageProducer() {
        return this.messageProducer;
    }

    public String toString() {
        return "PooledProducer { " + this.messageProducer + " }";
    }
}

