/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.protocolformat;

import com.bes.mq.protocolformat.ProtocolFormat;
import com.bes.mq.util.ByteArrayInputStream;
import com.bes.mq.util.ByteArrayOutputStream;
import com.bes.mq.util.ByteSequence;
import com.bes.mq.util.ClassLoadingAwareObjectInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;

public class ObjectStreamProtocolFormat
implements ProtocolFormat {
    public ByteSequence marshal(Object command) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream ds = new DataOutputStream(baos);
        this.marshal(command, ds);
        ds.close();
        return baos.toByteSequence();
    }

    public Object unmarshal(ByteSequence packet) throws IOException {
        return this.unmarshal(new DataInputStream(new ByteArrayInputStream(packet)));
    }

    public void marshal(Object command, DataOutput ds) throws IOException {
        ObjectOutputStream out = new ObjectOutputStream((OutputStream)((Object)ds));
        out.writeObject(command);
        out.flush();
        out.reset();
    }

    public Object unmarshal(DataInput ds) throws IOException {
        try {
            ClassLoadingAwareObjectInputStream in = new ClassLoadingAwareObjectInputStream((InputStream)((Object)ds));
            Object command = in.readObject();
            in.close();
            return command;
        }
        catch (ClassNotFoundException e) {
            throw (IOException)new IOException("Unmarshal failed: " + e).initCause(e);
        }
    }

    public void setVersion(int version) {
    }

    public int getVersion() {
        return 0;
    }
}

