/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.proxy;

import com.bes.mq.Service;
import com.bes.mq.command.ProtocolFormatInfo;
import com.bes.mq.command.ShutdownInfo;
import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;
import com.bes.mq.transport.DefaultTransportListener;
import com.bes.mq.transport.Transport;
import com.bes.mq.util.IOExceptionSupport;
import com.bes.mq.util.ServiceStopper;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;

class ProxyConnection
implements Service {
    private static final Logger LOG = LoggerFactory.getLogger(ProxyConnection.class);
    private final Transport localTransport;
    private final Transport remoteTransport;
    private AtomicBoolean shuttingDown = new AtomicBoolean(false);
    private AtomicBoolean running = new AtomicBoolean(false);

    public ProxyConnection(Transport localTransport, Transport remoteTransport) {
        this.localTransport = localTransport;
        this.remoteTransport = remoteTransport;
    }

    public void onFailure(IOException e) {
        if (!this.shuttingDown.get()) {
            LOG.debug("Transport error: " + e, e);
            try {
                this.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void start() throws Exception {
        if (!this.running.compareAndSet(false, true)) {
            return;
        }
        this.localTransport.setTransportListener(new DefaultTransportListener(){

            public void onCommand(Object command) {
                boolean shutdown = false;
                if (command.getClass() == ShutdownInfo.class) {
                    ProxyConnection.this.shuttingDown.set(true);
                    shutdown = true;
                }
                if (command.getClass() == ProtocolFormatInfo.class) {
                    return;
                }
                try {
                    ProxyConnection.this.remoteTransport.oneway(command);
                    if (shutdown) {
                        ProxyConnection.this.stop();
                    }
                }
                catch (IOException error) {
                    ProxyConnection.this.onFailure(error);
                }
                catch (Exception error) {
                    ProxyConnection.this.onFailure(IOExceptionSupport.create(error));
                }
            }

            public void onException(IOException error) {
                ProxyConnection.this.onFailure(error);
            }
        });
        this.remoteTransport.setTransportListener(new DefaultTransportListener(){

            public void onCommand(Object command) {
                try {
                    if (command.getClass() == ProtocolFormatInfo.class) {
                        return;
                    }
                    ProxyConnection.this.localTransport.oneway(command);
                }
                catch (IOException error) {
                    ProxyConnection.this.onFailure(error);
                }
            }

            public void onException(IOException error) {
                ProxyConnection.this.onFailure(error);
            }
        });
        this.localTransport.start();
        this.remoteTransport.start();
    }

    public void stop() throws Exception {
        if (!this.running.compareAndSet(true, false)) {
            return;
        }
        this.shuttingDown.set(true);
        ServiceStopper ss = new ServiceStopper();
        ss.stop(this.localTransport);
        ss.stop(this.remoteTransport);
        ss.throwFirstException();
    }
}

